/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.tagmgr.report;

import com.ovopark.device.modules.tagmgr.mysql.DeviceTagRefMapper;
import com.ovopark.device.modules.tagmgr.report.DeviceTagVoExcel;
import com.ovopark.device.modules.tagmgr.vo.DeviceTagListQuery;
import com.ovopark.device.modules.tagmgr.vo.DeviceTagVo;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/deviceTag")
public class DeviceTagReport
implements JobOutTaskFlow<DeviceTagListQuery> {
    private static final Logger log = LoggerFactory.getLogger(DeviceTagReport.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DeviceTagRefMapper deviceTagRefMapper;
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private OnlineFacade onlineFacade;

    public DeviceTagListQuery requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        DeviceTagListQuery paramMo = new DeviceTagListQuery();
        if (requestBody != null) {
            paramMo = (DeviceTagListQuery)((Object)JSONAccessor.impl().read(requestBody, DeviceTagListQuery.class));
        }
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setSessionUserId(session.getUserId());
        paramMo.setSessionGroupId(session.getGroupId());
        return paramMo;
    }

    public void execute(DeviceTagListQuery requestParamBody, OutStore outStore) {
        Integer sessionGroupId = requestParamBody.getSessionGroupId();
        Locale locale = requestParamBody.getLocale();
        OutStore.SegmentWriter segment = outStore.createSegment("\u5206\u7ec4\u5217\u8868");
        List<DeviceTagVo> list = this.deviceTagRefMapper.listDeviceRef(sessionGroupId, null, null);
        Util.logLink((String)("custom tag device count: " + list.size())).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((LimitLogger)outStore.limitLogger()).log(arg_0));
        List<DeviceTagVo> deviceTagVoList = this.deviceTagRefMapper.listDeviceRefNotAssigned(sessionGroupId, null, null);
        Util.logLink((String)("default tag device count: " + list.size())).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((LimitLogger)outStore.limitLogger()).log(arg_0));
        for (DeviceTagVo deviceTagVo : deviceTagVoList) {
            deviceTagVo.setTagName("\u9ed8\u8ba4\u5206\u7ec4");
        }
        if (Util.isNotEmpty(deviceTagVoList)) {
            list.addAll(deviceTagVoList);
        }
        Map onOffNRT = this.onlineFacade.onOffNRT(list.stream().map(DeviceTagVo::getDeviceStatusId).toList());
        segment.header().all(DeviceTagVoExcel.class, path -> this.messageSource.getMessage(path, null, locale));
        List<Integer> deptIdList = list.stream().map(DeviceTagVo::getDeptId).toList();
        List departmentList = this.rpcFacade.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> deptMap = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        for (DeviceTagVo deviceTagVo : list) {
            DeviceTagVoExcel deviceTagVoExcel = new DeviceTagVoExcel();
            BeanUtils.copyProperties((Object)deviceTagVo, (Object)deviceTagVoExcel);
            DepartmentPojo departmentPojo = deptMap.get(deviceTagVoExcel.getDeptId());
            if (departmentPojo != null) {
                deviceTagVoExcel.setDeptName(departmentPojo.getName());
            }
            deviceTagVoExcel.setOnOffStatusStr(Util.compare2((Comparable)((Comparable)onOffNRT.get(deviceTagVo.getDeviceStatusId())), (Comparable)Integer.valueOf(1)) == 0 ? "\u5728\u7ebf" : "\u79bb\u7ebf");
            segment.append((Model)deviceTagVoExcel);
        }
        segment.commit();
    }
}

