/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.alert;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.modules.alert.DeviceAlertConfigService;
import com.ovopark.device.modules.alert.DeviceOfflineCnf;
import com.ovopark.device.modules.alert.DeviceReidCnf;
import com.ovopark.device.modules.alert.DeviceVideoCnf;
import com.ovopark.device.modules.alert.OfflineDeviceRuleService;
import com.ovopark.device.modules.alert.mo.ConfigureDeviceTimeMo;
import com.ovopark.device.modules.alert.mysql.DBTableId;
import com.ovopark.device.modules.alert.mysql.DBTableIdMapper;
import com.ovopark.device.modules.alert.mysql.DeviceAlertConfigTask;
import com.ovopark.device.modules.alert.mysql.DeviceAlertConfigTaskMapper;
import com.ovopark.device.modules.alert.mysql.DeviceAlertConfigView;
import com.ovopark.device.modules.alert.mysql.DeviceAlertConfigViewMapper;
import com.ovopark.device.modules.alert.mysql.DeviceAlertStatusDetail;
import com.ovopark.device.modules.alert.mysql.DeviceAlertStatusDetailMapper;
import com.ovopark.device.modules.alert.mysql.DeviceAlertUser;
import com.ovopark.device.modules.alert.mysql.DeviceAlertUserMapper;
import com.ovopark.device.modules.alert.mysql.OfflineDeviceRule;
import com.ovopark.device.modules.alert.vo.OfflineAlertConfigVo;
import com.ovopark.device.modules.alert.vo.ReidConfigVo;
import com.ovopark.device.modules.alert.vo.VideoAlertConfigVo;
import com.ovopark.device.modules.platform.DeviceSharedConfig;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.platform.mysql.PlatformsMapper;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.sdk.common.model.EventOnOff;
import com.ovopark.device.thirdparty.ovoIot.model.AlarmConfig;
import com.ovopark.device.thirdparty.ovoIot.model.GetDevTimeCfgRes;
import com.ovopark.device.thirdparty.ovoIot.model.ResultRes;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetDevTimeCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetNvrAlarmCfg;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetPflowReidCfgReq;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.device.thirdparty.ovoIot.service.Pc8Service;
import com.ovopark.device.thirdparty.ovoIot.util.AbilityUtil;
import com.ovopark.device.thirdparty.ovoIot.util.VersionConstant;
import com.ovopark.eventhub.sdk.DeviceLogEventService;
import com.ovopark.eventhub.sdk.model.DeviceLogType;
import com.ovopark.eventhub.sdk.model.DevicePart;
import com.ovopark.eventhub.sdk.model.OpeLogPut;
import com.ovopark.eventhub.sdk.model.OpeSource;
import com.ovopark.eventhub.sdk.model.SessionPart;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.model.JobStatus;
import com.ovopark.jobhub.sdk.model.JobType;
import com.ovopark.jobhub.sdk.model.TaskCreateRequest;
import com.ovopark.jobhub.sdk.model.TaskCreateResponse;
import com.ovopark.jobhub.sdk.model.TaskUpdateRequest;
import com.ovopark.jobhub.sdk.model.TaskUpdateResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceAlertConfigServiceImpl
implements DeviceAlertConfigService {
    private static final Logger log = LoggerFactory.getLogger(DeviceAlertConfigServiceImpl.class);
    @Autowired
    private DBTableIdMapper dbTableIdMapper;
    @Autowired
    private DeviceAlertConfigTaskMapper deviceAlertConfigTaskMapper;
    @Autowired
    private RPCFacade rpcFacade;
    @Resource
    private UserDepartmentApi userDepartmentApi;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Resource
    private DeviceAlertStatusDetailMapper deviceAlertStatusDetailMapper;
    @Autowired
    private OfflineDeviceRuleService offlineDeviceRuleService;
    @Autowired
    private DeviceAlertUserMapper deviceAlertUserMapper;
    @Autowired
    private LogApi logApi;
    @Autowired
    private DeviceLogEventService deviceLogEventService;
    @Autowired
    private PlatformsMapper platformsMapper;
    @Autowired
    @Qualifier(value="kafkaMainTemplate")
    private KafkaTemplate kafkaTemplate;
    @Autowired
    private NvrService nvrService;
    @Autowired
    private DeviceSharedConfig deviceSharedConfig;
    @Autowired
    private Pc8Service pc8Service;
    public static final ExecutorService offConfigExecutor = new ThreadPoolExecutor(200, 200, 600L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"off-configure"), new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private DeviceAlertConfigViewMapper deviceAlertConfigViewMapper;
    @Autowired
    private JobService jobService;

    @Override
    public void preConfigureDeviceTime(Integer usrId, ConfigureDeviceTimeMo mo) {
        log.info("dfdsfdfdf");
        List depList = this.rpcFacade.getUserPrivilegeDepByOrganizeIds(usrId, mo.getGroupId(), mo.getOrgIdList());
        if (CollectionUtils.isEmpty((Collection)depList)) {
            return;
        }
        List<DeviceStatus> deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getIsGbDevice, (Object)0)).eq(DeviceStatus::getGroupId, (Object)mo.getGroupId())).isNull(DeviceStatus::getPId)).isNotNull(DeviceStatus::getPlatformId)).in(DeviceStatus::getDepId, depList.stream().map(DepartmentOrgMo::getDepId).toList()));
        deviceStatusList = deviceStatusList.stream().filter(item -> AbilityUtil.supportDeviceTimeCnf((Integer)item.getDType(), (String)item.getExtendCapacity())).collect(Collectors.toList());
        this.processDeviceStatus(deviceStatusList, mo);
    }

    private Void processDeviceItem(DeviceStatus item, ConfigureDeviceTimeMo mo) {
        try {
            Integer platformId = item.getPlatformId();
            Platforms platform = (Platforms)this.platformsMapper.selectById(platformId);
            SetDevTimeCfgReq req = new SetDevTimeCfgReq();
            req.setTimeZone(mo.getTimeZone());
            req.setDstEnable(mo.getSummerTimeFlag());
            SetDevTimeCfgReq.DstCfgBean cfgBean = new SetDevTimeCfgReq.DstCfgBean();
            Object summerTimeStart = mo.getSummerTimeStart();
            Object summerTimeEnd = mo.getSummerTimeEnd();
            if (StringUtils.isNotEmpty((CharSequence)summerTimeStart) && StringUtils.contains((CharSequence)summerTimeStart, (CharSequence)"null")) {
                summerTimeStart = null;
            }
            if (StringUtils.isNotEmpty((CharSequence)summerTimeEnd) && StringUtils.contains((CharSequence)summerTimeEnd, (CharSequence)"null")) {
                summerTimeEnd = null;
            }
            if (Util.compare2((Comparable)mo.getSummerTimeFlag(), (Comparable)Integer.valueOf(0)) == 0 && (Util.isEmpty((CharSequence)summerTimeStart) || Util.isEmpty((CharSequence)summerTimeEnd))) {
                try {
                    SetDevTimeCfgReq.DstCfgBean dstCfg;
                    log.info("setDeviceTime, to get device time cfg from device");
                    GetDevTimeCfgRes devTimeCfg = this.getDevTimeCfg(item.getId());
                    log.info("setDeviceTime, get device time cfg: " + JSONAccessor.impl().format((Object)devTimeCfg));
                    if (devTimeCfg != null && (dstCfg = devTimeCfg.getDstCfg()) != null) {
                        SetDevTimeCfgReq.DstCfgBean.TimeBean beginTime = dstCfg.getBeginTime();
                        SetDevTimeCfgReq.DstCfgBean.TimeBean endTime = dstCfg.getEndTime();
                        summerTimeStart = beginTime.getMonth() + "-" + beginTime.getWeekNum() + "-" + beginTime.getWeekDay() + "-" + beginTime.getHour() + ":00";
                        summerTimeEnd = endTime.getMonth() + "-" + endTime.getWeekNum() + "-" + endTime.getWeekDay() + "-" + endTime.getHour() + ":00";
                    }
                }
                catch (Exception e) {
                    log.error("setDeviceTime: " + e.getMessage(), (Throwable)e);
                }
                summerTimeStart = Util.isNotEmpty((CharSequence)summerTimeStart) ? summerTimeStart : "1-1-1-00:00";
                Object object = summerTimeEnd = Util.isNotEmpty((CharSequence)summerTimeEnd) ? summerTimeEnd : "7-1-1-00:00";
            }
            if (StringUtils.isNotEmpty((CharSequence)summerTimeStart)) {
                String[] split = ((String)summerTimeStart).split("-");
                SetDevTimeCfgReq.DstCfgBean.TimeBean beginTimeBean = new SetDevTimeCfgReq.DstCfgBean.TimeBean();
                beginTimeBean.setMonth(Integer.valueOf(Integer.parseInt(split[0])));
                beginTimeBean.setWeekNum(Integer.valueOf(Integer.parseInt(split[1])));
                beginTimeBean.setWeekDay(Integer.valueOf(Integer.parseInt(split[2])));
                beginTimeBean.setHour(Integer.valueOf(Integer.parseInt(split[3].split(":")[0])));
                cfgBean.setBeginTime(beginTimeBean);
            }
            if (StringUtils.isNotEmpty((CharSequence)summerTimeEnd)) {
                SetDevTimeCfgReq.DstCfgBean.TimeBean endTimeBean = new SetDevTimeCfgReq.DstCfgBean.TimeBean();
                String[] split = ((String)summerTimeEnd).split("-");
                endTimeBean.setMonth(Integer.valueOf(Integer.parseInt(split[0])));
                endTimeBean.setWeekNum(Integer.valueOf(Integer.parseInt(split[1])));
                endTimeBean.setWeekDay(Integer.valueOf(Integer.parseInt(split[2])));
                endTimeBean.setHour(Integer.valueOf(Integer.parseInt(split[3].split(":")[0])));
                cfgBean.setEndTime(endTimeBean);
            }
            cfgBean.setDstBias(Integer.valueOf(60));
            req.setDstCfg(cfgBean);
            this.nvrService.setDevTimeCfg(item.getMac(), req, platform.getUpgradeServer(), platform.getUpgradePort(), platform.getNewDmsFlag());
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8bbe\u5907 {} \u5931\u8d25: {}", (Object)item.getMac(), (Object)e.getMessage());
        }
        return null;
    }

    public void processDeviceStatus(List<DeviceStatus> deviceStatusList, ConfigureDeviceTimeMo mo) {
        if (CollectionUtils.isEmpty(deviceStatusList)) {
            log.warn("\u8bbe\u5907\u72b6\u6001\u5217\u8868\u4e3a\u7a7a");
            return;
        }
        String requestId = this.traceId();
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            MDC.put((String)"requestId", (String)requestId);
            List<CompletableFuture> futures = deviceStatusList.stream().map(item -> CompletableFuture.runAsync(() -> {
                try {
                    MDC.put((String)"requestId", (String)requestId);
                    this.processDeviceItem((DeviceStatus)item, mo);
                }
                finally {
                    MDC.clear();
                }
            }, executor)).toList();
            ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).exceptionally(throwable -> {
                log.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25", throwable);
                return null;
            })).join();
            List<Exception> failures = futures.stream().filter(f -> f.isCompletedExceptionally()).map(f -> {
                try {
                    f.join();
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            }).filter(Objects::nonNull).toList();
            if (!failures.isEmpty()) {
                String errorMsg = String.format("\u5904\u7406\u5931\u8d25: \u603b\u4efb\u52a1\u6570 %d, \u5931\u8d25\u6570 %d", deviceStatusList.size(), failures.size());
                log.error(errorMsg);
                throw new CommonException(com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum.DEVICE_ERROR, errorMsg);
            }
        }
    }

    public GetDevTimeCfgRes getDevTimeCfg(Integer deviceStatusId) {
        DeviceStatus deviceStatus = Optional.ofNullable((DeviceStatus)this.deviceStatusMapper.selectById(deviceStatusId)).orElseThrow(() -> new com.ovopark.device.common.util.CommonException(ExceptionEnum.DEVICE_NOT_EXIST));
        if (deviceStatus.getIsDelete() == 1) {
            throw new com.ovopark.device.common.util.CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        Integer platformId = deviceStatus.getPlatformId();
        Integer pId = deviceStatus.getPId();
        Integer isGbDevice = deviceStatus.getIsGbDevice();
        if (platformId == null || pId != null || isGbDevice == 1 || !AbilityUtil.supportDeviceTimeCnf((Integer)deviceStatus.getDType(), (String)deviceStatus.getExtendCapacity())) {
            throw new com.ovopark.device.common.util.CommonException(ExceptionEnum.NOT_SUPPORT);
        }
        Platforms platforms = Optional.ofNullable((Platforms)this.platformsMapper.selectById(platformId)).orElseThrow(() -> new com.ovopark.device.common.util.CommonException(ExceptionEnum.PLATFORM_NOT_EXIST));
        return this.nvrService.getDevTimeCfg(deviceStatus.getMac(), platforms.getUpgradeServer(), platforms.getUpgradePort(), platforms.getNewDmsFlag());
    }

    @Override
    public OfflineAlertConfigVo offlineConfigView(Integer deviceStatusId) {
        long applyConfigVer;
        DeviceAlertConfigView deviceAlertConfigView;
        DeviceAlertConfigTask deviceAlertConfigTask = (DeviceAlertConfigTask)this.deviceAlertConfigTaskMapper.selectById(deviceStatusId);
        if (deviceAlertConfigTask != null && (deviceAlertConfigView = (DeviceAlertConfigView)this.deviceAlertConfigViewMapper.selectById(Long.valueOf(applyConfigVer = deviceAlertConfigTask.getApplyConfigVer()))) != null) {
            OfflineAlertConfigVo offlineAlertConfigVo = (OfflineAlertConfigVo)JSONAccessor.impl().read(deviceAlertConfigView.getConfigViewJson(), OfflineAlertConfigVo.class);
            this.setOtherVal(offlineAlertConfigVo);
            return offlineAlertConfigVo;
        }
        DeviceStatus deviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(deviceStatusId);
        log.info("cannot find new config , old device ???: " + JSONAccessor.impl().format((Object)deviceStatus));
        List deviceAlertStatusDetails = this.deviceAlertStatusDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(DeviceAlertStatusDetail::getDeviceStatusId, (Object)deviceStatusId));
        if (Util.isEmpty((Collection)deviceAlertStatusDetails)) {
            log.info("cannot find any config ");
            return null;
        }
        DeviceAlertStatusDetail deviceAlertStatusDetail = (DeviceAlertStatusDetail)deviceAlertStatusDetails.getFirst();
        int offLineAlarmStatus = deviceAlertStatusDetail.getOffLineAlarmStatus();
        log.info("offline is closed(" + (offLineAlarmStatus == 0) + ")? " + JSONAccessor.impl().format((Object)deviceAlertStatusDetail));
        OfflineAlertConfigVo offlineAlertConfigVo = new OfflineAlertConfigVo();
        offlineAlertConfigVo.setDeviceStatusId(deviceAlertStatusDetail.getDeviceStatusId());
        offlineAlertConfigVo.setShopUserSelectFlag(true);
        List deviceAlertUserList = this.deviceAlertUserMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceAlertUser.class).eq(DeviceAlertUser::getDeviceId, (Object)deviceStatusId)).eq(DeviceAlertUser::getIsDelete, (Object)0));
        if (Util.isNotEmpty((Collection)deviceAlertUserList)) {
            offlineAlertConfigVo.setShopUserSelectList(deviceAlertUserList.stream().map(DeviceAlertUser::getUserId).toList());
        }
        offlineAlertConfigVo.setUserMailNotifyFlag(Util.compare2((Comparable)deviceAlertStatusDetail.getOfflineUserMail(), (Comparable)Integer.valueOf(1)) == 0);
        OfflineDeviceRule offlineDeviceRule = this.offlineDeviceRuleService.ruleAtDevice(deviceStatusId);
        if (offlineDeviceRule != null) {
            offlineAlertConfigVo.setSecondPushFlag(true);
            offlineAlertConfigVo.setSecondPushHour((Integer)Util.convert2Self((Object)offlineDeviceRule.getTimeMin(), (Object)0) / 60);
            List<Integer> secondPushUserSelectList = this.offlineDeviceRuleService.userIdsAtDevice(deviceStatusId);
            offlineAlertConfigVo.setSecondPushUserSelectList(secondPushUserSelectList);
        }
        offlineAlertConfigVo.setBusinessTimeFlag(Util.compare2((Comparable)deviceStatus.getBusinessTimeInherit(), (Comparable)Integer.valueOf(1)) == 0);
        offlineAlertConfigVo.setStartHourTime(deviceStatus.getStartTimeStr());
        offlineAlertConfigVo.setEndHourTime(deviceStatus.getEndTimeStr());
        offlineAlertConfigVo.setShopMailNotifyFlag(Util.compare2((Comparable)deviceAlertStatusDetail.getOfflineDeptMail(), (Comparable)Integer.valueOf(1)) == 0);
        this.setOtherVal(offlineAlertConfigVo);
        return offlineAlertConfigVo;
    }

    private void setOtherVal(OfflineAlertConfigVo offlineAlertConfigVo) {
        OfflineAlertConfigVo.UserInfo userInfo;
        ArrayList<OfflineAlertConfigVo.UserInfo> userInfoList;
        List useredList;
        if (Util.isNotEmpty(offlineAlertConfigVo.getShopUserSelectList())) {
            useredList = this.rpcFacade.userList(offlineAlertConfigVo.getShopUserSelectList());
            userInfoList = new ArrayList<OfflineAlertConfigVo.UserInfo>();
            for (UsersPojo usersPojo : useredList) {
                userInfo = new OfflineAlertConfigVo.UserInfo();
                userInfo.setId(usersPojo.getId());
                userInfo.setShowName(usersPojo.getShowName());
                userInfo.setUserName(usersPojo.getUserName());
                userInfoList.add(userInfo);
            }
            offlineAlertConfigVo.setShopUserSelectListName(userInfoList);
        }
        if (Util.isNotEmpty(offlineAlertConfigVo.getSecondPushUserSelectList())) {
            useredList = this.rpcFacade.userList(offlineAlertConfigVo.getSecondPushUserSelectList());
            userInfoList = new ArrayList();
            for (UsersPojo usersPojo : useredList) {
                userInfo = new OfflineAlertConfigVo.UserInfo();
                userInfo.setId(usersPojo.getId());
                userInfo.setShowName(usersPojo.getShowName());
                userInfo.setUserName(usersPojo.getUserName());
                userInfoList.add(userInfo);
            }
            offlineAlertConfigVo.setSecondPushUserSelectListName(userInfoList);
        }
    }

    @Override
    @Transactional
    public void preConfigureOffline(final OfflineAlertConfigVo offlineAlertConfigVo) {
        final List<String> deptList = offlineAlertConfigVo.getDeptList();
        final Integer deviceStatusId = offlineAlertConfigVo.getDeviceStatusId();
        if (Util.isEmpty(deptList) && deviceStatusId == null) {
            return;
        }
        final Session session = Session.getOrCreate().get();
        final Integer userId = session.getUserId();
        DBTableId dbTableId = new DBTableId();
        this.dbTableIdMapper.insert(dbTableId);
        final Long taskId = dbTableId.getId();
        List<Integer> roleSelectList = offlineAlertConfigVo.getShopRoleSelectList();
        Integer groupId = session.getGroupId();
        final ArrayList userListInRole = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("roleIds", roleSelectList);
        map.put("groupId", groupId);
        Map listMap = this.rpcFacade.getUserMapByRoleIds(map);
        if (listMap != null) {
            List data = listMap.values().stream().flatMap(Collection::stream).map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
            userListInRole.addAll(data);
        }
        DeviceAlertConfigView deviceAlertConfigView = new DeviceAlertConfigView();
        deviceAlertConfigView.setId(taskId);
        deviceAlertConfigView.setConfigViewJson(JSONAccessor.impl().format((Object)offlineAlertConfigVo));
        this.deviceAlertConfigViewMapper.insert(deviceAlertConfigView);
        offConfigExecutor.execute(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){

            public void run() throws Exception {
                List deviceStatusList;
                List<Integer> realDeptList;
                if (Util.isNotEmpty((Collection)deptList)) {
                    List list = DeviceAlertConfigServiceImpl.this.rpcFacade.getUserPrivilegeDepByOrganizeIds(userId, session.getGroupId(), deptList);
                    if (Util.isEmpty((Collection)list)) {
                        return;
                    }
                    realDeptList = list.stream().map(DepartmentOrgMo::getDepId).toList();
                    deviceStatusList = DeviceAlertConfigServiceImpl.this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeviceStatus::getDepId, realDeptList)).eq(DeviceStatus::getIsDelete, (Object)0));
                    if (Util.isEmpty((Collection)deviceStatusList)) {
                        log.info("cannot find any device, dept id: " + JSONAccessor.impl().format(realDeptList));
                        return;
                    }
                } else {
                    DeviceStatus deviceStatus = (DeviceStatus)DeviceAlertConfigServiceImpl.this.deviceStatusMapper.selectById(deviceStatusId);
                    if (deviceStatus == null) {
                        return;
                    }
                    deviceStatusList = Arrays.asList(deviceStatus);
                    realDeptList = Arrays.asList(deviceStatus.getDepId());
                }
                if (Util.isEmpty(deviceStatusList)) {
                    log.info("cannot find any device: " + JSONAccessor.impl().format((Object)offlineAlertConfigVo));
                    return;
                }
                HashMap<Integer, List<Integer>> deptManagerMap = new HashMap<Integer, List<Integer>>();
                for (Integer deptId : realDeptList) {
                    BaseResult depUserIds = DeviceAlertConfigServiceImpl.this.userDepartmentApi.getDepUserIds(deptId, Integer.valueOf(1));
                    if (depUserIds == null || depUserIds.getData() == null) continue;
                    deptManagerMap.computeIfAbsent(deptId, new Function<Integer, List<Integer>>(this){

                        @Override
                        public List<Integer> apply(Integer integer) {
                            return new ArrayList<Integer>();
                        }
                    }).addAll((Collection)depUserIds.getData());
                }
                for (DeviceStatus deviceStatus : deviceStatusList) {
                    if (deviceStatus.getDType() != null && (VersionConstant.iotDev.contains(deviceStatus.getDType()) || VersionConstant.iot.contains(deviceStatus.getDType()))) continue;
                    boolean pushKafka = false;
                    DeviceAlertConfigTask configTask = (DeviceAlertConfigTask)DeviceAlertConfigServiceImpl.this.deviceAlertConfigTaskMapper.selectById(deviceStatus.getId());
                    if (configTask == null) {
                        configTask = new DeviceAlertConfigTask();
                        configTask.setDeviceStatusId(deviceStatus.getId());
                        configTask.setConfigVer(taskId);
                        DeviceAlertConfigServiceImpl.this.deviceAlertConfigTaskMapper.insert(configTask);
                        pushKafka = true;
                    } else {
                        int updated = DeviceAlertConfigServiceImpl.this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatus.getId())).eq(DeviceAlertConfigTask::getConfigVer, (Object)configTask.getConfigVer())).set(DeviceAlertConfigTask::getConfigVer, (Object)taskId));
                        if (updated == 1) {
                            pushKafka = true;
                        }
                    }
                    if (!pushKafka) continue;
                    TaskCreateRequest taskCreateRequest = new TaskCreateRequest();
                    taskCreateRequest.setDeviceStatusId(deviceStatus.getId());
                    taskCreateRequest.setType(JobType.offlineConfigure.name());
                    taskCreateRequest.setGroupId(deviceStatus.getGroupId());
                    taskCreateRequest.setStatus(JobStatus.INIT.name());
                    taskCreateRequest.setDesc("push kafka");
                    taskCreateRequest.setUserId(userId);
                    taskCreateRequest.setJsonStr(JSONAccessor.impl().format((Object)offlineAlertConfigVo));
                    TaskCreateResponse taskCreateResponse = DeviceAlertConfigServiceImpl.this.jobService.taskCreate(taskCreateRequest);
                    log.info("taskCreateResponse: " + JSONAccessor.impl().format((Object)taskCreateResponse));
                    String taskIdInES = taskCreateResponse != null ? taskCreateResponse.getId() : null;
                    DeviceOfflineCnf deviceOfflineCnf = new DeviceOfflineCnf();
                    deviceOfflineCnf.setTraceId(DeviceAlertConfigServiceImpl.this.traceId());
                    deviceOfflineCnf.setDeviceStatusId(deviceStatus.getId());
                    deviceOfflineCnf.setMac(deviceStatus.getMac());
                    deviceOfflineCnf.setEnabledFlag(offlineAlertConfigVo.isEnabledFlag());
                    deviceOfflineCnf.setShopManagerFlag(offlineAlertConfigVo.isShopManagerFlag());
                    deviceOfflineCnf.setShopUserSelectFlag(offlineAlertConfigVo.isShopUserSelectFlag());
                    ArrayList<Integer> userSelectList = new ArrayList<Integer>();
                    if (deviceOfflineCnf.isShopManagerFlag()) {
                        userSelectList.addAll((Collection)deptManagerMap.get(deviceStatus.getDepId()));
                    }
                    if (deviceOfflineCnf.isShopUserSelectFlag()) {
                        ArrayList<Integer> shopUserSelectList = new ArrayList<Integer>();
                        shopUserSelectList.addAll(offlineAlertConfigVo.getShopUserSelectList());
                        shopUserSelectList.addAll(userListInRole);
                        userSelectList.addAll(shopUserSelectList);
                    }
                    deviceOfflineCnf.setShopUserSelectList(userSelectList);
                    deviceOfflineCnf.setUserMailNotifyFlag(offlineAlertConfigVo.isUserMailNotifyFlag());
                    deviceOfflineCnf.setUserMailNotifyFlag4Shop(offlineAlertConfigVo.isUserMailNotifyFlag4Shop());
                    deviceOfflineCnf.setSecondPushFlag(offlineAlertConfigVo.isSecondPushFlag());
                    deviceOfflineCnf.setSecondPushHour(offlineAlertConfigVo.getSecondPushHour());
                    deviceOfflineCnf.setSecondPushUserSelectList(offlineAlertConfigVo.getSecondPushUserSelectList());
                    deviceOfflineCnf.setBusinessTimeFlag(offlineAlertConfigVo.isBusinessTimeFlag());
                    deviceOfflineCnf.setStartHourTime(offlineAlertConfigVo.getStartHourTime());
                    deviceOfflineCnf.setEndHourTime(offlineAlertConfigVo.getEndHourTime());
                    deviceOfflineCnf.setShopMailNotifyFlag(offlineAlertConfigVo.isShopMailNotifyFlag());
                    deviceOfflineCnf.setConfigVer(taskId);
                    deviceOfflineCnf.setTaskIdInES(taskIdInES);
                    CompletableFuture future = DeviceAlertConfigServiceImpl.this.kafkaTemplate.send("device-alert-configure", (Object)String.valueOf(deviceOfflineCnf.getDeviceStatusId()), (Object)JSONAccessor.impl().format((Object)deviceOfflineCnf));
                    future.handleAsync(new BiFunction<SendResult, Throwable, Object>(this){

                        @Override
                        public Object apply(SendResult result, Throwable ex) {
                            if (ex != null) {
                                log.error(ex.getMessage(), ex);
                                return null;
                            }
                            RecordMetadata metadata = result.getRecordMetadata();
                            int partition = metadata.partition();
                            long offset = metadata.offset();
                            log.info("record,partition: " + partition + ", offset:" + offset);
                            return null;
                        }
                    });
                    try {
                        OpeLogPut opeLogPut = new OpeLogPut();
                        opeLogPut.setTime(System.currentTimeMillis());
                        DevicePart devicePart = new DevicePart();
                        devicePart.setShopId(deviceStatus.getDepId());
                        devicePart.setDeviceStatusId(deviceStatus.getId());
                        devicePart.setDType(deviceStatus.getDType());
                        devicePart.setDeviceName(deviceStatus.getDeviceName());
                        opeLogPut.setDevicePart(devicePart);
                        SessionPart sessionPart = new SessionPart();
                        sessionPart.setEnterpriseId(session.getGroupId());
                        sessionPart.setUserId(userId);
                        sessionPart.setUserDeviceIP(session.clientInfo().getRemoteIp());
                        sessionPart.setToken(session.backendToken());
                        opeLogPut.setSessionPart(sessionPart);
                        opeLogPut.setOpeSource(OpeSource.of((String)session.clientInfo().getPlatform()).getType());
                        opeLogPut.setLogType(DeviceLogType.alarmConfiguration.getType());
                        opeLogPut.setContent("\u6389\u7ebf\u544a\u8b66\u4fee\u6539\u63a8\u9001\u4eba");
                        opeLogPut.setI18nKey("operation.alarmConfiguration.TYPE_OFFLINE_ALERT_MODIFY_PUSHER");
                        opeLogPut.setI18nParam(null);
                        opeLogPut.setJsonData(JSONAccessor.impl().format((Object)deviceStatus));
                        DeviceAlertConfigServiceImpl.this.deviceLogEventService.opeLogPut(opeLogPut);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }));
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void configureOffline(DeviceOfflineCnf deviceOfflineCnf) {
        Integer deviceStatusId = deviceOfflineCnf.getDeviceStatusId();
        int updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatusId)).eq(DeviceAlertConfigTask::getConfigVer, (Object)deviceOfflineCnf.getConfigVer())).set(DeviceAlertConfigTask::getApplyConfigVer, (Object)deviceOfflineCnf.getConfigVer()));
        if (updated == 1) {
            DeviceStatus deviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(deviceStatusId);
            deviceStatus.setStartTimeStr(deviceOfflineCnf.getStartHourTime());
            deviceStatus.setEndTimeStr(deviceOfflineCnf.getEndHourTime());
            deviceStatus.setBusinessTimeInherit(deviceOfflineCnf.isBusinessTimeFlag() ? 1 : 0);
            deviceStatus.setIsOfflineAlertEnable(deviceOfflineCnf.isEnabledFlag() ? 1 : 0);
            deviceStatus.setPushEmail(deviceOfflineCnf.isShopMailNotifyFlag() || deviceOfflineCnf.isUserMailNotifyFlag() || deviceOfflineCnf.isUserMailNotifyFlag4Shop() ? 1 : 0);
            log.info("update offline config , device status: " + JSONAccessor.impl().format((Object)deviceStatus));
            this.deviceStatusMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceStatus.class).eq(DeviceStatus::getId, (Object)deviceStatusId)).set(DeviceStatus::getStartTimeStr, (Object)deviceStatus.getStartTimeStr())).set(DeviceStatus::getEndTimeStr, (Object)deviceStatus.getEndTimeStr())).set(DeviceStatus::getBusinessTimeInherit, (Object)deviceStatus.getBusinessTimeInherit())).set(DeviceStatus::getIsOfflineAlertEnable, (Object)deviceStatus.getIsOfflineAlertEnable())).set(DeviceStatus::getPushEmail, (Object)deviceStatus.getPushEmail()));
            this.saveDeviceAlertStatusDetail(deviceStatus.getId(), deviceStatus.getGroupId(), null, null, deviceOfflineCnf.isEnabledFlag() ? 1 : 0, null, null, null, null, null, null, null, null, null, deviceOfflineCnf.isShopMailNotifyFlag() ? 1 : 0, deviceOfflineCnf.isUserMailNotifyFlag() ? 1 : 0, null, null, deviceOfflineCnf.isUserMailNotifyFlag4Shop() ? 1 : 0);
            if (!deviceOfflineCnf.isSecondPushFlag()) {
                this.offlineDeviceRuleService.delete(deviceStatusId);
            } else {
                int secondPushHour = deviceOfflineCnf.getSecondPushHour();
                this.offlineDeviceRuleService.upset(deviceStatusId, (Integer)(secondPushHour * 60), deviceOfflineCnf.getSecondPushUserSelectList());
            }
            this.deviceAlertUserMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceAlertUser.class).eq(DeviceAlertUser::getAlertType, (Object)1)).eq(DeviceAlertUser::getDeviceId, (Object)deviceStatusId));
            if (Util.isNotEmpty(deviceOfflineCnf.getShopUserSelectList())) {
                for (Integer userId : deviceOfflineCnf.getShopUserSelectList()) {
                    DeviceAlertUser deviceAlertUser = new DeviceAlertUser();
                    deviceAlertUser.setDeviceId(deviceStatusId);
                    deviceAlertUser.setAlertType(1);
                    deviceAlertUser.setUserId(userId);
                    deviceAlertUser.setCommunicateType("0001");
                    this.deviceAlertUserMapper.insert(deviceAlertUser);
                }
            }
            TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
            taskUpdateRequest.setId(deviceOfflineCnf.getTaskIdInES());
            taskUpdateRequest.setCompletedDesc("success");
            taskUpdateRequest.setStatus(JobStatus.SUCCESS.name());
            TaskUpdateResponse taskUpdateResponse = this.jobService.taskUpdate(taskUpdateRequest);
            log.info("taskUpdateResponse: " + JSONAccessor.impl().format((Object)taskUpdateResponse));
        } else {
            DeviceAlertConfigTask deviceAlertConfigTask = (DeviceAlertConfigTask)this.deviceAlertConfigTaskMapper.selectById(deviceStatusId);
            long l = deviceAlertConfigTask == null ? -1L : deviceAlertConfigTask.getConfigVer();
            TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
            taskUpdateRequest.setId(deviceOfflineCnf.getTaskIdInES());
            taskUpdateRequest.setCompletedDesc("fail, ver conflict: " + deviceOfflineCnf.getConfigVer() + " <> " + l);
            taskUpdateRequest.setStatus(JobStatus.FAIL.name());
            TaskUpdateResponse taskUpdateResponse = this.jobService.taskUpdate(taskUpdateRequest);
            log.info("taskUpdateResponse: " + JSONAccessor.impl().format((Object)taskUpdateResponse));
        }
    }

    private void saveDeviceAlertStatusDetail(Integer deviceStatusId, Integer groupId, Integer jobVacancy, Integer IO, Integer offLineAlarmStatus, Integer motionDetect, String diskStartTime, String diskEndTime, Integer businessTimeInherit, Integer diskOnOff, Integer diskPushMail, Integer sdBusinessTimeInherit, Integer sdOnOff, Integer sdPushMail, Integer offlineDeptMail, Integer offlineUserMail, Integer diskDeptMail, Integer diskUserMail, Integer offlineUserMail4Shop) {
        List deviceAlertStatusDetails = this.deviceAlertStatusDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(DeviceAlertStatusDetail::getDeviceStatusId, (Object)deviceStatusId));
        if (CollectionUtils.isEmpty((Collection)deviceAlertStatusDetails)) {
            DeviceAlertStatusDetail deviceAlertStatusDetail = new DeviceAlertStatusDetail();
            deviceAlertStatusDetail.setMotionDetect(motionDetect == null ? 0 : motionDetect);
            deviceAlertStatusDetail.setJobVacancy(jobVacancy == null ? 0 : jobVacancy);
            deviceAlertStatusDetail.setIO(IO == null ? 0 : IO);
            deviceAlertStatusDetail.setOffLineAlarmStatus(offLineAlarmStatus == null ? 0 : offLineAlarmStatus);
            deviceAlertStatusDetail.setGroupId(groupId);
            deviceAlertStatusDetail.setDeviceStatusId(deviceStatusId);
            deviceAlertStatusDetail.setStartTimeStr(diskStartTime);
            deviceAlertStatusDetail.setEndTimeStr(diskEndTime);
            deviceAlertStatusDetail.setBusinessTimeInherit(Optional.ofNullable(businessTimeInherit).orElse(0));
            deviceAlertStatusDetail.setDiskOnOff(Optional.ofNullable(diskOnOff).orElse(0));
            deviceAlertStatusDetail.setDiskPushMail(Optional.ofNullable(diskPushMail).orElse(0));
            deviceAlertStatusDetail.setSdBusinessTimeInherit(Optional.ofNullable(sdBusinessTimeInherit).orElse(0));
            deviceAlertStatusDetail.setSdOnOff(Optional.ofNullable(sdOnOff).orElse(0));
            deviceAlertStatusDetail.setSdPushMail(Optional.ofNullable(sdPushMail).orElse(0));
            this.deviceAlertStatusDetailMapper.insert(deviceAlertStatusDetail);
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(DeviceAlertStatusDetail::getId, (Object)((DeviceAlertStatusDetail)deviceAlertStatusDetails.get(0)).getId());
            if (jobVacancy != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getJobVacancy, (Object)jobVacancy);
            }
            if (IO != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getIO, (Object)IO);
            }
            if (offLineAlarmStatus != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getOffLineAlarmStatus, (Object)offLineAlarmStatus);
            }
            if (motionDetect != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getMotionDetect, (Object)motionDetect);
            }
            if (StringUtils.isNotEmpty((CharSequence)diskStartTime)) {
                updateWrapper.set(DeviceAlertStatusDetail::getStartTimeStr, (Object)diskStartTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)diskEndTime)) {
                updateWrapper.set(DeviceAlertStatusDetail::getEndTimeStr, (Object)diskEndTime);
            }
            if (offlineDeptMail != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getOfflineDeptMail, (Object)offlineDeptMail);
            }
            if (offlineUserMail != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getOfflineUserMail, (Object)offlineUserMail);
            }
            if (offlineUserMail4Shop != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getOfflineUserMail4Shop, (Object)offlineUserMail4Shop);
            }
            if (businessTimeInherit != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getBusinessTimeInherit, (Object)businessTimeInherit);
            }
            if (diskOnOff != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getDiskOnOff, (Object)diskOnOff);
            }
            if (diskPushMail != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getDiskPushMail, (Object)diskPushMail);
            }
            if (diskDeptMail != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getDiskDeptMail, (Object)diskDeptMail);
            }
            if (diskUserMail != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getDiskUserMail, (Object)diskUserMail);
            }
            if (sdBusinessTimeInherit != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getSdBusinessTimeInherit, (Object)sdBusinessTimeInherit);
            }
            if (sdOnOff != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getSdOnOff, (Object)sdOnOff);
            }
            if (sdPushMail != null) {
                updateWrapper.set(DeviceAlertStatusDetail::getSdPushMail, (Object)sdPushMail);
            }
            this.deviceAlertStatusDetailMapper.update(null, (Wrapper)updateWrapper);
        }
    }

    @Override
    @Transactional
    public void preConfigureVideo(final VideoAlertConfigVo videoAlertConfigVo) {
        final List<String> deptList = videoAlertConfigVo.getDeptList();
        if (Util.isEmpty(deptList)) {
            return;
        }
        final Session session = Session.getOrCreate().get();
        DBTableId dbTableId = new DBTableId();
        this.dbTableIdMapper.insert(dbTableId);
        final Long taskId = dbTableId.getId();
        offConfigExecutor.execute(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){

            public void run() throws Exception {
                List list = DeviceAlertConfigServiceImpl.this.rpcFacade.getUserPrivilegeDepByOrganizeIds(session.getUserId(), session.getGroupId(), deptList);
                if (Util.isEmpty((Collection)list)) {
                    return;
                }
                List<Integer> realDeptList = list.stream().map(DepartmentOrgMo::getDepId).toList();
                List deviceStatusList = DeviceAlertConfigServiceImpl.this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeviceStatus::getDepId, realDeptList)).eq(DeviceStatus::getIsDelete, (Object)0));
                if (Util.isEmpty((Collection)deviceStatusList)) {
                    log.info("cannot find any device, dept id: " + JSONAccessor.impl().format(realDeptList));
                    return;
                }
                DeviceAlertConfigServiceImpl.this.configureVideo0(deviceStatusList, taskId, videoAlertConfigVo);
                LogPojo logPojo = new LogPojo();
                logPojo.setUserId(session.getUserId());
                logPojo.setOperation("alarmConfiguration");
                if (session.clientInfo().getRemoteIp() != null) {
                    logPojo.setRemoteIp(session.clientInfo().getRemoteIp());
                } else {
                    logPojo.setRemoteIp("");
                }
                if (session.clientInfo().getPlatform() != null) {
                    logPojo.setPlatform(session.clientInfo().getPlatform());
                } else {
                    logPojo.setPlatform("");
                }
                logPojo.setUserName(session.getUserName());
                logPojo.setCreateTime(new Date());
                logPojo.setLogLevel(Byte.valueOf((byte)0));
                logPojo.setEnterpriseId(session.getGroupId());
                logPojo.setDescription("\u5f55\u50cf\u544a\u8b66\u4fee\u6539\u63a8\u9001\u4eba");
                DeviceAlertConfigServiceImpl.this.logApi.save(logPojo);
            }
        }));
    }

    private void configureVideo0(List<DeviceStatus> deviceStatusList, long taskId, VideoAlertConfigVo videoAlertConfigVo) {
        for (DeviceStatus deviceStatus : deviceStatusList) {
            boolean pushKafka = false;
            DeviceAlertConfigTask configTask = (DeviceAlertConfigTask)this.deviceAlertConfigTaskMapper.selectById(deviceStatus.getId());
            if (configTask == null) {
                configTask = new DeviceAlertConfigTask();
                configTask.setDeviceStatusId(deviceStatus.getId());
                configTask.setVideoConfigVer(taskId);
                this.deviceAlertConfigTaskMapper.insert(configTask);
                pushKafka = true;
            } else {
                int updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatus.getId())).eq(DeviceAlertConfigTask::getVideoConfigVer, (Object)configTask.getVideoConfigVer())).set(DeviceAlertConfigTask::getVideoConfigVer, (Object)taskId));
                if (updated == 1) {
                    pushKafka = true;
                }
            }
            if (!pushKafka) continue;
            DeviceVideoCnf deviceVideoCnf = new DeviceVideoCnf();
            deviceVideoCnf.setTraceId(this.traceId());
            deviceVideoCnf.setDeviceStatusId(deviceStatus.getId());
            deviceVideoCnf.setMac(deviceStatus.getMac());
            deviceVideoCnf.setEnabledFlag(videoAlertConfigVo.isEnabledFlag());
            deviceVideoCnf.setBusinessTimeFlag(videoAlertConfigVo.isBusinessTimeFlag());
            deviceVideoCnf.setStartHourTime(videoAlertConfigVo.getStartHourTime());
            deviceVideoCnf.setEndHourTime(videoAlertConfigVo.getEndHourTime());
            deviceVideoCnf.setUserSelectList(videoAlertConfigVo.getUserSelectList());
            deviceVideoCnf.setConfigVer(taskId);
            ProducerRecord record = new ProducerRecord("device-alert-configure", (Object)String.valueOf(deviceVideoCnf.getDeviceStatusId()), (Object)JSONAccessor.impl().format((Object)deviceVideoCnf));
            record.headers().add("alert-configure-type", Util.utf8((String)"video"));
            CompletableFuture future = this.kafkaTemplate.send(record);
            future.handleAsync(new BiFunction<SendResult, Throwable, Object>(this){

                @Override
                public Object apply(SendResult result, Throwable ex) {
                    if (ex != null) {
                        log.error(ex.getMessage(), ex);
                        return null;
                    }
                    RecordMetadata metadata = result.getRecordMetadata();
                    int partition = metadata.partition();
                    long offset = metadata.offset();
                    log.info("record,partition: " + partition + ", offset:" + offset);
                    return null;
                }
            });
        }
    }

    @Override
    public void preConfigureSingleVideo(final VideoAlertConfigVo videoAlertConfigVo) {
        Integer deviceStatusId = videoAlertConfigVo.getDeviceStatusId();
        if (deviceStatusId == null) {
            return;
        }
        DBTableId dbTableId = new DBTableId();
        this.dbTableIdMapper.insert(dbTableId);
        final Long taskId = dbTableId.getId();
        final DeviceStatus deviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(deviceStatusId);
        log.info("preConfigureSingleVideo, update video config , device status: " + JSONAccessor.impl().format((Object)deviceStatus));
        if (deviceStatus == null) {
            return;
        }
        offConfigExecutor.execute(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){

            public void run() throws Exception {
                DeviceAlertConfigServiceImpl.this.configureVideo0(List.of(deviceStatus), taskId, videoAlertConfigVo);
            }
        }));
    }

    @Override
    public void configureVideo(DeviceVideoCnf deviceVideoCnf) {
        Integer deviceStatusId = deviceVideoCnf.getDeviceStatusId();
        int updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatusId)).eq(DeviceAlertConfigTask::getVideoConfigVer, (Object)deviceVideoCnf.getConfigVer())).set(DeviceAlertConfigTask::getVideoApplyConfigVer, (Object)deviceVideoCnf.getConfigVer()));
        if (updated == 1) {
            DeviceStatus deviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(deviceStatusId);
            log.info("update video config , device status: " + JSONAccessor.impl().format((Object)deviceStatus));
            this.deviceAlertUserMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceAlertUser.class).eq(DeviceAlertUser::getAlertType, (Object)12)).eq(DeviceAlertUser::getDeviceId, (Object)deviceStatusId));
            if (Util.isNotEmpty(deviceVideoCnf.getUserSelectList())) {
                for (Integer userId : deviceVideoCnf.getUserSelectList()) {
                    DeviceAlertUser deviceAlertUser = new DeviceAlertUser();
                    deviceAlertUser.setDeviceId(deviceStatusId);
                    deviceAlertUser.setAlertType(12);
                    deviceAlertUser.setUserId(userId);
                    deviceAlertUser.setCommunicateType("0001");
                    this.deviceAlertUserMapper.insert(deviceAlertUser);
                }
            }
            Platforms platform = (Platforms)this.platformsMapper.selectById(deviceStatus.getPlatformId());
            SetNvrAlarmCfg nvrAlarmCfg = new SetNvrAlarmCfg();
            String url = this.deviceSharedConfig.getPostEventV1Url();
            if (Util.compare2((Comparable)platform.getNewDmsFlag(), (Comparable)Integer.valueOf(1)) == 0) {
                url = this.deviceSharedConfig.getPostEventV2Url();
            }
            nvrAlarmCfg.setAlarmUploadURL(url);
            SetNvrAlarmCfg.DateBean date = new SetNvrAlarmCfg.DateBean();
            date.setStart("20200101");
            date.setEnd("20500101");
            nvrAlarmCfg.setDate(date);
            SetNvrAlarmCfg.TimeBean timeBean = new SetNvrAlarmCfg.TimeBean();
            SetNvrAlarmCfg.PeriodBean periodBean = new SetNvrAlarmCfg.PeriodBean();
            String startHourTime = deviceVideoCnf.getStartHourTime();
            String endHourTime = deviceVideoCnf.getEndHourTime();
            periodBean.setStart(startHourTime.replace(":", "") + "00");
            periodBean.setEnd(endHourTime.replace(":", "") + "59");
            timeBean.setPeriod(List.of(periodBean));
            timeBean.setWeek(Integer.valueOf(8));
            nvrAlarmCfg.setTime(List.of(timeBean));
            ArrayList nvrAlarmCnf = new ArrayList();
            HashMap<String, Integer> conf = new HashMap<String, Integer>();
            conf.put("alarmType", 12);
            conf.put("alarmEnable", deviceVideoCnf.isEnabledFlag() ? 1 : 0);
            nvrAlarmCnf.add(conf);
            nvrAlarmCfg.setNvrAlarmCnf(nvrAlarmCnf);
            log.info("request set nvr alarm config: " + String.valueOf(nvrAlarmCnf));
            log.info("request set nvr alarm , platform: " + JSONAccessor.impl().format((Object)platform));
            Integer dType = deviceStatus.getDType();
            if (dType == 2 || dType == 20) {
                ResultRes resultRes = this.nvrService.setNvrAlarmCnfReq(deviceStatus.getMac(), nvrAlarmCfg, platform.getUpgradeServer(), platform.getUpgradePort(), platform.getNewDmsFlag());
                log.info("setNvrAlarmCnfReq result: " + JSONAccessor.impl().format((Object)resultRes));
            } else {
                log.info("\u8bbe\u5907\u4e0d\u652f\u6301");
            }
        }
    }

    @Override
    public void preConfigureReid(final ReidConfigVo reidConfigVo, final int operation) {
        log.info("preConfigureReid: " + JSONAccessor.impl().format((Object)reidConfigVo) + " , operation: " + operation);
        final List<String> deptList = reidConfigVo.getDeptList();
        if (Util.isEmpty(deptList)) {
            return;
        }
        final Session session = Session.getOrCreate().get();
        DBTableId dbTableId = new DBTableId();
        this.dbTableIdMapper.insert(dbTableId);
        final Long taskId = dbTableId.getId();
        offConfigExecutor.execute(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){

            public void run() throws Exception {
                List list = DeviceAlertConfigServiceImpl.this.rpcFacade.getUserPrivilegeDepByOrganizeIds(session.getUserId(), session.getGroupId(), deptList);
                if (Util.isEmpty((Collection)list)) {
                    return;
                }
                List<Integer> realDeptList = list.stream().map(DepartmentOrgMo::getDepId).toList();
                List<DeviceStatus> deviceStatusList = DeviceAlertConfigServiceImpl.this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeviceStatus::getDepId, realDeptList)).eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getDType, (Object)52));
                if (Util.isEmpty(deviceStatusList = deviceStatusList.stream().filter(a -> AbilityUtil.supportSetPflowReidCfg((Integer)a.getDType(), (String)a.getExtendCapacity())).collect(Collectors.toList()))) {
                    log.info("cannot find any device, dept id: " + JSONAccessor.impl().format(realDeptList));
                    return;
                }
                deviceStatusList = deviceStatusList.stream().filter(deviceStatus -> {
                    try {
                        return AbilityUtil.supportSetPflowReidCfg((Integer)deviceStatus.getDType(), (String)deviceStatus.getExtendCapacity());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        return false;
                    }
                }).toList();
                reidConfigVo.setTraceId(DeviceAlertConfigServiceImpl.this.traceId());
                if (operation == 1) {
                    DeviceAlertConfigServiceImpl.this.configureReid1(deviceStatusList, taskId, reidConfigVo);
                } else if (operation == 2) {
                    DeviceAlertConfigServiceImpl.this.configureReid2(deviceStatusList, taskId, reidConfigVo);
                } else if (operation == 3) {
                    DeviceAlertConfigServiceImpl.this.configureReid3(deviceStatusList, taskId, reidConfigVo);
                }
            }
        }));
    }

    private String traceId() {
        return MDC.get((String)"requestId");
    }

    private void configureReid1(List<DeviceStatus> deviceStatusList, long taskId, ReidConfigVo reidConfigVo) {
        for (DeviceStatus deviceStatus : deviceStatusList) {
            boolean pushKafka = false;
            DeviceAlertConfigTask configTask = (DeviceAlertConfigTask)this.deviceAlertConfigTaskMapper.selectById(deviceStatus.getId());
            if (configTask == null) {
                configTask = new DeviceAlertConfigTask();
                configTask.setDeviceStatusId(deviceStatus.getId());
                configTask.setReidConfigVer1(taskId);
                this.deviceAlertConfigTaskMapper.insert(configTask);
                pushKafka = true;
            } else {
                int updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatus.getId())).eq(DeviceAlertConfigTask::getReidConfigVer1, (Object)configTask.getReidConfigVer1())).set(DeviceAlertConfigTask::getReidConfigVer1, (Object)taskId));
                if (updated == 1) {
                    pushKafka = true;
                }
            }
            if (!pushKafka) continue;
            this.pushKafkaReid_(taskId, reidConfigVo, deviceStatus, 1);
        }
    }

    private void configureReid2(List<DeviceStatus> deviceStatusList, long taskId, ReidConfigVo reidConfigVo) {
        for (DeviceStatus deviceStatus : deviceStatusList) {
            boolean pushKafka = false;
            DeviceAlertConfigTask configTask = (DeviceAlertConfigTask)this.deviceAlertConfigTaskMapper.selectById(deviceStatus.getId());
            if (configTask == null) {
                configTask = new DeviceAlertConfigTask();
                configTask.setDeviceStatusId(deviceStatus.getId());
                configTask.setReidConfigVer2(taskId);
                this.deviceAlertConfigTaskMapper.insert(configTask);
                pushKafka = true;
            } else {
                int updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatus.getId())).eq(DeviceAlertConfigTask::getReidConfigVer2, (Object)configTask.getReidConfigVer2())).set(DeviceAlertConfigTask::getReidConfigVer2, (Object)taskId));
                if (updated == 1) {
                    pushKafka = true;
                }
            }
            if (!pushKafka) continue;
            this.pushKafkaReid_(taskId, reidConfigVo, deviceStatus, 2);
        }
    }

    private void configureReid3(List<DeviceStatus> deviceStatusList, long taskId, ReidConfigVo reidConfigVo) {
        for (DeviceStatus deviceStatus : deviceStatusList) {
            boolean pushKafka = false;
            DeviceAlertConfigTask configTask = (DeviceAlertConfigTask)this.deviceAlertConfigTaskMapper.selectById(deviceStatus.getId());
            if (configTask == null) {
                configTask = new DeviceAlertConfigTask();
                configTask.setDeviceStatusId(deviceStatus.getId());
                configTask.setReidConfigVer3(taskId);
                this.deviceAlertConfigTaskMapper.insert(configTask);
                pushKafka = true;
            } else {
                int updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatus.getId())).eq(DeviceAlertConfigTask::getReidConfigVer3, (Object)configTask.getReidConfigVer3())).set(DeviceAlertConfigTask::getReidConfigVer3, (Object)taskId));
                if (updated == 1) {
                    pushKafka = true;
                }
            }
            if (!pushKafka) continue;
            this.pushKafkaReid_(taskId, reidConfigVo, deviceStatus, 3);
        }
    }

    private void pushKafkaReid_(long taskId, ReidConfigVo reidConfigVo, DeviceStatus deviceStatus, int operation) {
        DeviceReidCnf deviceReidCnf = new DeviceReidCnf();
        deviceReidCnf.setOperation(operation);
        deviceReidCnf.setDeviceStatusId(deviceStatus.getId());
        deviceReidCnf.setMac(deviceStatus.getMac());
        deviceReidCnf.setConfigVer(taskId);
        deviceReidCnf.setDayReidEndHour(reidConfigVo.getDayReidEndHour());
        deviceReidCnf.setDayReidEndMinute(reidConfigVo.getDayReidEndMinute());
        deviceReidCnf.setEnableStorePasserby(reidConfigVo.getEnableStorePasserby());
        deviceReidCnf.setEmployeeBeginHour(reidConfigVo.getEmployeeBeginHour());
        deviceReidCnf.setEmployeeBeginMinute(reidConfigVo.getEmployeeBeginMinute());
        deviceReidCnf.setEmployeeBeginSecond(reidConfigVo.getEmployeeBeginSecond());
        deviceReidCnf.setEmployeeEndHour(reidConfigVo.getEmployeeEndHour());
        deviceReidCnf.setEmployeeEndMinute(reidConfigVo.getEmployeeEndMinute());
        deviceReidCnf.setEmployeeEndSecond(reidConfigVo.getEmployeeEndSecond());
        deviceReidCnf.setEmployeeTimeMarkEnable(reidConfigVo.getEmployeeTimeMarkEnable());
        deviceReidCnf.setEmployeeCompareLevel(reidConfigVo.getEmployeeCompareLevel());
        ProducerRecord record = new ProducerRecord("device-alert-configure", (Object)String.valueOf(deviceReidCnf.getDeviceStatusId()), (Object)JSONAccessor.impl().format((Object)deviceReidCnf));
        record.headers().add("alert-configure-type", Util.utf8((String)"reid"));
        CompletableFuture future = this.kafkaTemplate.send(record);
        future.handleAsync(new BiFunction<SendResult, Throwable, Object>(this){

            @Override
            public Object apply(SendResult result, Throwable ex) {
                if (ex != null) {
                    log.error(ex.getMessage(), ex);
                    return null;
                }
                RecordMetadata metadata = result.getRecordMetadata();
                int partition = metadata.partition();
                long offset = metadata.offset();
                log.info("record,partition: " + partition + ", offset:" + offset);
                return null;
            }
        });
    }

    @Override
    public void configureReid(DeviceReidCnf deviceReidCnf) {
        Integer deviceStatusId = deviceReidCnf.getDeviceStatusId();
        int updated = 0;
        if (deviceReidCnf.getOperation() == 1) {
            updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatusId)).eq(DeviceAlertConfigTask::getReidConfigVer1, (Object)deviceReidCnf.getConfigVer())).set(DeviceAlertConfigTask::getReidApplyConfigVer1, (Object)deviceReidCnf.getConfigVer()));
        } else if (deviceReidCnf.getOperation() == 2) {
            updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatusId)).eq(DeviceAlertConfigTask::getReidConfigVer2, (Object)deviceReidCnf.getConfigVer())).set(DeviceAlertConfigTask::getReidApplyConfigVer2, (Object)deviceReidCnf.getConfigVer()));
        } else if (deviceReidCnf.getOperation() == 3) {
            updated = this.deviceAlertConfigTaskMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceAlertConfigTask.class).eq(DeviceAlertConfigTask::getDeviceStatusId, (Object)deviceStatusId)).eq(DeviceAlertConfigTask::getReidConfigVer3, (Object)deviceReidCnf.getConfigVer())).set(DeviceAlertConfigTask::getReidApplyConfigVer3, (Object)deviceReidCnf.getConfigVer()));
        }
        if (updated == 1) {
            DeviceStatus deviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(deviceStatusId);
            log.info("update reid config , device status: " + JSONAccessor.impl().format((Object)deviceStatus));
            Platforms platform = (Platforms)this.platformsMapper.selectById(deviceStatus.getPlatformId());
            SetPflowReidCfgReq mo = new SetPflowReidCfgReq();
            mo.setDayReidEndHour(deviceReidCnf.getDayReidEndHour());
            mo.setDayReidEndMinute(deviceReidCnf.getDayReidEndMinute());
            mo.setEnableStorePasserby(deviceReidCnf.getEnableStorePasserby());
            mo.setEmployeeBeginHour(deviceReidCnf.getEmployeeBeginHour());
            mo.setEmployeeBeginMinute(deviceReidCnf.getEmployeeBeginMinute());
            mo.setEmployeeBeginSecond(deviceReidCnf.getEmployeeBeginSecond());
            mo.setEmployeeEndHour(deviceReidCnf.getEmployeeEndHour());
            mo.setEmployeeEndMinute(deviceReidCnf.getEmployeeEndMinute());
            mo.setEmployeeEndSecond(deviceReidCnf.getEmployeeEndSecond());
            mo.setEmployeeTimeMarkEnable(deviceReidCnf.getEmployeeTimeMarkEnable());
            mo.setEmployeeCompareLevel(deviceReidCnf.getEmployeeCompareLevel());
            log.info("request set reid , platform: " + JSONAccessor.impl().format((Object)platform));
            log.info("request set reid config: " + JSONAccessor.impl().format((Object)mo));
            ResultRes resultRes = this.pc8Service.setPflowReidCfg(deviceStatus.getMac(), platform.getUpgradeServer(), platform.getUpgradePort(), mo);
            log.info("request set reid config, result " + String.valueOf(resultRes));
        }
    }

    @Override
    public EventOnOff eventOnOff(int deviceId) {
        DeviceStatus deviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(Integer.valueOf(deviceId));
        Platforms platforms = (Platforms)this.platformsMapper.selectById(deviceStatus.getPlatformId());
        EventOnOff eventOnOff = new EventOnOff();
        try {
            DeviceStatus nvrDeviceStatus = (DeviceStatus)this.deviceStatusMapper.selectById(deviceStatus.getPId());
            AlarmConfig alarmConfig = this.nvrService.getAlarmConfig(Integer.valueOf(3), null, platforms.getUpgradeServer(), platforms.getUpgradePort(), nvrDeviceStatus == null ? deviceStatus.getMac() : nvrDeviceStatus.getMac(), deviceStatus.getMac(), deviceStatus.getChannelId(), deviceStatus.getWarningOpen(), Integer.valueOf(Util.compare2((Comparable)platforms.getNewDmsFlag(), (Comparable)Integer.valueOf(1)) == 0 ? 1 : 0));
            eventOnOff.setMoving(alarmConfig != null && Util.compare2((Comparable)alarmConfig.getAlarmEnable(), (Comparable)Integer.valueOf(1)) == 0);
            log.info("eventOnOff alarmConfig: " + JSONAccessor.impl().format((Object)alarmConfig));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            eventOnOff.setMoving(false);
        }
        return eventOnOff;
    }
}

