/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.tagmgr.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.platform.RedisLock;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.DevicesMapper;
import com.ovopark.device.modules.tagmgr.model.TagOpeResult;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTag;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagCnfMapper;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagCnfVo;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagMapper;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagRef;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagRefMapper;
import com.ovopark.device.modules.tagmgr.service.DeviceTagService;
import com.ovopark.device.modules.tagmgr.vo.DeviceTagListQuery;
import com.ovopark.device.modules.tagmgr.vo.DeviceTagVo;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceTagServiceImpl
implements DeviceTagService {
    @Autowired
    private DeviceTagMapper deviceTagMapper;
    @Autowired
    private DeviceTagRefMapper deviceTagRefMapper;
    @Autowired
    private DeviceTagCnfMapper deviceTagCnfMapper;
    @Autowired
    private DevicesMapper devicesMapper;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private OnlineFacade onlineFacade;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TagOpeResult add(DeviceTagVo deviceTagVo) {
        Session session = Session.getOrCreate().get();
        Integer groupId = session.getGroupId();
        DeviceTag deviceTag = new DeviceTag();
        deviceTag.setGroupId(groupId);
        deviceTag.setTagName(deviceTagVo.getTagName());
        deviceTag.setCreateId(session.getUserId());
        deviceTag.setCreateTime(LocalDateTime.now());
        deviceTag.setDelFlag(0);
        this.deviceTagMapper.insert(deviceTag);
        DeviceTagCnfVo tagCnf = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
        Integer tagId = deviceTag.getId();
        if (tagCnf != null && Util.compare2((Comparable)tagCnf.getAutoFlag(), (Comparable)Integer.valueOf(1)) == 0) {
            Util.log.info("assign flow");
            List devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getIsDelete, (Object)0));
            List deviceTagList = this.deviceTagMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTag.class).eq(DeviceTag::getDelFlag, (Object)0)).eq(DeviceTag::getGroupId, (Object)groupId));
            TagOpeResult result = this.assign(groupId, null, deviceTagList, devicesList);
            TagOpeResult tagOpeResult = new TagOpeResult();
            tagOpeResult.setTagIdList(List.of(tagId));
            tagOpeResult.setChangedSet(result.getChangedSet());
            return tagOpeResult;
        }
        TagOpeResult tagOpeResult = new TagOpeResult();
        tagOpeResult.setTagIdList(List.of(tagId));
        tagOpeResult.setChangedSet(new HashSet<Integer>());
        return tagOpeResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TagOpeResult update(DeviceTagVo deviceTagVo) {
        Session session = Session.getOrCreate().get();
        Integer groupId = session.getGroupId();
        Integer tagVoTagId = deviceTagVo.getTagId();
        List deviceTagList = this.deviceTagMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTag.class).eq(DeviceTag::getGroupId, (Object)groupId)).eq(DeviceTag::getDelFlag, (Object)0));
        DeviceTag deviceTag = deviceTagList.stream().filter(tag -> Util.compare2((Comparable)tagVoTagId, (Comparable)tag.getId()) == 0).findFirst().get();
        deviceTag.setTagName(deviceTagVo.getTagName());
        deviceTag.setUpdateId(session.getUserId());
        deviceTag.setUpdateTime(LocalDateTime.now());
        this.deviceTagMapper.updateById(deviceTag);
        DeviceTagCnfVo tagCnf = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
        if (tagCnf != null && Util.compare2((Comparable)tagCnf.getAutoFlag(), (Comparable)Integer.valueOf(1)) == 0) {
            Util.log.info("assign flow");
            List devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getIsDelete, (Object)0));
            TagOpeResult result = this.assign(groupId, null, deviceTagList, devicesList);
            TagOpeResult tagOpeResult = new TagOpeResult();
            tagOpeResult.setTagIdList(List.of(tagVoTagId));
            tagOpeResult.setChangedSet(result.getChangedSet());
            return tagOpeResult;
        }
        List devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getIsDelete, (Object)0));
        List deviceTagRefListDB = this.deviceTagRefMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTagRef.class).in(DeviceTagRef::getTagId, new Object[]{deviceTag.getId()})).eq(DeviceTagRef::getDelFlag, (Object)0));
        Map<Integer, Devices> devicesMap = devicesList.stream().collect(Collectors.toMap(Devices::getId, v -> v));
        for (DeviceTagRef deviceTagRef : deviceTagRefListDB) {
            Integer deviceId = deviceTagRef.getDeviceId();
            Devices devices = devicesMap.get(deviceId);
            if (devices == null) {
                this.deviceTagRefMapper.deleteById(deviceTagRef);
                Util.log.info("delete ref: " + JSONAccessor.impl().format((Object)deviceTag));
                continue;
            }
            String name = devices.getName();
            if (!Util.isEmpty((CharSequence)name) && name.contains(deviceTag.getTagName())) continue;
            this.deviceTagRefMapper.deleteById(deviceTagRef);
            Util.log.info("delete ref: " + JSONAccessor.impl().format((Object)deviceTag));
        }
        TagOpeResult tagOpeResult = new TagOpeResult();
        tagOpeResult.setTagIdList(List.of(tagVoTagId));
        tagOpeResult.setChangedSet(new HashSet<Integer>());
        return tagOpeResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TagOpeResult delete(DeviceTagVo deviceTagVo) {
        Session session = Session.getOrCreate().get();
        Integer groupId = session.getGroupId();
        List<Integer> deleteTagIdList = deviceTagVo.getDeleteTagIdList();
        List list = this.deviceTagMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTag.class).in(DeviceTag::getId, deleteTagIdList)).eq(DeviceTag::getDelFlag, (Object)0));
        for (DeviceTag deviceTag : list) {
            deviceTag.setDelFlag(1);
            deviceTag.setUpdateId(session.getUserId());
            deviceTag.setUpdateTime(LocalDateTime.now());
            this.deviceTagMapper.updateById(deviceTag);
        }
        this.deviceTagRefMapper.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(DeviceTagRef.class).in(DeviceTagRef::getTagId, deleteTagIdList)).set(DeviceTagRef::getDelFlag, (Object)1));
        DeviceTagCnfVo tagCnf = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
        if (tagCnf != null && Util.compare2((Comparable)tagCnf.getAutoFlag(), (Comparable)Integer.valueOf(1)) == 0) {
            Util.log.info("assign flow");
            List devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getIsDelete, (Object)0));
            List deviceTagList = this.deviceTagMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTag.class).eq(DeviceTag::getDelFlag, (Object)0)).eq(DeviceTag::getGroupId, (Object)groupId));
            TagOpeResult result = this.assign(groupId, null, deviceTagList, devicesList);
            TagOpeResult tagOpeResult = new TagOpeResult();
            tagOpeResult.setTagIdList(deleteTagIdList);
            tagOpeResult.setChangedSet(result.getChangedSet());
            return tagOpeResult;
        }
        TagOpeResult tagOpeResult = new TagOpeResult();
        tagOpeResult.setTagIdList(deleteTagIdList);
        tagOpeResult.setChangedSet(new HashSet<Integer>());
        return tagOpeResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TagOpeResult assign(Integer groupId, DeviceTag selectedTag, List<DeviceTag> deviceTagList, List<Devices> devicesList) {
        Util.log.info("assign: " + groupId);
        HashSet<Integer> changedSet = new HashSet<Integer>();
        Map<Integer, Devices> devicesMap = devicesList.stream().collect(Collectors.toMap(Devices::getId, v -> v));
        HashSet<Integer> keepDeviceRefSet = new HashSet<Integer>();
        for (DeviceTag deviceTag : deviceTagList) {
            List deviceTagRefListDB = this.deviceTagRefMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTagRef.class).in(DeviceTagRef::getTagId, new Object[]{deviceTag.getId()})).eq(DeviceTagRef::getDelFlag, (Object)0));
            for (DeviceTagRef deviceTagRef : deviceTagRefListDB) {
                Integer deviceId = deviceTagRef.getDeviceId();
                Devices devices = devicesMap.get(deviceId);
                if (devices == null) {
                    this.deviceTagRefMapper.deleteById(deviceTagRef);
                    changedSet.add(deviceTag.getId());
                    Util.log.info("delete ref: " + JSONAccessor.impl().format((Object)deviceTag));
                    continue;
                }
                String name = devices.getName();
                if (Util.isEmpty((CharSequence)name) || !name.contains(deviceTag.getTagName())) {
                    this.deviceTagRefMapper.deleteById(deviceTagRef);
                    changedSet.add(deviceTag.getId());
                    Util.log.info("delete ref: " + JSONAccessor.impl().format((Object)deviceTag));
                    continue;
                }
                keepDeviceRefSet.add(deviceId);
            }
        }
        block2: for (Devices devices : devicesList) {
            if (keepDeviceRefSet.contains(devices.getId())) continue;
            if (selectedTag != null) {
                if (!Util.isNotEmpty((CharSequence)devices.getName()) || !devices.getName().contains(selectedTag.getTagName())) continue;
                DeviceTagRef deviceTagRef = new DeviceTagRef();
                deviceTagRef.setTagId(selectedTag.getId());
                deviceTagRef.setDeviceId(devices.getId());
                deviceTagRef.setDelFlag(0);
                this.deviceTagRefMapper.insert(deviceTagRef);
                changedSet.add(selectedTag.getId());
                Util.log.info("add ref: " + JSONAccessor.impl().format((Object)deviceTagRef));
                continue;
            }
            for (DeviceTag deviceTag : deviceTagList) {
                DeviceTagRef deviceTagRef;
                if (!Util.isNotEmpty((CharSequence)devices.getName()) || !devices.getName().contains(deviceTag.getTagName())) continue;
                deviceTagRef = new DeviceTagRef();
                deviceTagRef.setTagId(deviceTag.getId());
                deviceTagRef.setDeviceId(devices.getId());
                deviceTagRef.setDelFlag(0);
                this.deviceTagRefMapper.insert(deviceTagRef);
                changedSet.add(deviceTag.getId());
                Util.log.info("add ref: " + JSONAccessor.impl().format((Object)deviceTagRef));
                continue block2;
            }
        }
        TagOpeResult tagOpeResult = new TagOpeResult();
        tagOpeResult.setTagIdList(null);
        tagOpeResult.setChangedSet(changedSet);
        return tagOpeResult;
    }

    @Override
    public PageModel<DeviceTagVo> tagList(DeviceTagListQuery deviceTagListQuery) {
        Session session = Session.getOrCreate().get();
        Integer groupId = session.getGroupId();
        Page deviceTagPage = new Page();
        long pageNumber = deviceTagListQuery.getPageNumber();
        int pageSize = deviceTagListQuery.getPageSize();
        deviceTagPage.setCurrent(pageNumber);
        deviceTagPage.setSize((long)pageSize);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTag.class).eq(DeviceTag::getGroupId, (Object)groupId)).eq(DeviceTag::getDelFlag, (Object)0);
        if (Util.isNotEmpty((CharSequence)deviceTagListQuery.getTagName())) {
            queryWrapper.like(DeviceTag::getTagName, (Object)deviceTagListQuery.getTagName());
        }
        HashMap<Integer, Integer> onlineMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> offlineMap = new HashMap<Integer, Integer>();
        List<DeviceTagVo> list = this.deviceTagRefMapper.listDeviceRef(groupId, null, null);
        if (Util.isNotEmpty(list)) {
            Map onOffNRT = this.onlineFacade.onOffNRT(list.stream().map(DeviceTagVo::getDeviceStatusId).toList());
            for (DeviceTagVo deviceTagVo : list) {
                Integer i;
                Integer deviceStatusId = deviceTagVo.getDeviceStatusId();
                Integer tagId = deviceTagVo.getTagId();
                if (Util.compare2((Comparable)((Comparable)onOffNRT.get(deviceStatusId)), (Comparable)Integer.valueOf(1)) == 0) {
                    i = onlineMap.computeIfAbsent(tagId, k -> 0);
                    onlineMap.put(tagId, i + 1);
                    continue;
                }
                i = offlineMap.computeIfAbsent(tagId, k -> 0);
                offlineMap.put(tagId, i + 1);
            }
        }
        List deviceTagList = this.deviceTagMapper.selectList((IPage)deviceTagPage, (Wrapper)queryWrapper);
        ArrayList<DeviceTagVo> deviceTagVoList = new ArrayList<DeviceTagVo>();
        for (DeviceTag deviceTag : deviceTagList) {
            DeviceTagVo deviceTagVo = new DeviceTagVo();
            BeanUtils.copyProperties((Object)deviceTag, (Object)deviceTagVo);
            int l = this.deviceTagRefMapper.countDeviceRef(groupId, deviceTag.getId(), null);
            deviceTagVo.setDeviceCount(l);
            deviceTagVo.setTagId(deviceTag.getId());
            deviceTagVoList.add(deviceTagVo);
            deviceTagVo.setOnlineCount((Integer)Util.convert2Self((Object)((Integer)onlineMap.get(deviceTag.getId())), (Object)0));
            deviceTagVo.setOfflineCount((Integer)Util.convert2Self((Object)((Integer)offlineMap.get(deviceTag.getId())), (Object)0));
        }
        if (Util.compare2((Comparable)deviceTagListQuery.getFetchDefInfoFlag(), (Comparable)Integer.valueOf(1)) == 0) {
            int n = this.deviceTagRefMapper.countDeviceRefNotAssigned(groupId, null);
            DeviceTagVo deviceTagVo = new DeviceTagVo();
            deviceTagVo.setTagId(999999999);
            deviceTagVo.setDeviceCount(n);
            deviceTagVoList.add(deviceTagVo);
            List<DeviceTagVo> notAssignedDeviceTagVoList = this.deviceTagRefMapper.listDeviceRefNotAssigned(groupId, null, null);
            if (Util.isNotEmpty(notAssignedDeviceTagVoList)) {
                Map onOffNRT = this.onlineFacade.onOffNRT(notAssignedDeviceTagVoList.stream().map(DeviceTagVo::getDeviceStatusId).toList());
                deviceTagVo.setOnlineCount((int)onOffNRT.values().stream().filter(v -> Util.compare2((Comparable)v, (Comparable)Integer.valueOf(1)) == 0).count());
                deviceTagVo.setOfflineCount((int)onOffNRT.values().stream().filter(v -> Util.compare2((Comparable)v, (Comparable)Integer.valueOf(0)) == 0).count());
            }
        }
        return PageModel.from((long)pageNumber, (int)pageSize, (long)deviceTagPage.getTotal(), deviceTagVoList);
    }

    @Override
    public PageModel<DeviceTagVo> deviceList(DeviceTagListQuery deviceTagListQuery) {
        Integer groupId = Session.getOrCreate().get().getGroupId();
        Integer userId = Session.getOrCreate().get().getUserId();
        long pageNumber = deviceTagListQuery.getPageNumber();
        int pageSize = deviceTagListQuery.getPageSize();
        String organizeIdList = deviceTagListQuery.getOrganizeIdList();
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(groupId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)organizeIdList)) {
            String[] split = organizeIdList.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcFacade.getRootOrganize(groupId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        List deptIdList = this.rpcFacade.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        if (Util.isEmpty((Collection)deptIdList)) {
            return PageModel.from((long)pageNumber, (int)pageSize, (long)0L, new ArrayList());
        }
        Util.log.info("pageDeviceRef, deptIdList: " + JSONAccessor.impl().format((Object)deptIdList));
        Page deviceTagPage = new Page();
        deviceTagPage.setCurrent(pageNumber);
        deviceTagPage.setSize((long)pageSize);
        IPage<DeviceTagVo> deviceTagVoIPage = Util.compare2((Comparable)deviceTagListQuery.getTagId(), (Comparable)Integer.valueOf(999999999)) == 0 ? this.deviceTagRefMapper.pageDeviceRefNotAssigned(deviceTagPage, groupId, deviceTagListQuery.getTagId(), deptIdList) : this.deviceTagRefMapper.pageDeviceRef(deviceTagPage, groupId, deviceTagListQuery.getTagId(), deptIdList);
        Map onOffNRT = this.onlineFacade.onOffNRT(deviceTagVoIPage.getRecords().stream().map(DeviceTagVo::getDeviceStatusId).toList());
        List departmentList = this.rpcFacade.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> deptMap = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        for (DeviceTagVo deviceTagVo : deviceTagVoIPage.getRecords()) {
            DepartmentPojo departmentPojo = deptMap.get(deviceTagVo.getDeptId());
            if (departmentPojo != null) {
                deviceTagVo.setDeptName(departmentPojo.getName());
            }
            deviceTagVo.setOnOffStatus((Integer)Util.convert2Self((Object)((Integer)onOffNRT.get(deviceTagVo.getDeviceStatusId())), (Object)0));
        }
        return PageModel.from((long)pageNumber, (int)pageSize, (long)deviceTagVoIPage.getTotal(), (List)deviceTagVoIPage.getRecords());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TagOpeResult removeDeviceRef(DeviceTagVo deviceTagVo) {
        Session session = Session.getOrCreate().get();
        Integer groupId = session.getGroupId();
        List<Integer> deleteTagRefIdList = deviceTagVo.getDeleteTagRefIdList();
        Integer tagId = deviceTagVo.getTagId();
        if (Util.isEmpty(deleteTagRefIdList) || tagId == null) {
            return null;
        }
        this.deviceTagRefMapper.deleteBatchIds(deleteTagRefIdList);
        Util.log.info("deleteTagRefIdList: " + JSONAccessor.impl().format(deleteTagRefIdList));
        DeviceTagCnfVo tagCnf = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
        if (tagCnf != null && Util.compare2((Comparable)tagCnf.getAutoFlag(), (Comparable)Integer.valueOf(1)) == 0) {
            Util.log.info("assign flow");
            List devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getIsDelete, (Object)0));
            List deviceTagList = this.deviceTagMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceTag.class).eq(DeviceTag::getDelFlag, (Object)0)).eq(DeviceTag::getGroupId, (Object)groupId));
            TagOpeResult result = this.assign(groupId, null, deviceTagList, devicesList);
            TagOpeResult tagOpeResult = new TagOpeResult();
            tagOpeResult.setTagIdList(List.of(tagId));
            tagOpeResult.setChangedSet(result.getChangedSet());
            return tagOpeResult;
        }
        TagOpeResult tagOpeResult = new TagOpeResult();
        tagOpeResult.setTagIdList(List.of(tagId));
        tagOpeResult.setChangedSet(new HashSet<Integer>());
        return tagOpeResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void configure(DeviceTagCnfVo deviceTagCnfVo) {
        Integer groupId = Session.getOrCreate().get().getGroupId();
        DeviceTagCnfVo tagCnf = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
        if (tagCnf == null) {
            tagCnf = new DeviceTagCnfVo();
            tagCnf.setGroupId(groupId);
            tagCnf.setAutoFlag(deviceTagCnfVo.getAutoFlag());
            this.deviceTagCnfMapper.insert(tagCnf);
        } else {
            tagCnf.setAutoFlag(deviceTagCnfVo.getAutoFlag());
            this.deviceTagCnfMapper.updateById(tagCnf);
        }
    }

    @Override
    public DeviceTagCnfVo configured(Integer groupId) {
        DeviceTagCnfVo deviceTagCnfVo = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
        return deviceTagCnfVo;
    }
}

