/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.platform.api.UsersFacade;
import com.ovopark.privilege.api.UserApi;
import com.ovopark.privilege.pojo.UsersNewPojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UsersFacadeImpl
implements UsersFacade {
    private static final Logger log = LoggerFactory.getLogger(UsersFacadeImpl.class);
    @Resource
    private UserApi userApi;

    public Boolean authmypwd(String password, Integer userId) {
        try {
            BaseResult usersPojoById = this.userApi.getUsersPojoById(userId);
            if (!usersPojoById.getIsError().booleanValue()) {
                UsersNewPojo user = (UsersNewPojo)usersPojoById.getData();
                log.info("encrypted pwd > pre: " + password + ", db: " + user.getPassword());
                return user.getPassword().equals(password);
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528userApi.getUsersById\u5931\u8d25\uff0c\u5f02\u5e38\u5185\u5bb9:{}", (Object)LogUtil.getStackTraceInfo((Exception)e));
            throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION);
        }
    }

    public List<UsersPojo> getUserList(List<Integer> userIds) {
        ArrayList<UsersPojo> resultList = new ArrayList<UsersPojo>(userIds.size());
        if (CollectionUtils.isNotEmpty(userIds)) {
            for (List ids : Lists.partition(userIds, (int)200)) {
                try {
                    BaseResult userListByUserIds = this.userApi.getUsersListByIdList(ids);
                    if (userListByUserIds.getIsError().booleanValue()) {
                        log.error("userApi.getUsersListByIdList\u8c03\u7528\u5931\u8d25{},", (Object)ids);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)((Collection)userListByUserIds.getData()))) continue;
                    resultList.addAll((Collection)userListByUserIds.getData());
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528userApi.getUsersListByIdList\u5931\u8d25\uff0cids.size{},,\u5f02\u5e38\u5185\u5bb9:{},", (Object)ids.size(), (Object)LogUtil.getStackTraceInfo((Exception)e));
                    throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION);
                }
            }
        }
        return resultList;
    }

    public UsersPojo getUsersById(Integer userId) {
        try {
            BaseResult userByUserId = this.userApi.getUsersById(userId);
            if (userByUserId.getIsError().booleanValue()) {
                log.error("userApi.getUsersById\u8c03\u7528\u5931\u8d25{}", (Object)userByUserId);
            }
            return (UsersPojo)userByUserId.getData();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528userApi.getUsersById\u5931\u8d25\uff0c\u5f02\u5e38\u5185\u5bb9:{}", (Object)LogUtil.getStackTraceInfo((Exception)e));
            throw new CommonException(ExceptionEnum.CLOUD_EXCEPTION);
        }
    }

    public Map<Integer, String> getUsersShowNameMap(List<Integer> userIds) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(userIds.size());
        if (CollectionUtils.isEmpty(userIds)) {
            return result;
        }
        List<UsersPojo> userList = this.getUserList(userIds);
        for (UsersPojo item : userList) {
            result.put(item.getId(), item.getShowName());
        }
        return result;
    }
}

