/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

@EnableKafka
@Configuration
public class KafkaDMSConfig {
    @Value(value="${myConfig.kafka.one.bootstrap-servers}")
    private String bootstrapServers;
    @Value(value="${myConfig.kafka.one.consumer.group-id:device-dev}")
    private String groupId;
    @Value(value="${myConfig.kafka.one.consumer.enable-auto-commit:true}")
    private boolean enableAutoCommit;
    @Value(value="#{${myConfig.kafka.one.extPros:{}}}")
    private Map<String, Object> extPros;

    @Bean(value={"dmsKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> deviceAlertKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    public ConsumerFactory<Integer, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs());
    }

    private Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.extPros != null) {
            props.putAll(this.extPros);
        }
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("group.id", this.groupId);
        props.put("enable.auto.commit", this.enableAutoCommit);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        return props;
    }

    @Bean(value={"dmsKafkaTemplate"})
    @Primary
    public KafkaTemplate<String, String> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    private ProducerFactory<String, String> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfigs());
    }

    private Map<String, Object> producerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.extPros != null) {
            props.putAll(this.extPros);
        }
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("retries", 0);
        props.put("acks", "1");
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        return props;
    }
}

