/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.platform.DeviceGbuiHistoryService;
import com.ovopark.device.modules.platform.mysql.DeviceGbuiHistory;
import com.ovopark.device.modules.platform.mysql.DeviceGbuiHistoryMapper;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceGbuiHistoryServiceImpl
implements DeviceGbuiHistoryService {
    private static final Logger log = LoggerFactory.getLogger(DeviceGbuiHistoryServiceImpl.class);
    @Autowired
    private DeviceGbuiHistoryMapper deviceGbuiHistoryMapper;

    @Override
    public void add(@NotNull Integer userId, @NotNull List<String> macs, @NotNull Integer enable, String remoteIp, String userName) {
        LocalDateTime now = LocalDateTime.now();
        for (String mac : macs) {
            DeviceGbuiHistory deviceGbuiHistory = new DeviceGbuiHistory();
            deviceGbuiHistory.setCreateBy(userId);
            deviceGbuiHistory.setEnable(enable);
            deviceGbuiHistory.setMac(mac);
            deviceGbuiHistory.setCreateAt(now);
            deviceGbuiHistory.setRemoteIp(remoteIp);
            deviceGbuiHistory.setUserName(userName);
            this.deviceGbuiHistoryMapper.insert(deviceGbuiHistory);
        }
    }

    @Override
    public Page<DeviceGbuiHistory> getListByMac(String mac, String startTime, String endTime, Integer pageNum, Integer pageSize) {
        return (Page)this.deviceGbuiHistoryMapper.selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceGbuiHistory::getMac, (Object)mac)).le(StringUtils.isNotEmpty((CharSequence)endTime), DeviceGbuiHistory::getCreateAt, (Object)endTime)).ge(StringUtils.isNotEmpty((CharSequence)startTime), DeviceGbuiHistory::getCreateAt, (Object)startTime)).orderByDesc(DeviceGbuiHistory::getId));
    }

    @Override
    public DeviceGbuiHistory getLastDeviceGbuiHistory(String mac) {
        return (DeviceGbuiHistory)this.deviceGbuiHistoryMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceGbuiHistory::getMac, (Object)mac)).orderByDesc(DeviceGbuiHistory::getId)).last(" limit 1"));
    }
}

