/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportvideo.report;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Maps;
import com.ovopark.device.common.util.DateUtils;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.reportvideo.VideoRecordServiceImpl;
import com.ovopark.device.modules.reportvideo.dto.VideoRecordDto;
import com.ovopark.device.modules.reportvideo.dto.VideoRecordReqDto;
import com.ovopark.device.modules.reportvideo.dto.VideoRecordSubDto;
import com.ovopark.device.modules.reportvideo.es.VideoRecord;
import com.ovopark.device.modules.reportvideo.es.VideoTime;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.CellValue;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import jakarta.annotation.Resource;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/device-report/downloadVideoRecordExcel")
public class DownloadVideoRecordExcel
implements JobOutTaskFlow<VideoRecordReqDto> {
    private static final Logger log = LoggerFactory.getLogger(DownloadVideoRecordExcel.class);
    @Resource
    private ElasticsearchOperations elasticsearchOperations;
    @Autowired
    private VideoRecordServiceImpl videoRecordService;
    @Resource
    private MessageSource messageSource;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;

    public VideoRecordReqDto requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        VideoRecordReqDto videoRecordReqDto = (VideoRecordReqDto)JSONAccessor.impl().read(requestBody, VideoRecordReqDto.class);
        videoRecordReqDto.setGroupId(session.getGroupId());
        videoRecordReqDto.setUserId(session.getUserId());
        videoRecordReqDto.setLocale(session.clientInfo().getLocale());
        if (Util.isEmpty((CharSequence)videoRecordReqDto.getStartDate()) || Util.isEmpty((CharSequence)videoRecordReqDto.getEndDate())) {
            throw new IllegalArgumentException("argument error");
        }
        return videoRecordReqDto;
    }

    public void execute(VideoRecordReqDto requestParamBody, OutStore outStore) {
        log.info("execute > " + JSONAccessor.impl().format((Object)requestParamBody));
        List<Integer> depIdList = this.videoRecordService.getDeptIds(requestParamBody, requestParamBody.getGroupId(), requestParamBody.getUserId());
        if (Util.isEmpty(depIdList)) {
            log.info("cannot find any department");
            return;
        }
        String exportType = requestParamBody.getExportType();
        ArrayList<String> nvrList = new ArrayList();
        ArrayList<String> ipcList = new ArrayList();
        if (Util.compare2((Comparable)requestParamBody.getDeviceType(), (Comparable)Integer.valueOf(1)) == 0) {
            deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).in(DeviceStatus::getDepId, depIdList)).isNotNull(DeviceStatus::getPId)).eq(DeviceStatus::getIsDelete, (Object)0)).select(new SFunction[]{DeviceStatus::getMac}));
            if (Util.isEmpty((Collection)deviceStatusList)) {
                log.info("cannot find any device");
                return;
            }
            ipcList = deviceStatusList.stream().filter(Objects::nonNull).map(DeviceStatus::getMac).filter(Util::isNotEmpty).toList();
        } else {
            deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).in(DeviceStatus::getDepId, depIdList)).isNull(DeviceStatus::getPId)).eq(DeviceStatus::getIsDelete, (Object)0)).select(new SFunction[]{DeviceStatus::getMac}));
            if (Util.isEmpty((Collection)deviceStatusList)) {
                log.info("cannot find any device");
                return;
            }
            nvrList = deviceStatusList.stream().filter(Objects::nonNull).map(DeviceStatus::getMac).filter(Util::isNotEmpty).toList();
        }
        Locale locale = requestParamBody.getLocale();
        String sheetName = this.messageSource.getMessage("DeviceVideoRecordReport.excel", null, locale);
        String online = this.messageSource.getMessage("DeviceVideoRecordReport.online", null, locale);
        String offline = this.messageSource.getMessage("DeviceVideoRecordReport.offline", null, locale);
        String hasRecord = this.messageSource.getMessage("DeviceVideoRecordReport.hasRecord", null, locale);
        String noRecord = this.messageSource.getMessage("DeviceVideoRecordReport.noRecord", null, locale);
        String normal = this.messageSource.getMessage("DeviceVideoRecordReport.normal", null, locale);
        String sleep = this.messageSource.getMessage("DeviceVideoRecordReport.sleep", null, locale);
        String abnormal = this.messageSource.getMessage("DeviceVideoRecordReport.abnormal", null, locale);
        String uninitialized = this.messageSource.getMessage("DeviceVideoRecordReport.uninitialized", null, locale);
        HashMap dishStatusNvrMap = Maps.newHashMap();
        dishStatusNvrMap.put(0, normal);
        dishStatusNvrMap.put(1, sleep);
        dishStatusNvrMap.put(2, abnormal);
        dishStatusNvrMap.put(3, uninitialized);
        dishStatusNvrMap.put(4, offline);
        String absent = this.messageSource.getMessage("DeviceVideoRecordReport.absent", null, locale);
        String fault = this.messageSource.getMessage("DeviceVideoRecordReport.fault", null, locale);
        HashMap dishStatusWgMap = Maps.newHashMap();
        dishStatusWgMap.put(0, absent);
        dishStatusWgMap.put(1, fault);
        dishStatusWgMap.put(2, uninitialized);
        dishStatusWgMap.put(3, normal);
        OutStore.SegmentWriter segment = outStore.createSegment(sheetName);
        Segment.Header header = segment.header();
        header.upset(null, "root", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.reportTitle", null, locale));
        header.children("root", "deptName", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.deptName", null, locale));
        header.children("root", "orgName", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.orgName", null, locale));
        header.children("root", "deptCode", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.deptCode", null, locale));
        header.children("root", "deptType", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.deptType", null, locale));
        header.children("root", "deviceName", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.deviceName", null, locale));
        header.children("root", "nvrMac", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.nvrMac", null, locale));
        header.children("root", "nvrDeviceType", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.nvrDeviceType", null, locale));
        header.children("root", "nvrInTimeStr", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.nvrInTimeStr", null, locale));
        header.children("root", "dishStatus", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.dishStatus", null, locale));
        header.children("root", "dishCapacity", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.dishCapacity", null, locale));
        log.info("device type: " + requestParamBody.getDeviceType());
        if (Util.compare2((Comparable)requestParamBody.getDeviceType(), (Comparable)Integer.valueOf(1)) == 0) {
            log.info("NVR");
            header.children("root", "mainOnlineStatus", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.mainOnlineStatus", null, locale));
            header.children("root", "ipcName", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.ipcName", null, locale));
            header.children("root", "ipcOnlineStatus", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.ipcOnlineStatus", null, locale));
            header.children("root", "ipcMac", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.ipcMac", null, locale));
            header.children("root", "ipcInTimeStr", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.ipcInTimeStr", null, locale));
        } else {
            log.info("\u7f51\u7ba1\u8bbe\u5907");
            header.children("root", "onlineStatus", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.onlineStatus", null, locale));
        }
        header.children("root", "totalNum", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.totalNum", null, locale));
        header.children("root", "totalNumInDays", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.totalNumInDays", null, locale));
        header.children("root", "recTime", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.recTime", null, locale));
        header.children("root", "checkErr", null, path -> this.messageSource.getMessage("exportVideoDetails.status", null, locale));
        List dateStrList = DateUtils.getDays((String)requestParamBody.getStartDate(), (String)requestParamBody.getEndDate());
        for (String string : dateStrList) {
            header.children("root", "day-" + string, null, path -> string.replaceAll("-", "/"));
        }
        log.info(" set header ,OK , we get data, from ES ??? ");
        long count = 0L;
        while (true) {
            SearchRequest searchRequest = new SearchRequest(new String[]{"device-video-record"});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = this.videoRecordService.assembleQuery(requestParamBody, depIdList, nvrList, ipcList);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.from(0);
            searchSourceBuilder.size(10000);
            if (Util.isNotEmpty((CharSequence)requestParamBody.getLastIdForSearchAfter())) {
                searchSourceBuilder.searchAfter(new Object[]{requestParamBody.getLastIdForSearchAfter()});
            }
            searchSourceBuilder.sort("_id", SortOrder.ASC);
            searchRequest.source(searchSourceBuilder);
            List list = this.elasticsearchOperations.list(searchRequest, VideoRecord.class);
            if (Util.isEmpty((Collection)list)) break;
            List<VideoRecordDto> recordDtoList = this.videoRecordService.transferDto(list, requestParamBody.getGroupId(), requestParamBody.getStartDate(), requestParamBody.getEndDate());
            for (VideoRecordDto dto : recordDtoList) {
                HashMap rootMap = new HashMap();
                HashMap<Object, Object> valMap = new HashMap<Object, Object>();
                rootMap.put("root", valMap);
                valMap.put("deptName", dto.getDeptName());
                valMap.put("orgName", dto.getOrgName());
                valMap.put("deptCode", dto.getDeptCode());
                valMap.put("deptType", dto.getDeptType());
                valMap.put("deviceName", dto.getDeviceName());
                valMap.put("nvrMac", dto.getNvrMac());
                valMap.put("nvrDeviceType", dto.getNvrDeviceType());
                valMap.put("nvrInTimeStr", dto.getNvrInTime() == null ? null : Util.formatTime((LocalDateTime)dto.getNvrInTime(), (String[])new String[0]));
                valMap.put("ipcInTimeStr", dto.getIpcInTime() == null ? null : Util.formatTime((LocalDateTime)dto.getIpcInTime(), (String[])new String[0]));
                if (dto.getDeviceType() == 1) {
                    valMap.put("dishStatus", dishStatusNvrMap.get(dto.getDishStatus()));
                } else {
                    valMap.put("dishStatus", dishStatusWgMap.get(dto.getDishStatus()));
                }
                valMap.put("dishCapacity", dto.getDishCapacity());
                valMap.put("onlineStatus", Objects.nonNull(dto.getOnlineStatus()) && dto.getOnlineStatus() == 1 ? online : offline);
                valMap.put("mainOnlineStatus", Objects.nonNull(dto.getOnlineStatus()) && dto.getOnlineStatus() == 1 ? online : offline);
                valMap.put("ipcMac", dto.getIpcMac());
                valMap.put("ipcName", dto.getIpcName());
                valMap.put("ipcOnlineStatus", Objects.nonNull(dto.getIpcOnlineStatus()) && dto.getIpcOnlineStatus() == 1 ? online : offline);
                valMap.put("totalNum", dto.getTotalNum());
                valMap.put("totalNumInDays", dto.getTotalNumInDays());
                valMap.put("recTime", dto.getRecTime() == null ? null : Util.formatTime((LocalDateTime)dto.getRecTime(), (String[])new String[0]));
                valMap.put("checkErr", dto.getCheckErr() == null ? "" : (dto.getCheckErr() != false ? this.messageSource.getMessage("exportVideoDetails.status.warm", null, locale) : this.messageSource.getMessage("exportVideoDetails.status.normal", null, locale)));
                List<VideoRecordSubDto> data = dto.getData();
                if (Util.isNotEmpty(data)) {
                    Map<Integer, String> yearDataMap = data.stream().collect(Collectors.toMap(a -> a.getYear(), a -> a.getData(), (x, y) -> x));
                    for (String string : dateStrList) {
                        Integer year;
                        String yearData;
                        String propertyKey = "day-" + string;
                        if (Util.compare2((Comparable)((Object)exportType), (Comparable)((Object)"2")) == 0) {
                            header.upset("root." + propertyKey, propertyKey + "-status", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.videoStatus", null, locale));
                            header.upset("root." + propertyKey, propertyKey + "-time", null, path -> this.messageSource.getMessage("DeviceVideoRecordReport.videoTime", null, locale));
                        }
                        if (Util.isNotEmpty((CharSequence)(yearData = yearDataMap.get(year = Integer.valueOf(string.split("-")[0]))))) {
                            int dayIndexOfYear = VideoRecordServiceImpl.getDayIndexOfYear(string);
                            if (dayIndexOfYear > yearData.length()) {
                                valMap.put(propertyKey, "/");
                                continue;
                            }
                            char c = yearData.charAt(dayIndexOfYear - 1);
                            if (c == '1') {
                                List<List<Long>> videoTimeDay;
                                valMap.put(propertyKey, CellValue.from((Object)hasRecord, (Object)Character.valueOf(c)));
                                if (Util.compare2((Comparable)((Object)exportType), (Comparable)((Object)"2")) != 0) continue;
                                HashMap<CallSite, Object> dayMap = new HashMap<CallSite, Object>();
                                dayMap.put((CallSite)((Object)(propertyKey + "-status")), CellValue.from((Object)hasRecord, (Object)Character.valueOf(c)));
                                VideoTime videoTime = (VideoTime)this.elasticsearchOperations.get("device-video-time", dto.getNvrMac() + ":" + dto.getChannelId() + ":" + string.replaceAll("-", ""), VideoTime.class);
                                if (videoTime != null && Util.isNotEmpty(videoTimeDay = videoTime.getVideoTimeDay())) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    List<List<Long>> timeMerge = this.videoTimeMerge(videoTimeDay, Util.date((String)string, (String[])new String[]{"yyyy-MM-dd"}));
                                    for (List<Long> longList : timeMerge) {
                                        if (!Util.isNotEmpty(longList) || longList.size() < 2) continue;
                                        LocalDateTime start = Util.dateTime((long)(longList.get(0) * 1000L));
                                        LocalDateTime end = Util.dateTime((long)(longList.get(1) * 1000L));
                                        String startStr = start.getHour() + "\u65f6" + start.getMinute() + "\u5206" + start.getSecond() + "\u79d2";
                                        String endStr = end.getHour() + "\u65f6" + end.getMinute() + "\u5206" + end.getSecond() + "\u79d2";
                                        stringBuilder.append(startStr + " - " + endStr + "\r\n");
                                    }
                                    dayMap.put((CallSite)((Object)(propertyKey + "-time")), stringBuilder.toString());
                                }
                                valMap.put(propertyKey, dayMap);
                                continue;
                            }
                            if (c != '0') continue;
                            valMap.put(propertyKey, CellValue.from((Object)noRecord, (Object)Character.valueOf(c)));
                            continue;
                        }
                        valMap.put(propertyKey, "/");
                    }
                }
                segment.append(rootMap);
                ++count;
            }
            if (list.size() < 10000) break;
            requestParamBody.setLastIdForSearchAfter(((VideoRecord)list.getLast()).getId());
        }
        segment.meta(Map.of("time", Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0])));
        segment.commit();
        log.info("all data length: " + count);
        Object fileName = this.messageSource.getMessage("DeviceVideoRecordReport.excel", null, locale);
        fileName = Util.compare2((Comparable)requestParamBody.getDeviceType(), (Comparable)Integer.valueOf(1)) == 0 ? (String)fileName + "(NVR)" : (String)fileName + "(\u7f51\u7ba1\u8bbe\u5907)";
        outStore.fileName((String)fileName);
        if (Util.compare2((Comparable)((Object)exportType), (Comparable)((Object)"2")) == 0) {
            segment.feature().supportRangeMerge(true);
            outStore.feature().supportRangeMerge(true);
        }
    }

    public JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider(VideoRecordReqDto requestParamBody, Session session) {
        Object fileName = this.messageSource.getMessage("DeviceVideoRecordReport.excel", null, session.clientInfo().getLocale());
        fileName = Util.compare2((Comparable)requestParamBody.getDeviceType(), (Comparable)Integer.valueOf(1)) == 0 ? (String)fileName + "(NVR)" : (String)fileName + "(\u7f51\u7ba1\u8bbe\u5907)";
        Object finalFileName = fileName;
        return new JobOutTaskFlow.ExportTaskInfoProvider(){
            final /* synthetic */ String val$finalFileName;
            {
                this.val$finalFileName = string;
            }

            public String name() {
                return this.val$finalFileName;
            }
        };
    }

    private List<List<Long>> videoTimeMerge(List<List<Long>> timeList, LocalDate day) {
        long startAtDay = day.toEpochSecond(LocalTime.MIN, Util.GMT_08);
        long endAtDay = day.toEpochSecond(LocalTime.MAX, Util.GMT_08);
        ArrayList<List<Long>> result = new ArrayList<List<Long>>(timeList.size());
        ArrayList<Long> got = new ArrayList<Long>();
        for (int i = 0; i < timeList.size(); ++i) {
            List<Long> a = timeList.get(i);
            if (i == 0) {
                got.add(a.get(0));
                got.add(a.get(1));
                continue;
            }
            if (Util.compare2((Comparable)((Comparable)got.get(1)), (Comparable)a.get(0)) == 0) {
                got.set(1, a.get(1));
                continue;
            }
            result.add(got);
            got = new ArrayList();
            got.add(a.get(0));
            got.add(a.get(1));
        }
        result.add(got);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            List next = (List)iterator.next();
            Long b = (Long)next.get(0);
            Long a = (Long)next.get(1);
            if (a < startAtDay || b > endAtDay) {
                iterator.remove();
            }
            if (b < startAtDay) {
                next.set(0, startAtDay);
            }
            if (a <= endAtDay) continue;
            next.set(1, endAtDay);
        }
        return result;
    }
}

