/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import jakarta.annotation.Resource;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    @Resource(name="deviceStringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    public boolean tryLock(String lockKey, String requestId, long expireTime, TimeUnit timeUnit) {
        try {
            Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)requestId, expireTime, timeUnit);
            return Boolean.TRUE.equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean releaseLock(String lockKey, String requestId) {
        String luaScript = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        try {
            Long result = (Long)this.redisTemplate.execute(connection -> (Long)connection.eval(luaScript.getBytes(), ReturnType.INTEGER, 1, (byte[][])new byte[][]{lockKey.getBytes(), requestId.getBytes()}));
            return Long.valueOf(1L).equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void demo() {
        String lockKey = "business:lock";
        String requestId = UUID.randomUUID().toString();
        try {
            boolean locked = this.tryLock(lockKey, requestId, 10L, TimeUnit.SECONDS);
            if (!locked) {
                throw new RuntimeException("\u83b7\u53d6\u9501\u5931\u8d25");
            }
        }
        finally {
            this.releaseLock(lockKey, requestId);
        }
    }
}

