/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportlog;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.reportlog.DeviceInOrOutLogService;
import com.ovopark.device.modules.reportlog.mysql.DeviceInOrOutLog;
import com.ovopark.device.modules.reportlog.mysql.DeviceInOrOutLogMapper;
import com.ovopark.device.modules.reportlog.vo.DeviceInoutLogQueryVo;
import com.ovopark.device.modules.reportlog.vo.DeviceInoutLogResultVo;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.signalling.contact.VersionConstant;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class DeviceInOrOutLogServiceImpl
implements DeviceInOrOutLogService {
    private static final Logger log = LoggerFactory.getLogger(DeviceInOrOutLogServiceImpl.class);
    @Resource
    private DeviceInOrOutLogMapper baseMapper;
    @Autowired
    private RPCFacade rpcFacade;
    @Resource
    private MessageSource messageSource;

    @Override
    public void saveLog(DeviceInOrOutLog deviceInOrOutLog) {
        deviceInOrOutLog.setCreateAt(LocalDateTime.now());
        this.baseMapper.insert(deviceInOrOutLog);
    }

    @Override
    public List<DeviceInOrOutLog> getLogList(String startTime, String endTime, String mac) {
        LambdaQueryWrapper deviceInOrOutLogLambdaQueryWrapper = new LambdaQueryWrapper();
        if (startTime != null) {
            deviceInOrOutLogLambdaQueryWrapper.ge(DeviceInOrOutLog::getCreateAt, (Object)startTime);
        }
        if (endTime != null) {
            deviceInOrOutLogLambdaQueryWrapper.le(DeviceInOrOutLog::getCreateAt, (Object)endTime);
        }
        deviceInOrOutLogLambdaQueryWrapper.eq(DeviceInOrOutLog::getMac, (Object)mac);
        return this.baseMapper.selectList((Wrapper)deviceInOrOutLogLambdaQueryWrapper);
    }

    @Override
    public PageModel<DeviceInoutLogResultVo> query(DeviceInoutLogQueryVo deviceInoutLogQueryVo) {
        List list;
        Objects.requireNonNull(deviceInoutLogQueryVo.getGroupId());
        Integer typeGroup = deviceInoutLogQueryVo.getTypeGroup();
        ArrayList<Integer> dTypeList = null;
        if (typeGroup != null) {
            switch (typeGroup) {
                case 1: {
                    dTypeList = new ArrayList(VersionConstant.box);
                    break;
                }
                case 2: {
                    dTypeList = new ArrayList(VersionConstant.ipc);
                    break;
                }
                case 3: {
                    dTypeList = new ArrayList(VersionConstant.alg);
                    break;
                }
                case 4: {
                    dTypeList = Arrays.asList(22);
                }
            }
        }
        Session session = Session.getOrCreate().get();
        Integer groupId = session.getGroupId();
        Integer userId = session.getUserId();
        String opeUserName = deviceInoutLogQueryVo.getOpeUserName();
        List<Integer> userIdList = null;
        if (Util.isNotEmpty((CharSequence)opeUserName) && Util.isEmpty(userIdList = (list = this.rpcFacade.getSimpleUserByKeyWord(groupId, opeUserName, null)).stream().map(SimplePojo::getId).collect(Collectors.toList()))) {
            userIdList.add(Integer.MIN_VALUE);
        }
        Integer queryGroupId = deviceInoutLogQueryVo.getGroupId();
        ArrayList<Integer> deptIdList = new ArrayList<Integer>();
        String deptId = deviceInoutLogQueryVo.getDeptId();
        if (Util.isNotEmpty((CharSequence)deptId)) {
            if (deptId.startsWith("O_")) {
                String orgStr = deptId.substring("O_".length());
                DepIdsAndUserMo depIdsAndUserMo = new DepIdsAndUserMo();
                depIdsAndUserMo.setUserId(session.getUserId());
                depIdsAndUserMo.setUserGroupId(session.getGroupId());
                depIdsAndUserMo.setOrganizeIdList(Arrays.asList("O_" + orgStr));
                depIdsAndUserMo.setIsDel(Integer.valueOf(0));
                depIdsAndUserMo.setStatus(Arrays.asList(0, 1));
                List list2 = this.rpcFacade.getUserPrivilegeDepByOrganizeIds(depIdsAndUserMo);
                list2.forEach(departmentOrgMo -> {
                    if (departmentOrgMo.getDepId() != null) {
                        deptIdList.add(departmentOrgMo.getDepId());
                    }
                });
            } else {
                deptIdList.add(Integer.valueOf(deptId.substring("S_".length())));
            }
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.plus(-30L, ChronoUnit.DAYS);
        String opeTimeStart = deviceInoutLogQueryVo.getOpeTimeStart();
        String opeTimeEnd = deviceInoutLogQueryVo.getOpeTimeEnd();
        if (Util.isEmpty((CharSequence)opeTimeStart)) {
            opeTimeStart = Util.formatTime((LocalDateTime)start, (String[])new String[0]);
        }
        if (Util.isEmpty((CharSequence)opeTimeEnd)) {
            opeTimeEnd = Util.formatTime((LocalDateTime)now, (String[])new String[0]);
        }
        Page page = new Page(deviceInoutLogQueryVo.getPageNumber(), (long)deviceInoutLogQueryVo.getPageSize());
        IPage<DeviceInoutLogResultVo> queryPage = this.baseMapper.queryPage((Page<DeviceInoutLogResultVo>)page, userIdList, queryGroupId, Util.isEmpty(deptIdList) ? null : deptIdList, dTypeList, deviceInoutLogQueryVo.getMac(), opeTimeStart, opeTimeEnd);
        List list3 = queryPage.getRecords().stream().map(DeviceInOrOutLog::getDepId).collect(Collectors.toList());
        List departmentList = this.rpcFacade.departmentList(list3);
        Map<Integer, DepartmentPojo> collect = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        EnterpriseGroupMo enterprise = this.rpcFacade.enterprise(queryGroupId);
        List usersPojos = this.rpcFacade.getUserByIdList(queryPage.getRecords().stream().map(DeviceInOrOutLog::getUserId).filter(Objects::nonNull).collect(Collectors.toList()));
        Map<Integer, UsersPojo> usersPojoMap = usersPojos.stream().collect(Collectors.toMap(UsersPojo::getId, v -> v));
        for (DeviceInoutLogResultVo record : queryPage.getRecords()) {
            Integer dType;
            UsersPojo usersPojo;
            DepartmentPojo departmentPojo = collect.get(record.getDepId());
            if (departmentPojo != null) {
                record.setDeptName(departmentPojo.getName());
            }
            record.setGroupName(enterprise.getName());
            if (record.getUserId() != null && (usersPojo = usersPojoMap.get(record.getUserId())) != null) {
                record.setUserName(usersPojo.getShowName());
            }
            if ((dType = record.getDtype()) == null) continue;
            String stringType = "";
            Locale locale = session.clientInfo().getLocale();
            if (VersionConstant.box.contains(dType)) {
                stringType = this.messageSource.getMessage("device.type.box", null, locale);
            }
            if (VersionConstant.ipc.contains(dType)) {
                stringType = this.messageSource.getMessage("device.type.ipc", null, locale);
            }
            if (VersionConstant.alg.contains(dType)) {
                stringType = this.messageSource.getMessage("device.type.alg", null, locale);
            }
            if (22 == dType) {
                stringType = this.messageSource.getMessage("device.type.wgipc", null, locale);
            }
            record.setDeviceTypeName(stringType);
        }
        PageModel model = new PageModel();
        model.setTotal(queryPage.getTotal());
        model.setPageNumber(queryPage.getCurrent());
        model.setPageSize(deviceInoutLogQueryVo.getPageSize());
        model.setData(queryPage.getRecords());
        return model;
    }
}

