/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.onlineDetail;

import com.ovopark.device.modules.onlineDetail.DataClearService;
import com.ovopark.device.modules.onlineDetail.model.KafkaOnlineDataSource;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClearServiceExample {
    private static final Logger log = LoggerFactory.getLogger(DataClearServiceExample.class);

    public static void main(String[] args) {
        DataClearService service = new DataClearService();
        service.startMemoryManagement();
        try {
            DataClearServiceExample.demonstrateSingleDataProcessing(service);
            DataClearServiceExample.demonstrateBatchDataProcessing(service);
            DataClearServiceExample.demonstrateFinalDataClear(service);
            DataClearServiceExample.demonstrateMemoryMonitoring(service);
        }
        finally {
            service.stopMemoryManagement();
        }
    }

    private static void demonstrateSingleDataProcessing(DataClearService service) {
        String key = "2023-12-01@shard1";
        KafkaOnlineDataSource data = new KafkaOnlineDataSource();
        data.setId("device_001");
        data.setTs(System.currentTimeMillis());
        data.setStatus(1);
        service.clearData(key, data);
        log.info("Single data processing completed for device: {}", (Object)data.getId());
    }

    private static void demonstrateBatchDataProcessing(DataClearService service) {
        String key = "2023-12-01@shard1";
        ArrayList<KafkaOnlineDataSource> dataList = new ArrayList<KafkaOnlineDataSource>();
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 500; ++j) {
                KafkaOnlineDataSource data = new KafkaOnlineDataSource();
                data.setId("device_" + String.format("%03d", i));
                data.setTs(System.currentTimeMillis() + (long)(j * 1000));
                data.setStatus(j % 2 == 0 ? 1 : 0);
                dataList.add(data);
            }
        }
        log.info("Processing batch data: {} entries", (Object)dataList.size());
        service.clearDataBatch(key, dataList);
        log.info("Batch data processing completed");
    }

    private static void demonstrateFinalDataClear(DataClearService service) {
        String key = "2023-12-01@shard1";
        log.info("Starting final data clear for key: {}", (Object)key);
        service.clearDataFinal(key);
        log.info("Final data clear completed for key: {}", (Object)key);
    }

    private static void demonstrateMemoryMonitoring(DataClearService service) {
        log.info("Current memory usage: {}", service.getMemoryUsage());
        log.info("Cleanup statistics: {}", (Object)service.getCleanupStats());
        service.performMemoryCleanup();
        log.info("Manual memory cleanup completed");
    }

    private static void performanceTest(DataClearService service) {
        int threadCount = Runtime.getRuntime().availableProcessors() * 2;
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        String key = "2023-12-01@shard_performance";
        long startTime = System.currentTimeMillis();
        int t = 0;
        while (t < 100) {
            int threadId = t++;
            executor.submit(() -> {
                ArrayList<KafkaOnlineDataSource> threadData = new ArrayList<KafkaOnlineDataSource>();
                for (int i = 0; i < 10; ++i) {
                    KafkaOnlineDataSource data = new KafkaOnlineDataSource();
                    data.setId("thread_" + threadId + "_device_" + i);
                    data.setTs(System.currentTimeMillis());
                    data.setStatus(i % 2);
                    threadData.add(data);
                }
                service.clearDataBatch(key, threadData);
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long endTime = System.currentTimeMillis();
        log.info("Performance test completed. Time: {}ms", (Object)(endTime - startTime));
        log.info("Final memory usage: {}", service.getMemoryUsage());
    }
}

