/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.modules.platform.PlatformsGbService;
import com.ovopark.device.modules.platform.mysql.PlatformsGb;
import com.ovopark.device.modules.platform.mysql.PlatformsGbMapper;
import jakarta.annotation.Resource;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PlatformsGbServiceImpl
implements PlatformsGbService {
    private static final Logger log = LoggerFactory.getLogger(PlatformsGbServiceImpl.class);
    @Resource
    private PlatformsGbMapper platformsGbMapper;
    @Resource(name="shopwebStringRedisTemplate")
    private StringRedisTemplate shopwebRedisTemplate;
    private static final String KEY_F = "cache:device:platforms:gb:";

    @Override
    public PlatformsGb getPlatformsGbById(Integer id) {
        if (id != null) {
            PlatformsGb platformsGb = null;
            platformsGb = this.getFromCache(id);
            if (platformsGb != null) {
                return platformsGb;
            }
            platformsGb = (PlatformsGb)this.platformsGbMapper.selectById(id);
            if (platformsGb != null) {
                this.setCache(id, platformsGb);
            }
            return platformsGb;
        }
        return null;
    }

    private void setCache(Integer id, PlatformsGb gb) {
        this.shopwebRedisTemplate.opsForValue().set((Object)(KEY_F + id), (Object)JsonUtils.beanToJsonString((Object)gb), 5L, TimeUnit.MINUTES);
    }

    private void removeCache(Integer id) {
        this.shopwebRedisTemplate.delete((Object)(KEY_F + id));
    }

    private PlatformsGb getFromCache(Integer id) {
        String o = (String)this.shopwebRedisTemplate.opsForValue().get((Object)(KEY_F + id));
        if (o != null) {
            return (PlatformsGb)JsonUtils.jsonToBean((String)o, PlatformsGb.class);
        }
        return null;
    }
}

