/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.onlineDetail;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.modules.onlineDetail.model.KafkaOnlineDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataClearService {
    private static final Logger log = LoggerFactory.getLogger(DataClearService.class);
    private final Map<String, DeviceDataCache> rawMap = new ConcurrentHashMap<String, DeviceDataCache>();
    private static final int MAX_CACHE_ENTRIES = 100;
    private static final long MEMORY_CLEANUP_INTERVAL_MS = 600000L;
    private static final int MAX_DEVICE_IDS_PER_CACHE = 10000;
    private static final int MAX_TIMESTAMPS_PER_DEVICE = 1000;
    private static final double CLEANUP_THRESHOLD = 1.5;
    private static final long CLEANUP_SAFETY_DELAY_MS = 30000L;
    private final ProcessingStatus processingStatus = new ProcessingStatus();
    private final CleanupStats cleanupStats = new CleanupStats();
    private ScheduledExecutorService scheduler;

    public Map<String, DeviceDataCache> getRawMap() {
        return this.rawMap;
    }

    public void startMemoryManagement() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            log.warn("Memory management is already running");
            return;
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(this::performMemoryCleanup, 600000L, 600000L, TimeUnit.MILLISECONDS);
        log.info("Memory management started with cleanup interval: {} minutes", (Object)10L);
    }

    public void stopMemoryManagement() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            log.info("Memory management stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(String key, KafkaOnlineDataSource sourceData) {
        this.processingStatus.startOperation(key);
        try {
            DeviceDataCache cache = this.rawMap.computeIfAbsent(key, k -> new DeviceDataCache((String)k));
            if (cache.getKey() == null) {
                cache.setKey(key);
            }
            cache.putData(sourceData.getId(), sourceData.getTs(), sourceData.getStatus());
        }
        finally {
            this.processingStatus.endOperation(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataBatch(String key, List<KafkaOnlineDataSource> sourceDataList) {
        this.processingStatus.startOperation(key);
        try {
            DeviceDataCache cache = this.rawMap.computeIfAbsent(key, k -> new DeviceDataCache((String)k));
            if (cache.getKey() == null) {
                cache.setKey(key);
            }
            for (KafkaOnlineDataSource sourceData : sourceDataList) {
                cache.putData(sourceData.getId(), sourceData.getTs(), sourceData.getStatus());
            }
        }
        finally {
            this.processingStatus.endOperation(key);
        }
    }

    public void clearDataFinal(String key) {
        DeviceDataCache cache = this.rawMap.get(key);
        if (cache == null || cache.size() == 0) {
            log.warn("{} data empty", (Object)key);
        }
        Set<String> deviceIds = cache.getAllDeviceIds();
        int maxConcurrency = Math.min(deviceIds.size(), Runtime.getRuntime().availableProcessors() * 2);
        Semaphore semaphore = new Semaphore(maxConcurrency);
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (String deviceId : deviceIds) {
                tasks.add(() -> {
                    try {
                        semaphore.acquire();
                        try {
                            this.processDeviceData(key, deviceId, cache);
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("device processing interrupted for deviceId: {}, key: {}", new Object[]{deviceId, key, e});
                    }
                    catch (Exception e) {
                        log.error("device processing error for deviceId: {}, key: {}", new Object[]{deviceId, key, e});
                        semaphore.release();
                    }
                });
            }
            for (Runnable task : tasks) {
                executor.submit(task);
            }
            executor.shutdown();
            if (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                log.warn("clearDataFinal task execution timeout for key: {}", (Object)key);
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("clearDataFinal interrupted for key: {}", (Object)key, (Object)e);
        }
        catch (Exception e) {
            log.error("clearDataFinal error for key: {}", (Object)key, (Object)e);
        }
        log.info("{} raw data :{}", (Object)key, (Object)JsonUtils.beanToJsonStringForLog((Object)cache));
    }

    private void processDeviceData(String key, String deviceId, DeviceDataCache cache) {
        try {
            TreeMap<Long, Integer> deviceDataMap;
            Map<Long, Integer> dateLastInfo = this.getDateLastInfo(key.split("@")[0], deviceId);
            if (CollectionUtils.isNotEmpty(dateLastInfo) && (deviceDataMap = cache.getDeviceData(deviceId)) != null) {
                deviceDataMap.putAll(dateLastInfo);
                this.deduplicateDeviceData(deviceDataMap);
            }
        }
        catch (Exception e) {
            log.error("processDeviceData error for deviceId: {}, key: {}", new Object[]{deviceId, key, e});
        }
    }

    private void deduplicateDeviceData(TreeMap<Long, Integer> deviceDataMap) {
        if (deviceDataMap.size() <= 1) {
            return;
        }
        ArrayList<Long> keysToRemove = new ArrayList<Long>();
        Integer previousValue = null;
        for (Map.Entry<Long, Integer> entry : deviceDataMap.entrySet()) {
            Integer currentValue = entry.getValue();
            if (previousValue != null && currentValue.equals(previousValue)) {
                keysToRemove.add(entry.getKey());
            }
            previousValue = currentValue;
        }
        for (Long key : keysToRemove) {
            deviceDataMap.remove(key);
        }
        log.debug("Removed {} duplicate entries from device data, remaining: {}", (Object)keysToRemove.size(), (Object)deviceDataMap.size());
    }

    public void performMemoryCleanup() {
        int cleanupThreshold;
        long startTime = System.currentTimeMillis();
        log.info("\u68c0\u67e5\u662f\u5426\u9700\u8981\u6267\u884c\u5185\u5b58\u6e05\u7406...");
        if (this.processingStatus.hasActiveOperations()) {
            long waitTime = 600000L;
            this.cleanupStats.recordSkippedCleanup(waitTime);
            log.info("\u8df3\u8fc7\u6e05\u7406\uff1a\u6709 {} \u4e2a\u6d3b\u8dc3\u64cd\u4f5c", (Object)this.processingStatus.getActiveOperations());
            return;
        }
        int currentSize = this.rawMap.size();
        if (currentSize <= (cleanupThreshold = 150)) {
            long waitTime = 600000L;
            this.cleanupStats.recordSkippedCleanup(waitTime);
            log.debug("\u8df3\u8fc7\u6e05\u7406\uff1a\u5f53\u524d\u5927\u5c0f {} \u672a\u8d85\u8fc7\u9608\u503c {}", (Object)currentSize, (Object)cleanupThreshold);
            return;
        }
        long currentTime = System.currentTimeMillis();
        boolean hasRecentActivity = false;
        for (Map.Entry<String, DeviceDataCache> entry : this.rawMap.entrySet()) {
            long inactiveTime = this.processingStatus.getInactiveTime(entry.getKey());
            if (inactiveTime >= 30000L) continue;
            hasRecentActivity = true;
            break;
        }
        if (hasRecentActivity) {
            long waitTime = 30000L;
            this.cleanupStats.recordSkippedCleanup(waitTime);
            log.info("\u8df3\u8fc7\u6e05\u7406\uff1a\u6700\u8fd1\u6709\u6570\u636e\u64cd\u4f5c\uff0c\u9700\u8981\u7b49\u5f85\u5b89\u5168\u5ef6\u8fdf\u671f");
            return;
        }
        log.info("\u5f00\u59cb\u6267\u884c\u5b89\u5168\u5185\u5b58\u6e05\u7406\uff0c\u5f53\u524d\u7f13\u5b58\u5927\u5c0f: {}, \u9608\u503c: {}", (Object)currentSize, (Object)cleanupThreshold);
        int removedEntries = 0;
        try {
            removedEntries += this.cleanupOldestDevicesSafely();
            this.cleanupStats.recordCleanup(removedEntries += this.cleanupOldestCachesSafely());
            log.info("\u5b89\u5168\u5185\u5b58\u6e05\u7406\u5b8c\u6210\uff0c\u5220\u9664\u4e86 {} \u4e2a\u7f13\u5b58\u6761\u76ee\uff0c\u8017\u65f6 {}ms", (Object)removedEntries, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            log.error("\u5185\u5b58\u6e05\u7406\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private int cleanupOldestDevicesSafely() {
        int cleanupThreshold;
        int removed = 0;
        int currentSize = this.rawMap.size();
        if (currentSize <= (cleanupThreshold = 150)) {
            return 0;
        }
        ArrayList<Map.Entry<String, DeviceDataCache>> entries = new ArrayList<Map.Entry<String, DeviceDataCache>>(this.rawMap.entrySet());
        entries.sort(Map.Entry.comparingByValue((cache1, cache2) -> {
            Long time1 = cache1.getCreationTime();
            Long time2 = cache2.getCreationTime();
            long inactive1 = this.processingStatus.getInactiveTime(cache1.key);
            long inactive2 = this.processingStatus.getInactiveTime(cache2.key);
            return Long.compare(inactive1, inactive2);
        }));
        int targetSize = 85;
        int toRemove = Math.min(entries.size() - targetSize, entries.size() / 4);
        for (int i = 0; i < toRemove && i < entries.size(); ++i) {
            String key = (String)((Map.Entry)entries.get(i)).getKey();
            if (this.processingStatus.isKeyActive(key) || this.processingStatus.getInactiveTime(key) < 30000L) continue;
            this.rawMap.remove(key);
            ++removed;
            log.debug("\u6e05\u7406\u8bbe\u5907\u7f13\u5b58: {}", (Object)key);
        }
        return removed;
    }

    private int cleanupOldestCachesSafely() {
        int removed = 0;
        for (DeviceDataCache cache : this.rawMap.values()) {
            long inactiveTime;
            if (this.processingStatus.isKeyActive(cache.key) || (inactiveTime = this.processingStatus.getInactiveTime(cache.key)) < 30000L) continue;
            int cacheRemoved = 0;
            if (cache.deviceCache.size() > 10000) {
                ArrayList<Map.Entry<String, TreeMap<Long, Integer>>> deviceEntries = new ArrayList<Map.Entry<String, TreeMap<Long, Integer>>>(cache.deviceCache.entrySet());
                deviceEntries.sort(Map.Entry.comparingByValue((map1, map2) -> {
                    Long time1 = map1.isEmpty() ? 0L : (Long)map1.firstKey();
                    Long time2 = map2.isEmpty() ? 0L : (Long)map2.firstKey();
                    return time1 != null && time2 != null ? time1.compareTo(time2) : 0;
                }));
                int toRemove = Math.min(deviceEntries.size() - 7500, deviceEntries.size() / 3);
                for (int i = 0; i < toRemove && i < deviceEntries.size(); ++i) {
                    String deviceId = (String)((Map.Entry)deviceEntries.get(i)).getKey();
                    cache.deviceCache.remove(deviceId);
                    ++cacheRemoved;
                }
            }
            for (TreeMap<Long, Integer> timestampMap : cache.deviceCache.values()) {
                int removedCount;
                if (timestampMap.size() <= 1000) continue;
                int toRemove = timestampMap.size() - 750;
                Iterator<Map.Entry<Long, Integer>> iterator = timestampMap.entrySet().iterator();
                for (removedCount = 0; iterator.hasNext() && removedCount < toRemove; ++removedCount) {
                    iterator.next();
                    iterator.remove();
                }
                cacheRemoved += removedCount;
            }
            removed += cacheRemoved;
            if (cacheRemoved <= 0) continue;
            log.debug("\u4ece\u7f13\u5b58 {} \u4e2d\u6e05\u7406\u4e86 {} \u4e2a\u6761\u76ee", (Object)cache.key, (Object)cacheRemoved);
        }
        return removed;
    }

    public String getCleanupStats() {
        return this.cleanupStats.getStats();
    }

    public Map<String, Object> getMemoryUsage() {
        HashMap<String, Object> usage = new HashMap<String, Object>();
        usage.put("totalCaches", this.rawMap.size());
        int totalDevices = 0;
        long totalEntries = 0L;
        for (DeviceDataCache cache : this.rawMap.values()) {
            totalDevices += cache.size();
            for (TreeMap<Long, Integer> deviceData : cache.getAllData().values()) {
                totalEntries += (long)deviceData.size();
            }
        }
        usage.put("totalDevices", totalDevices);
        usage.put("totalEntries", totalEntries);
        usage.put("cleanupStats", this.cleanupStats.getStats());
        return usage;
    }

    public void clearRawData(String key) {
        this.rawMap.remove(key);
    }

    public Map<Long, Integer> getDateLastInfo(String date, String id) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        resultMap.put(0L, 0);
        return resultMap;
    }

    private static class ProcessingStatus {
        private final Set<String> activeKeys = Collections.synchronizedSet(new HashSet());
        private final Map<String, Long> lastActivityTime = new ConcurrentHashMap<String, Long>();
        private final AtomicLong totalOperations = new AtomicLong(0L);
        private final AtomicLong activeOperations = new AtomicLong(0L);

        private ProcessingStatus() {
        }

        public void startOperation(String key) {
            this.activeKeys.add(key);
            this.lastActivityTime.put(key, System.currentTimeMillis());
            this.activeOperations.incrementAndGet();
            this.totalOperations.incrementAndGet();
        }

        public void endOperation(String key) {
            this.activeKeys.remove(key);
            this.lastActivityTime.put(key, System.currentTimeMillis());
            this.activeOperations.decrementAndGet();
        }

        public boolean isKeyActive(String key) {
            return this.activeKeys.contains(key);
        }

        public boolean hasActiveOperations() {
            return this.activeOperations.get() > 0L;
        }

        public long getInactiveTime(String key) {
            Long lastActivity = this.lastActivityTime.get(key);
            return lastActivity != null ? System.currentTimeMillis() - lastActivity : Long.MAX_VALUE;
        }

        public long getTotalOperations() {
            return this.totalOperations.get();
        }

        public long getActiveOperations() {
            return this.activeOperations.get();
        }
    }

    private static class CleanupStats {
        private int totalCleanups = 0;
        private long totalEntriesRemoved = 0L;
        private long lastCleanupTime = 0L;
        private int skippedCleanups = 0;
        private long totalSkippedTime = 0L;

        private CleanupStats() {
        }

        public synchronized void recordCleanup(int entriesRemoved) {
            ++this.totalCleanups;
            this.totalEntriesRemoved += (long)entriesRemoved;
            this.lastCleanupTime = System.currentTimeMillis();
        }

        public synchronized void recordSkippedCleanup(long skipReason) {
            ++this.skippedCleanups;
            this.totalSkippedTime += skipReason;
        }

        public synchronized String getStats() {
            return String.format("Cleanups: %d, Entries removed: %d, Skipped: %d, Last cleanup: %s, Avg skip time: %dms", this.totalCleanups, this.totalEntriesRemoved, this.skippedCleanups, this.lastCleanupTime > 0L ? new Date(this.lastCleanupTime) : "Never", this.skippedCleanups > 0 ? this.totalSkippedTime / (long)this.skippedCleanups : 0L);
        }
    }

    private static class DeviceDataCache {
        private String key;
        private final long creationTime;
        private final ConcurrentHashMap<String, TreeMap<Long, Integer>> deviceCache = new ConcurrentHashMap();

        public DeviceDataCache() {
            this.creationTime = System.currentTimeMillis();
        }

        public DeviceDataCache(String key) {
            this.key = key;
            this.creationTime = System.currentTimeMillis();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public void putData(String deviceId, long timestamp, int status) {
            this.deviceCache.computeIfAbsent(deviceId, k -> new TreeMap()).put(timestamp, status);
        }

        public void putAllData(String deviceId, Map<Long, Integer> data) {
            TreeMap timeMap = this.deviceCache.computeIfAbsent(deviceId, k -> new TreeMap());
            timeMap.putAll(data);
        }

        public TreeMap<Long, Integer> getDeviceData(String deviceId) {
            return this.deviceCache.get(deviceId);
        }

        public Set<String> getAllDeviceIds() {
            return this.deviceCache.keySet();
        }

        public Map<String, TreeMap<Long, Integer>> getAllData() {
            return this.deviceCache;
        }

        public void removeDevice(String deviceId) {
            this.deviceCache.remove(deviceId);
        }

        public void clear() {
            this.deviceCache.clear();
        }

        public int size() {
            return this.deviceCache.size();
        }
    }
}

