/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.dlm;

import com.ovopark.device.modules.dlm.OnOffSnapshot;
import com.ovopark.device.modules.dlm.OnOffStorage;
import com.ovopark.kernel.shared.OnlyTest;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@ConditionalOnExpression(value="#{'ONE_INDEX'.equals(environment.getProperty('DEVICE_JOB_DLM_ONOFF_STORAGE'))}")
@Component
@OnlyTest
public class OnlyOneIndexOnOffStorage
implements OnOffStorage {
    private static final Logger log = LoggerFactory.getLogger(OnlyOneIndexOnOffStorage.class);
    @Autowired
    private ElasticsearchOperations elasticsearchOperations;

    public OnlyOneIndexOnOffStorage() {
        log.info("use ONE_INDEX storage");
    }

    @Override
    public OnOffSnapshot.OnOffESModel get(String id, String dayRouter) {
        return (OnOffSnapshot.OnOffESModel)this.elasticsearchOperations.get("device-onoffday-all", id, OnOffSnapshot.OnOffESModel.class);
    }

    @Override
    public void upsert(OnOffSnapshot.OnOffESModel onOffESModel, String dayRouter) {
        this.elasticsearchOperations.upsert("device-onoffday-all", (Document)onOffESModel);
    }
}

