/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdevice.report;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.common.util.DateUtils;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordServiceImpl;
import com.ovopark.device.modules.reportdevice.report.DeviceRecordExcel;
import com.ovopark.device.modules.reportdevice.report.HistoryReportVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceRecordCountVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceRecordVo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.signalling.contact.VersionConstant;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimpleNamePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/historyReport")
public class HistoryReport
implements JobOutTaskFlow<HistoryReportVo> {
    private static final Logger log = LoggerFactory.getLogger(HistoryReport.class);
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DeviceStatusRecordServiceImpl deviceStatusRecordService;
    @Autowired
    private DepartmentFacade departmentFacade;
    @Autowired
    private MessageSource messageSource;

    public HistoryReportVo requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        HistoryReportVo paramMo = (HistoryReportVo)JSONAccessor.impl().read(requestBody, HistoryReportVo.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setUserId(session.getUserId());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            paramMo.setEnterpriseId(sessionGroupId);
        }
        return paramMo;
    }

    public void execute(HistoryReportVo requestParamBody, OutStore outStore) {
        Integer userId = requestParamBody.getUserId();
        Integer enterpriseId = requestParamBody.getEnterpriseId();
        String organizeId = requestParamBody.getOrganizeId();
        String startTime = requestParamBody.getStartTime();
        String endTime = requestParamBody.getEndTime();
        Integer type = requestParamBody.getType();
        Integer lang = requestParamBody.getLang();
        Integer onlineFlag = requestParamBody.getOnlineFlag();
        Integer devType = requestParamBody.getDevType();
        ArrayList deviceTypeList = Util.isNotEmpty((CharSequence)requestParamBody.getDeviceTypeList()) ? Arrays.stream(requestParamBody.getDeviceTypeList().split(",")).filter(Util::isNotEmpty).toList() : new ArrayList();
        Integer openStatus = requestParamBody.getOpenStatus();
        Locale locale = requestParamBody.getLocale();
        ArrayList deptTagList = Util.isNotEmpty((CharSequence)requestParamBody.getDeptTagList()) ? Arrays.stream(requestParamBody.getDeptTagList().split(",")).filter(Util::isNotEmpty).map(Integer::valueOf).toList() : new ArrayList();
        ArrayList<Integer> openStatusList = new ArrayList<Integer>();
        if (openStatus != null) {
            openStatusList.add(openStatus);
        }
        ArrayList<String> orgidList = new ArrayList<String>();
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            orgidList.addAll(Arrays.asList(split));
        }
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setOpenStatue(openStatusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcFacade.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcFacade.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        List departmentList = this.rpcFacade.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> userDepNameMapNew = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setDepartmentIds(deptIdList);
        depAndTagsPojo.setGroupId(enterpriseId);
        Map tagByDepIdList = this.rpcFacade.getTagByDepIdList(depAndTagsPojo);
        HashMap<Integer, String> deptTagNameMap = new HashMap<Integer, String>();
        for (Map.Entry entry : tagByDepIdList.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String s = ((List)entry.getValue()).stream().map(SimpleNamePojo::getName).collect(Collectors.joining(","));
            deptTagNameMap.put(key, s);
        }
        List depIds = deptIdList;
        ArrayList<Integer> excludeDtypeList = new ArrayList<Integer>();
        excludeDtypeList.add(62);
        List userDeviceStatus = this.deviceStatusService.getUserDeviceStatus(userId, enterpriseId, depIds, null, excludeDtypeList);
        HashMap<Integer, DeviceStatus> userDeviceStatusMap = new HashMap<Integer, DeviceStatus>();
        HashMap<Integer, List> deptDeviceInfoIdsMap = new HashMap<Integer, List>();
        block7: for (DeviceStatus item : userDeviceStatus) {
            Integer dType = item.getDType();
            String deviceType = item.getDeviceType();
            if (CollectionUtils.isNotEmpty(deviceTypeList) && !deviceTypeList.contains(deviceType)) continue;
            if (devType != null) {
                switch (devType) {
                    case 1: {
                        if (VersionConstant.box.contains(dType)) break;
                        continue block7;
                    }
                    case 2: {
                        if (VersionConstant.ipc.contains(dType)) break;
                        continue block7;
                    }
                    case 3: {
                        if (VersionConstant.alg.contains(dType)) break;
                        continue block7;
                    }
                    case 4: {
                        if (22 == dType) break;
                        continue block7;
                    }
                }
            }
            Integer id = item.getId();
            Integer depId = item.getDepId();
            userDeviceStatusMap.put(id, item);
            List list = deptDeviceInfoIdsMap.computeIfAbsent(depId, k -> new ArrayList());
            list.add(item);
        }
        userDeviceStatus.clear();
        List days = DateUtils.getDays((String)startTime, (String)endTime);
        HashMap<Integer, List<DeviceRecordCountVo>> depRecordMap = new HashMap<Integer, List<DeviceRecordCountVo>>();
        for (Integer depId : depIds) {
            List deviceIdsByDepId = (List)deptDeviceInfoIdsMap.get(depId);
            if (!CollectionUtils.isNotEmpty((Collection)deviceIdsByDepId)) continue;
            List<DeviceRecordCountVo> depRecordList = this.deviceStatusRecordService.getDeviceStatusRecordNumByRecordTime(enterpriseId, startTime, endTime, deviceIdsByDepId.stream().map(DeviceStatus::getId).collect(Collectors.toList()));
            depRecordList.sort(Comparator.comparing(DeviceRecordCountVo::getRecordTime));
            depRecordMap.put(depId, depRecordList);
        }
        OutStore.SegmentWriter firstSegment = outStore.createSegment(this.messageSource.getMessage("DeviceReport.deviceRecord.sheet.device", null, locale));
        Segment.Header firstHeader = firstSegment.header();
        firstHeader.upset(null, "deptName", p -> 90, p -> this.messageSource.getMessage("DeviceReport.storeName", null, locale));
        for (Integer depId : depIds) {
            List list = depRecordMap.getOrDefault(depId, new ArrayList());
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            DepartmentPojo departmentTagSimpleVo = userDepNameMapNew.get(depId);
            String deptName = departmentTagSimpleVo.getName();
            rowMap.put("deptName", deptName);
            for (Object item : list) {
                String dateStr = DateUtils.parseTime((LocalDateTime)((DeviceRecordCountVo)item).getRecordTime(), (DateUtils.Format)DateUtils.Format.SHORT_DATE_FORMAT_LINE);
                firstHeader.upset(null, dateStr, null, p -> dateStr);
                firstHeader.upset(dateStr, "totalNum", null, p -> this.messageSource.getMessage("DeviceReport.device.all", null, locale));
                firstHeader.upset(dateStr, "onlineNum", null, p -> this.messageSource.getMessage("DeviceReport.device.online", null, locale));
                firstHeader.upset(dateStr, "offlineNum", null, p -> this.messageSource.getMessage("DeviceReport.device.offline", null, locale));
                HashMap<String, String> dMap = new HashMap<String, String>();
                dMap.put("totalNum", ((DeviceRecordCountVo)item).getTotal());
                dMap.put("onlineNum", ((DeviceRecordCountVo)item).getOnlineNum());
                dMap.put("offlineNum", ((DeviceRecordCountVo)item).getOfflineNum());
                rowMap.put(dateStr, dMap);
            }
            firstSegment.append(rowMap);
        }
        firstSegment.commit();
        LinkedHashMap<String, List<DeviceRecordVo>> dayRecordMap = new LinkedHashMap<String, List<DeviceRecordVo>>();
        if (CollectionUtils.isNotEmpty((Collection)days)) {
            for (String string : days) {
                LocalDate date = LocalDate.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                List<DeviceRecordVo> deviceRecordVos = this.deviceStatusRecordService.getDepDeviceStatusVoListFromDeviceStatusRecordV2(userId, date, depIds, enterpriseId, userDeviceStatusMap, userDepNameMapNew, onlineFlag, locale);
                List shopIdList = deviceRecordVos.stream().filter(deviceRecordVo -> deviceRecordVo.getMenDianId() != null).map(deviceRecordVo -> (int)deviceRecordVo.getMenDianId()).collect(Collectors.toList());
                List pojoList = this.departmentFacade.getDepPathById(enterpriseId, shopIdList);
                if (Util.isNotEmpty((Collection)pojoList)) {
                    block12: for (DeviceRecordVo deviceRecordVo2 : deviceRecordVos) {
                        for (SimplePojo simplePojo : pojoList) {
                            if (deviceRecordVo2.getMenDianId() == null || deviceRecordVo2.getMenDianId().compareTo(simplePojo.getId()) != 0) continue;
                            deviceRecordVo2.setOrgName(simplePojo.getName());
                            deviceRecordVo2.setTagNames((String)deptTagNameMap.get(deviceRecordVo2.getMenDianId()));
                            continue block12;
                        }
                    }
                }
                dayRecordMap.put(string, deviceRecordVos);
            }
        }
        for (Map.Entry entry : dayRecordMap.entrySet()) {
            String day = (String)entry.getKey();
            OutStore.SegmentWriter daySegment = outStore.createSegment(day);
            daySegment.header().all(DeviceRecordExcel.class, p -> this.messageSource.getMessage(p, null, locale));
            List recordVoList = (List)entry.getValue();
            for (DeviceRecordVo deviceRecordVo3 : recordVoList) {
                DeviceRecordExcel deviceRecordExcel = new DeviceRecordExcel();
                deviceRecordExcel.setDeptName(deviceRecordVo3.getDeptName());
                deviceRecordExcel.setShopId(deviceRecordVo3.getShopId());
                deviceRecordExcel.setTagNames(deviceRecordVo3.getTagNames());
                deviceRecordExcel.setOrgName(deviceRecordVo3.getOrgName());
                deviceRecordExcel.setDeviceName(deviceRecordVo3.getDeviceName());
                deviceRecordExcel.setMac(deviceRecordVo3.getMac());
                deviceRecordExcel.setDeviceType(deviceRecordVo3.getDeviceType());
                deviceRecordExcel.setDeviceTypeName(deviceRecordVo3.getDeviceTypeName());
                deviceRecordExcel.setOnlineStr(Util.compare2((Comparable)deviceRecordVo3.getOnline(), (Comparable)Integer.valueOf(1)) == 0 ? "\u5728\u7ebf" : "\u79bb\u7ebf");
                deviceRecordExcel.setRegisterTime(deviceRecordVo3.getRegisterTime());
                daySegment.append((Model)deviceRecordExcel);
            }
            daySegment.commit();
        }
        outStore.feature().supportBorder(true);
    }
}

