/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdevice.report;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordServiceImpl;
import com.ovopark.device.modules.reportdevice.report.DeviceOnlineRateExcel;
import com.ovopark.device.modules.reportdevice.report.DeviceStatusCurrentExcel;
import com.ovopark.device.modules.reportdevice.vo.DeviceOnlineRateVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceStatusReportVo;
import com.ovopark.device.modules.reportdevice.vo.ExportDeviceStatusCurrentMo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimpleNamePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/realReport")
public class RealReport
implements JobOutTaskFlow<ExportDeviceStatusCurrentMo> {
    private static final Logger log = LoggerFactory.getLogger(RealReport.class);
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DeviceStatusRecordServiceImpl deviceStatusRecordService;
    @Autowired
    private DepartmentFacade departmentFacade;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private OnlineFacade onlineFacadeRPC;

    public ExportDeviceStatusCurrentMo requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        ExportDeviceStatusCurrentMo paramMo = (ExportDeviceStatusCurrentMo)JSONAccessor.impl().read(requestBody, ExportDeviceStatusCurrentMo.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setUserId(session.getUserId());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            paramMo.setEnterpriseId(sessionGroupId);
        }
        return paramMo;
    }

    public void execute(ExportDeviceStatusCurrentMo requestParamBody, OutStore outStore) {
        Integer userId = requestParamBody.getUserId();
        Integer enterpriseId = requestParamBody.getEnterpriseId();
        String organizeId = requestParamBody.getOrganizeId();
        Integer type = requestParamBody.getType();
        List<String> deviceTypeList = requestParamBody.getDeviceTypeList();
        Locale locale = requestParamBody.getLocale();
        List<Integer> deptTagList = requestParamBody.getDeptTagList();
        int offlineSecond = requestParamBody.getOfflineSecond();
        Integer deviceOnline = requestParamBody.getDeviceOnline();
        String searchName = requestParamBody.getSearchName();
        Integer offLineTimeFilterType = requestParamBody.getOffLineTimeFilterType();
        Integer offLineTimeFilterSecond = requestParamBody.getOffLineTimeFilterSecond();
        Integer deptStatus = requestParamBody.getDeptStatus();
        Integer validateStatus = requestParamBody.getValidateStatus();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        ArrayList<Integer> validateStatusList = new ArrayList<Integer>();
        if (deptStatus != null) {
            statusList.add(deptStatus);
        }
        if (validateStatus != null) {
            validateStatusList.add(validateStatus);
        }
        Date now = new Date();
        long nowTime = now.getTime() / 1000L;
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setOpenStatue(statusList);
        depAndTagsPojo.setValidateStatus(validateStatusList);
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            typeIds.addAll(Arrays.asList(split));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcFacade.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        List deptIdList = this.rpcFacade.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        List departmentList = this.rpcFacade.departmentList(deptIdList);
        Map<Integer, DepartmentPojo> userDepNameMapNew = departmentList.stream().collect(Collectors.toMap(DepartmentPojo::getId, v -> v));
        HashMap<Integer, String> userDepNameMap = new HashMap<Integer, String>();
        for (Integer deptId : userDepNameMapNew.keySet()) {
            DepartmentPojo departmentOrgMo = userDepNameMapNew.get(deptId);
            if (departmentOrgMo == null) continue;
            userDepNameMap.put(deptId, departmentOrgMo.getName());
        }
        ArrayList depIds = new ArrayList(userDepNameMap.keySet());
        depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setDepartmentIds(depIds);
        depAndTagsPojo.setGroupId(enterpriseId);
        Map tagByDepIdList = this.rpcFacade.getTagByDepIdList(depAndTagsPojo);
        HashMap<Integer, String> deptTagNameMap = new HashMap<Integer, String>();
        for (Map.Entry entry : tagByDepIdList.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String s = ((List)entry.getValue()).stream().map(SimpleNamePojo::getName).collect(Collectors.joining(","));
            deptTagNameMap.put(key, s);
        }
        ArrayList<Integer> excludeDtypeList = new ArrayList<Integer>();
        excludeDtypeList.add(62);
        List userDeviceStatus = this.deviceStatusService.getUserDeviceStatus(userId, enterpriseId, depIds, null, excludeDtypeList);
        Map dmsStatusVoMap = this.onlineFacadeRPC.onOffTimeRT(userDeviceStatus.stream().map(DeviceStatus::getId).toList());
        HashMap<Integer, Integer> dmsStatus = new HashMap<Integer, Integer>();
        for (Integer id : dmsStatusVoMap.keySet()) {
            OnOffVo onlineVo = (OnOffVo)dmsStatusVoMap.get(id);
            if (onlineVo == null) {
                dmsStatus.put(id, 0);
                continue;
            }
            Integer online = onlineVo.getOnline();
            if (online == 0 && onlineVo.getOfflineTimeStamp() != 0L && nowTime - onlineVo.getOfflineTimeStamp() < (long)offlineSecond) {
                online = 1;
            }
            dmsStatus.put(id, online);
        }
        DeviceOnlineRateVo deviceOnlineRateVo = this.deviceStatusRecordService.getDeviceOnlineRate(userDeviceStatus, dmsStatus, type, deviceTypeList);
        List<DeviceStatusReportVo> deviceStatusReportVos = this.deviceStatusRecordService.getDeviceStatusCurrentList(userDepNameMap, type, deviceOnline, searchName, userDeviceStatus, dmsStatusVoMap, offlineSecond, offLineTimeFilterSecond, offLineTimeFilterType);
        List shopIdList = deviceStatusReportVos.stream().filter(deviceStatusReportVo -> deviceStatusReportVo.getMenDianId() != null).map(deviceStatusReportVo -> (int)deviceStatusReportVo.getMenDianId()).collect(Collectors.toList());
        List pojoList = this.departmentFacade.getDepPathById(enterpriseId, shopIdList);
        if (Util.isNotEmpty((Collection)pojoList)) {
            block10: for (DeviceStatusReportVo deviceStatusReportVo2 : deviceStatusReportVos) {
                for (SimplePojo simplePojo : pojoList) {
                    if (deviceStatusReportVo2.getMenDianId() == null || deviceStatusReportVo2.getMenDianId().compareTo(simplePojo.getId()) != 0) continue;
                    deviceStatusReportVo2.setOrgName(simplePojo.getName());
                    deviceStatusReportVo2.setTagNames((String)deptTagNameMap.get(deviceStatusReportVo2.getMenDianId()));
                    continue block10;
                }
            }
        }
        OutStore.SegmentWriter firstSegment = outStore.createSegment(this.messageSource.getMessage("DeviceReport.deviceCurrent.sheet.rate", null, locale));
        firstSegment.header().all(DeviceOnlineRateExcel.class, p -> this.messageSource.getMessage(p, null, locale));
        if (deviceOnlineRateVo != null) {
            DeviceOnlineRateExcel deviceOnlineRateExcel = new DeviceOnlineRateExcel();
            int total = 0;
            int onlineNum = 0;
            switch (type) {
                case 0: {
                    total = deviceOnlineRateVo.getDeviceTotal();
                    onlineNum = deviceOnlineRateVo.getDeviceOnlineNum();
                    break;
                }
                case 1: {
                    total = deviceOnlineRateVo.getNvrTotal();
                    onlineNum = deviceOnlineRateVo.getNvrOnlineNum();
                    break;
                }
                case 2: {
                    total = deviceOnlineRateVo.getIpcTotal();
                    onlineNum = deviceOnlineRateVo.getIpcOnlineNum();
                    break;
                }
                case 3: {
                    total = deviceOnlineRateVo.getPcTotal();
                    onlineNum = deviceOnlineRateVo.getPcOnlineNum();
                    break;
                }
                case 4: {
                    total = deviceOnlineRateVo.getGatewayIpcTotal();
                    onlineNum = deviceOnlineRateVo.getGatewayIpcOnlineNum();
                }
            }
            deviceOnlineRateExcel.setDeviceTotal(Integer.toString(total));
            deviceOnlineRateExcel.setOnlineNum(Integer.toString(onlineNum));
            BigDecimal usedM = total == 0 ? new BigDecimal(0) : new BigDecimal((float)onlineNum / (float)total);
            DecimalFormat df = new DecimalFormat("0.00%");
            BigDecimal d = new BigDecimal(String.valueOf(usedM.setScale(4, 4)));
            String percent = df.format(d);
            deviceOnlineRateExcel.setOnlineRate(percent);
            firstSegment.append((Model)deviceOnlineRateExcel);
        }
        firstSegment.commit();
        OutStore.SegmentWriter secondSegment = outStore.createSegment(this.messageSource.getMessage("DeviceReport.deviceCurrent.sheet.online", null, locale));
        secondSegment.header().all(DeviceStatusCurrentExcel.class, p -> this.messageSource.getMessage(p, null, locale));
        String online = this.messageSource.getMessage("DeviceReport.device.online", null, locale);
        String offline = this.messageSource.getMessage("DeviceReport.device.offline", null, locale);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long searchTimeL = now.getTime() / 1000L;
        String searchTimeStr = sdf.format(now);
        if (CollectionUtils.isNotEmpty(deviceStatusReportVos)) {
            for (DeviceStatusReportVo deviceStatusReportVo3 : deviceStatusReportVos) {
                DeviceStatusCurrentExcel deviceStatusCurrentExcel = new DeviceStatusCurrentExcel();
                deviceStatusCurrentExcel.setDeviceName(deviceStatusReportVo3.getDeviceName());
                deviceStatusCurrentExcel.setMac(deviceStatusReportVo3.getMac());
                deviceStatusCurrentExcel.setOnline(deviceStatusReportVo3.getOnline() == 1 ? online : offline);
                deviceStatusCurrentExcel.setDeviceType(deviceStatusReportVo3.getdType());
                deviceStatusCurrentExcel.setDeviceTypeName(deviceStatusReportVo3.getDeviceType());
                deviceStatusCurrentExcel.setCreateTime(deviceStatusReportVo3.getCreateTime());
                deviceStatusCurrentExcel.setOrgName(deviceStatusReportVo3.getOrgName());
                deviceStatusCurrentExcel.setDepName(deviceStatusReportVo3.getDepName());
                deviceStatusCurrentExcel.setTagNames(deviceStatusReportVo3.getTagNames());
                deviceStatusCurrentExcel.setShopId(deviceStatusReportVo3.getShopId());
                deviceStatusCurrentExcel.setSearchTime(searchTimeStr);
                long offlineTimeStamp = deviceStatusReportVo3.getOfflineTimeStamp();
                if (offlineTimeStamp == 0L) {
                    deviceStatusCurrentExcel.setOfflineTime("-");
                    deviceStatusCurrentExcel.setOfflineTimes("-");
                } else {
                    deviceStatusCurrentExcel.setOfflineTime(sdf.format(new Date(offlineTimeStamp * 1000L)));
                    deviceStatusCurrentExcel.setOfflineTimes(RealReport.secToTime(searchTimeL - offlineTimeStamp));
                }
                deviceStatusCurrentExcel.setDepOpenStatus(this.setDepOpenStatus(deviceStatusReportVo3.getDepOpenStatus(), locale));
                deviceStatusCurrentExcel.setDepValidateStatus(this.setDepValidateStatus(deviceStatusReportVo3.getValidateStatus(), locale));
                String depTel = deviceStatusReportVo3.getDepTel();
                deviceStatusCurrentExcel.setDepTel(Util.isNotEmpty((CharSequence)depTel) ? depTel : "-");
                secondSegment.append((Model)deviceStatusCurrentExcel);
            }
        }
        secondSegment.commit();
        String excelName = this.messageSource.getMessage("DeviceReport.deviceCurrent.excel", null, locale);
        outStore.fileName(excelName);
    }

    public static String secToTime(Long seconds) {
        long hour = seconds / 3600L;
        long minute = (seconds - hour * 3600L) / 60L;
        long second = seconds - hour * 3600L - minute * 60L;
        StringBuilder sb = new StringBuilder();
        if (hour > 9L) {
            sb.append(hour).append(":");
        } else if (hour > 0L) {
            sb.append("0").append(hour).append(":");
        } else {
            sb.append("00:");
        }
        if (minute > 9L) {
            sb.append(minute).append(":");
        } else if (minute > 0L) {
            sb.append("0").append(minute).append(":");
        } else {
            sb.append("00:");
        }
        if (second > 9L) {
            sb.append(second);
        } else if (second > 0L) {
            sb.append("0").append(second);
        } else {
            sb.append("00");
        }
        return sb.toString();
    }

    private String setDepOpenStatus(Integer openStatus, Locale locale) {
        String status = "";
        switch (openStatus) {
            case 0: {
                status = this.messageSource.getMessage("department.export.status.preparing", null, locale);
                break;
            }
            case 1: {
                status = this.messageSource.getMessage("department.export.status.open", null, locale);
                break;
            }
            case 2: {
                status = this.messageSource.getMessage("department.export.status.closed", null, locale);
                break;
            }
            case 3: {
                status = this.messageSource.getMessage("department.export.status.temporarily-closed", null, locale);
                break;
            }
        }
        return status;
    }

    private String setDepValidateStatus(Integer validateStatus, Locale locale) {
        String status = "";
        switch (validateStatus) {
            case 0: {
                status = this.messageSource.getMessage("department.export.validateStatus.not-expired", null, locale);
                break;
            }
            case 1: {
                status = this.messageSource.getMessage("department.export.validateStatus.expired", null, locale);
                break;
            }
            case 2: {
                status = this.messageSource.getMessage("department.export.validateStatus.about-to-expire", null, locale);
                break;
            }
        }
        return status;
    }
}

