/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdisk.report;

import com.ovopark.device.modules.reportdisk.DiskInfoService;
import com.ovopark.device.modules.reportdisk.DiskTimeStatus;
import com.ovopark.device.modules.reportdisk.report.DiskInfoReportParam;
import com.ovopark.device.modules.reportdisk.report.NVRDiskInfoExcel;
import com.ovopark.device.modules.reportdisk.report.SimpleDiskInfoExcel;
import com.ovopark.device.modules.reportdisk.report.ThirdDiskInfoExcel;
import com.ovopark.device.modules.reportdisk.vo.DiskStatusNewV2Vo;
import com.ovopark.device.modules.reportdisk.vo.DisksListBeanVo;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/exportDistRecordNew")
public class DiskInfoReport
implements JobOutTaskFlow<DiskInfoReportParam> {
    private static final Logger log = LoggerFactory.getLogger(DiskInfoReport.class);
    @Autowired
    private DiskInfoService diskInfoService;
    @Autowired
    private MessageSource messageSource;

    public DiskInfoReportParam requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        DiskInfoReportParam paramMo = (DiskInfoReportParam)JSONAccessor.impl().read(requestBody, DiskInfoReportParam.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setUserId(session.getUserId());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            paramMo.setGroupId(sessionGroupId);
        }
        return paramMo;
    }

    public void execute(DiskInfoReportParam requestParamBody, OutStore outStore) {
        String organizationId = requestParamBody.getOrganizationId();
        Integer groupId = requestParamBody.getGroupId();
        Integer type = requestParamBody.getType();
        Integer userId = requestParamBody.getUserId();
        String startTime = requestParamBody.getStartTime();
        String endTime = requestParamBody.getEndTime();
        Integer diskNum = requestParamBody.getDiskNum();
        Integer status = requestParamBody.getStatus();
        Locale locale = requestParamBody.getLocale() == null ? Locale.CHINA : requestParamBody.getLocale();
        PageModel<DiskStatusNewV2Vo> pageModel = this.diskInfoService.diskInfo(groupId, organizationId, type, startTime, endTime, diskNum, 1, 1000000, userId, status);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startDateTime = LocalDateTime.parse(startTime, formatter);
        LocalDateTime endDateTime = LocalDateTime.parse(endTime, formatter);
        if (endDateTime.toLocalDate().isEqual(LocalDate.now())) {
            endDateTime = endDateTime.minusDays(1L);
        }
        LocalDate startTimeLocalDate = startDateTime.toLocalDate();
        LocalDate endTimeLocalDate = endDateTime.toLocalDate();
        long days = ChronoUnit.DAYS.between(startTimeLocalDate, endTimeLocalDate) + 1L;
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        int i = 0;
        while ((long)i < days) {
            dateList.add(startTimeLocalDate.plusDays(i));
            ++i;
        }
        List data = pageModel.getData();
        if (type == 1) {
            OutStore.SegmentWriter firstSegment = outStore.createSegment("sheet1");
            firstSegment.header().all(NVRDiskInfoExcel.class, path -> this.messageSource.getMessage(path, null, locale));
            int maxDiskNum = 0;
            for (DiskStatusNewV2Vo diskStatusNewV2Vo : data) {
                maxDiskNum = Math.max(maxDiskNum, diskStatusNewV2Vo.getDiskTimeStatusList() == null ? 0 : diskStatusNewV2Vo.getDiskTimeStatusList().size());
                NVRDiskInfoExcel nvrDiskInfoExcel = new NVRDiskInfoExcel();
                nvrDiskInfoExcel.setDeptName(diskStatusNewV2Vo.getDepName());
                nvrDiskInfoExcel.setDeviceName(diskStatusNewV2Vo.getDeviceStatusName());
                nvrDiskInfoExcel.setMac(diskStatusNewV2Vo.getMac());
                nvrDiskInfoExcel.setTotalDisksNum(diskStatusNewV2Vo.getTotalDisksNum());
                nvrDiskInfoExcel.setUseDisksNum(diskStatusNewV2Vo.getUseDisksNum());
                nvrDiskInfoExcel.setFreeDisksNum(diskStatusNewV2Vo.getFreeDisksNum());
                nvrDiskInfoExcel.setTotalSpace((String)Util.convert2Self((Object)Util.ByteSizeUnit.numPartOf((String)diskStatusNewV2Vo.getTotalSpaceFormat()), (Object)"-"));
                nvrDiskInfoExcel.setUseSpace((String)Util.convert2Self((Object)Util.ByteSizeUnit.numPartOf((String)diskStatusNewV2Vo.getUseSpaceFormat()), (Object)"-"));
                if (Util.isNotEmpty(diskStatusNewV2Vo.getDisksList())) {
                    ArrayList<NVRDiskInfoExcel.DiskNumPart> diskNumPartList = new ArrayList<NVRDiskInfoExcel.DiskNumPart>();
                    for (DisksListBeanVo disksListBeanVo : diskStatusNewV2Vo.getDisksList()) {
                        NVRDiskInfoExcel.DiskNumPart diskNumPart = new NVRDiskInfoExcel.DiskNumPart();
                        diskNumPart.setIndexNum(Util.convert2String((Object)disksListBeanVo.getIndexNum()));
                        diskNumPart.setTotalSpace(Util.ByteSizeUnit.numPartOf((String)disksListBeanVo.getTotalSpaceFormat()));
                        diskNumPart.setUseSpace(Util.ByteSizeUnit.numPartOf((String)disksListBeanVo.getUseSpaceFormat()));
                        diskNumPart.setFreeSpace(Util.ByteSizeUnit.numPartOf((String)disksListBeanVo.getFreeSpaceFormat()));
                        diskNumPartList.add(diskNumPart);
                    }
                    nvrDiskInfoExcel.setDiskNumPartList(diskNumPartList);
                }
                firstSegment.feature().supportRangeMerge(true);
                firstSegment.append((Model)nvrDiskInfoExcel);
            }
            firstSegment.commit();
            for (LocalDate localDate : dateList) {
                OutStore.SegmentWriter daySegment = outStore.createSegment(localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                daySegment.header().upset(null, "depName", null, path -> this.messageSource.getMessage("NVRDiskInfoExcel.deptName", null, locale));
                daySegment.header().upset(null, "deviceName", null, path -> this.messageSource.getMessage("NVRDiskInfoExcel.deviceName", null, locale));
                daySegment.header().upset(null, "mac", null, path -> this.messageSource.getMessage("NVRDiskInfoExcel.mac", null, locale));
                for (int i2 = 1; i2 <= maxDiskNum; ++i2) {
                    int finalI = i2;
                    daySegment.header().upset(null, "disk" + i2, null, path -> this.messageSource.getMessage("NVRDiskInfoExcel.disk", null, locale) + finalI);
                }
                for (DiskStatusNewV2Vo diskStatusNewV2Vo : data) {
                    HashMap<Object, String> map = new HashMap<Object, String>();
                    map.put("depName", diskStatusNewV2Vo.getDepName());
                    map.put("deviceName", diskStatusNewV2Vo.getDeviceStatusName());
                    map.put("mac", diskStatusNewV2Vo.getMac());
                    Map<Integer, List<DiskTimeStatus>> diskTimeStatusList = diskStatusNewV2Vo.getDiskTimeStatusList();
                    if (Util.isNotEmpty(diskTimeStatusList)) {
                        block6: for (Map.Entry<Integer, List<DiskTimeStatus>> entry : diskTimeStatusList.entrySet()) {
                            List<DiskTimeStatus> value = entry.getValue();
                            for (DiskTimeStatus diskTimeStatus : value) {
                                if (!localDate.isEqual(diskTimeStatus.getTime())) continue;
                                map.put("disk" + diskTimeStatus.getDiskNum(), this.diskStatusName(diskTimeStatus.getStatus(), type));
                                continue block6;
                            }
                        }
                    }
                    for (int i3 = 1; i3 <= maxDiskNum; ++i3) {
                        if (map.containsKey("disk" + i3)) continue;
                        map.put("disk" + i3, "-");
                    }
                    daySegment.append(map);
                }
                daySegment.commit();
            }
            outStore.feature().supportRangeMerge(true);
        } else if (type == 2) {
            for (LocalDate localDate : dateList) {
                OutStore.SegmentWriter daySegment = outStore.createSegment(localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                daySegment.header().all(SimpleDiskInfoExcel.class, path -> this.messageSource.getMessage(path, null, locale));
                for (DiskStatusNewV2Vo diskStatusNewV2Vo : data) {
                    SimpleDiskInfoExcel simpleDiskInfoExcel = new SimpleDiskInfoExcel();
                    simpleDiskInfoExcel.setDeptName(diskStatusNewV2Vo.getDepName());
                    simpleDiskInfoExcel.setDeviceName(diskStatusNewV2Vo.getDeviceStatusName());
                    simpleDiskInfoExcel.setMac(diskStatusNewV2Vo.getMac());
                    simpleDiskInfoExcel.setTotalSpace(Util.ByteSizeUnit.numPartOf((String)diskStatusNewV2Vo.getTotalSpaceFormat()));
                    simpleDiskInfoExcel.setUseSpace(Util.ByteSizeUnit.numPartOf((String)diskStatusNewV2Vo.getUseSpaceFormat()));
                    Map<Integer, List<DiskTimeStatus>> diskTimeStatusList = diskStatusNewV2Vo.getDiskTimeStatusList();
                    if (Util.isNotEmpty(diskTimeStatusList)) {
                        block11: for (Map.Entry<Integer, List<DiskTimeStatus>> entry : diskTimeStatusList.entrySet()) {
                            List<DiskTimeStatus> value = entry.getValue();
                            for (DiskTimeStatus diskTimeStatus : value) {
                                if (!localDate.isEqual(diskTimeStatus.getTime())) continue;
                                simpleDiskInfoExcel.setSdStatus(this.diskStatusName(diskTimeStatus.getStatus(), type));
                                break block11;
                            }
                        }
                    }
                    daySegment.append((Model)simpleDiskInfoExcel);
                }
                daySegment.commit();
            }
            outStore.fileName("\u7f51\u5173\u8bbe\u5907\u5b58\u50a8\u62a5\u8868");
            outStore.feature().supportBorder(true);
        } else if (type == 3) {
            for (LocalDate localDate : dateList) {
                OutStore.SegmentWriter daySegment = outStore.createSegment(localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                daySegment.header().all(ThirdDiskInfoExcel.class, path -> this.messageSource.getMessage(path, null, locale));
                for (DiskStatusNewV2Vo diskStatusNewV2Vo : data) {
                    ThirdDiskInfoExcel thirdDiskInfoExcel = new ThirdDiskInfoExcel();
                    thirdDiskInfoExcel.setDeptName(diskStatusNewV2Vo.getDepName());
                    thirdDiskInfoExcel.setDeviceName(diskStatusNewV2Vo.getDeviceStatusName());
                    thirdDiskInfoExcel.setMac(diskStatusNewV2Vo.getMac());
                    thirdDiskInfoExcel.setTotalSpace(Util.ByteSizeUnit.numPartOf((String)diskStatusNewV2Vo.getTotalSpaceFormat()));
                    thirdDiskInfoExcel.setUseSpace(Util.ByteSizeUnit.numPartOf((String)diskStatusNewV2Vo.getUseSpaceFormat()));
                    if (Objects.equals(diskStatusNewV2Vo.getDeviceType(), 4)) {
                        thirdDiskInfoExcel.setDeviceSource("\u8424\u77f3");
                    } else {
                        thirdDiskInfoExcel.setDeviceSource("\u4e50\u6a59");
                    }
                    Map<Integer, List<DiskTimeStatus>> diskTimeStatusList = diskStatusNewV2Vo.getDiskTimeStatusList();
                    if (Util.isNotEmpty(diskTimeStatusList)) {
                        block15: for (Map.Entry<Integer, List<DiskTimeStatus>> entry : diskTimeStatusList.entrySet()) {
                            List<DiskTimeStatus> value = entry.getValue();
                            for (DiskTimeStatus diskTimeStatus : value) {
                                if (!localDate.isEqual(diskTimeStatus.getTime())) continue;
                                thirdDiskInfoExcel.setSdStatus(this.diskStatusName(diskTimeStatus.getStatus(), type));
                                break block15;
                            }
                        }
                    }
                    daySegment.append((Model)thirdDiskInfoExcel);
                }
                daySegment.commit();
            }
            outStore.fileName("\u4e09\u65b9\u8bbe\u5907\u5b58\u50a8\u62a5\u8868");
            outStore.feature().supportBorder(true);
        }
    }

    private String diskStatusName(Integer status, int type) {
        if (status == null) {
            return null;
        }
        if (type == 1) {
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(-1)) == 0) {
                return "\u672a\u67e5\u8be2\u5230";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0) {
                return "\u6b63\u5e38";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(1)) == 0 || Util.compare2((Comparable)status, (Comparable)Integer.valueOf(2)) == 0) {
                return "\u5f02\u5e38";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(3)) == 0) {
                return "\u672a\u521d\u59cb\u5316";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(4)) == 0) {
                return "\u672a\u5b89\u88c5";
            }
        } else if (type == 2 || type == 3) {
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(-1)) == 0) {
                return "\u672a\u67e5\u8be2\u5230";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0) {
                return "\u672a\u5b89\u88c5";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(1)) == 0) {
                return "\u5f02\u5e38";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(2)) == 0 || Util.compare2((Comparable)status, (Comparable)Integer.valueOf(3)) == 0) {
                return "\u6b63\u5e38";
            }
            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(4)) == 0) {
                return "\u672a\u683c\u5f0f\u5316";
            }
        }
        return null;
    }
}

