/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportgb.report;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.GbCascadePlatforms;
import com.ovopark.device.modules.platform.mysql.GbCascadePlatformsMapper;
import com.ovopark.device.modules.reportgb.CascadeDownDeviceDto;
import com.ovopark.device.modules.reportgb.CascadeDownDeviceVo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.thirdparty.ovoIot.model.mms.CascadeDownChannelsRsp;
import com.ovopark.device.thirdparty.ovoIot.service.DmsProxyFeign;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/cascadeDownChannelReport")
public class CascadeDownChannelsReport
implements JobOutTaskFlow<CascadeDownDeviceDto> {
    private static final Logger log = LoggerFactory.getLogger(CascadeDownChannelsReport.class);
    @Autowired
    private GbCascadePlatformsMapper gbCascadePlatformsMapper;
    @Resource
    private DmsProxyFeign dmsProxyFeign;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DepartmentFacade deviceReportService;
    String CODE_SUCCESS = "comm_success";
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Resource
    private UserDepPrivilegeApi userDepPrivilegeApi;

    public CascadeDownDeviceDto requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        CascadeDownDeviceDto videoRecordReqDto = (CascadeDownDeviceDto)JSONAccessor.impl().read(requestBody, CascadeDownDeviceDto.class);
        Map map = JSONAccessor.impl().read(requestBody);
        videoRecordReqDto.setUserGroupId(Optional.ofNullable(session.getGroupId()).orElse(Util.convert2Int((String)Util.convert2String(map.get("groupId")), null)));
        videoRecordReqDto.setUserId(session.getUserId());
        videoRecordReqDto.setLocale(session.clientInfo().getLocale());
        return videoRecordReqDto;
    }

    public void execute(CascadeDownDeviceDto requestParamBody, OutStore outStore) {
        CascadeDownChannelsRsp cascadeDownChannelsRsp;
        String errno;
        Integer userId = requestParamBody.getUserId();
        Integer userGroupId = requestParamBody.getUserGroupId();
        Integer id = requestParamBody.getId();
        String districtName = requestParamBody.getDistrictName();
        String districtCode = requestParamBody.getDistrictCode();
        String channelId = requestParamBody.getChannelId();
        String channelName = requestParamBody.getChannelName();
        boolean curpage = true;
        int pagesize = 100000;
        Integer bindFlag = requestParamBody.getBindFlag();
        String orgId = requestParamBody.getOrgId();
        GbCascadePlatforms gbCascadePlatforms = (GbCascadePlatforms)this.gbCascadePlatformsMapper.selectById((Serializable)id);
        if (gbCascadePlatforms == null || gbCascadePlatforms.getDelFlag() == 1) {
            return;
        }
        if (Util.isNotEmpty((CharSequence)orgId)) {
            bindFlag = 1;
        }
        if (!this.CODE_SUCCESS.equals(errno = (cascadeDownChannelsRsp = this.dmsProxyFeign.cascadeDownChannels(gbCascadePlatforms.getCode(), gbCascadePlatforms.getCode(), districtName, districtCode, channelId, channelName, Integer.valueOf(bindFlag == null ? 1 : 1), Integer.valueOf(bindFlag == null ? 100000 : 100000), userGroupId != null ? userGroupId.toString() : null)).getErrno())) {
            return;
        }
        CascadeDownChannelsRsp.DataBean data = cascadeDownChannelsRsp.getData();
        Integer sum = data.getSum();
        if (Util.compare2((Comparable)sum, (Comparable)Integer.valueOf(0)) == 0) {
            return;
        }
        List channels = data.getChannels();
        if (Util.isEmpty((Collection)channels)) {
            return;
        }
        Integer groupId = gbCascadePlatforms.getGroupId();
        List<DeviceStatus> deviceStatusList = this.getDeviceStatusList(groupId, id, 56, 0);
        Map userDepNameMap = this.deviceReportService.getUserDepNameMap(userId, groupId, orgId);
        if (bindFlag != null && bindFlag == 1 && CollectionUtils.isEmpty(deviceStatusList)) {
            return;
        }
        HashMap<String, Integer> codeAndDepIdMap = new HashMap<String, Integer>();
        HashMap<String, DeviceStatus> codeAndDeviceStatusIdMap = new HashMap<String, DeviceStatus>();
        for (DeviceStatus deviceStatus : deviceStatusList) {
            codeAndDepIdMap.put(deviceStatus.getDeviceCode(), deviceStatus.getDepId());
            codeAndDeviceStatusIdMap.put(deviceStatus.getDeviceCode(), deviceStatus);
        }
        ArrayList<CascadeDownDeviceVo> resultList = new ArrayList<CascadeDownDeviceVo>();
        if (bindFlag == null) {
            for (CascadeDownChannelsRsp.DataBean.ChannelsBean item : channels) {
                deviceid = item.getDeviceid();
                vo = new CascadeDownDeviceVo();
                vo.setCode(deviceid);
                vo.setName(item.getName());
                vo.setManufacturer(item.getManufacturer());
                vo.setModel(item.getModel());
                vo.setCivilcode(item.getCivilcode());
                vo.setAddress(item.getAddress());
                vo.setOnlineFlag(Util.compare2((Comparable)((Object)"ON"), (Comparable)((Object)item.getStatus())) == 0 ? 1 : 0);
                depId = (Integer)codeAndDepIdMap.get(deviceid);
                if (depId != null) {
                    vo.setDeptId(depId);
                    vo.setDeptName((String)userDepNameMap.get(depId));
                }
                if ((deviceStatus = (DeviceStatus)codeAndDeviceStatusIdMap.get(item.getDeviceid())) != null) {
                    vo.setRealPlayType(deviceStatus.getRealPlayType());
                    vo.setDeviceStatusId(deviceStatus.getId());
                }
                resultList.add(vo);
            }
        } else {
            for (CascadeDownChannelsRsp.DataBean.ChannelsBean item : channels) {
                deviceid = item.getDeviceid();
                vo = new CascadeDownDeviceVo();
                vo.setCode(deviceid);
                vo.setName(item.getName());
                vo.setManufacturer(item.getManufacturer());
                vo.setModel(item.getModel());
                vo.setCivilcode(item.getCivilcode());
                vo.setAddress(item.getAddress());
                vo.setOnlineFlag(Util.compare2((Comparable)((Object)"ON"), (Comparable)((Object)item.getStatus())) == 0 ? 1 : 0);
                depId = (Integer)codeAndDepIdMap.get(deviceid);
                if (depId != null) {
                    vo.setDeptId(depId);
                    vo.setDeptName((String)userDepNameMap.get(depId));
                }
                if ((deviceStatus = (DeviceStatus)codeAndDeviceStatusIdMap.get(item.getDeviceid())) != null) {
                    vo.setRealPlayType(deviceStatus.getRealPlayType());
                    vo.setDeviceStatusId(deviceStatus.getId());
                }
                if (bindFlag == 1) {
                    if (depId == null || !Util.isNotEmpty((CharSequence)((CharSequence)userDepNameMap.get(depId)))) continue;
                    resultList.add(vo);
                    continue;
                }
                if (depId != null) continue;
                resultList.add(vo);
            }
        }
        OutStore.SegmentWriter segmentWriter = outStore.createSegment("sheet1");
        Segment.Header header = segmentWriter.header();
        header.all(CascadeDownDeviceVo.class, path -> {
            log.info("possible i18 key: " + path);
            String message = this.messageSource.getMessage(path, null, requestParamBody.getLocale() == null ? Locale.CHINA : requestParamBody.getLocale());
            if (path.equalsIgnoreCase(message)) {
                return path.substring(Math.max(0, path.lastIndexOf(".") + 1));
            }
            return message;
        });
        segmentWriter.title().title(this.messageSource.getMessage("CascadeDownChannelsReport.excelTitle", null, requestParamBody.getLocale() == null ? Locale.CHINA : requestParamBody.getLocale()) + ": " + gbCascadePlatforms.getName());
        Iterator iterator = resultList.iterator();
        while (iterator.hasNext()) {
            CascadeDownDeviceVo cascadeDownDeviceVo;
            cascadeDownDeviceVo.setOnlineFlagDesc(Util.compare2((Comparable)(cascadeDownDeviceVo = (CascadeDownDeviceVo)iterator.next()).getOnlineFlag(), (Comparable)Integer.valueOf(1)) == 0 ? "\u5728\u7ebf" : "\u79bb\u7ebf");
            cascadeDownDeviceVo.setRealPlayTypeDesc(Util.compare2((Comparable)cascadeDownDeviceVo.getRealPlayType(), (Comparable)Integer.valueOf(1)) == 0 ? "TCP\u64ad\u653e" : "UDP\u64ad\u653e");
            segmentWriter.append((Model)cascadeDownDeviceVo);
        }
        segmentWriter.commit();
        outStore.fileName(this.messageSource.getMessage("CascadeDownChannelsReport.fileName", null, requestParamBody.getLocale() == null ? Locale.CHINA : requestParamBody.getLocale()) + ".xlsx");
    }

    public List<DeviceStatus> getDeviceStatusList(Integer groupId, Integer pId, Integer dType, Integer delFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (groupId != null) {
            queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId);
        }
        if (pId != null) {
            queryWrapper.eq(DeviceStatus::getPId, (Object)pId);
        }
        if (dType != null) {
            queryWrapper.eq(DeviceStatus::getDType, (Object)dType);
        }
        if (delFlag != null) {
            queryWrapper.eq(DeviceStatus::getIsDelete, (Object)delFlag);
        }
        return this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
    }
}

