/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportvideo;

import com.ovopark.device.modules.platform.ConditionOnKafka;
import com.ovopark.device.modules.reportvideo.VideoRecordService;
import com.ovopark.device.modules.reportvideo.kafka.VideoRecordDto;
import com.ovopark.device.platform.api.kafka.DeviceInOutRecord;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import jakarta.annotation.Resource;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class KafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(KafkaInStream.class);
    @Resource
    private ElasticsearchOperations elasticsearchOperations;
    @Autowired
    private VideoRecordService videoRecordService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="topic-device-inAndOut", groupId="${device.videoReport.kafka.group:deviceVideoReport}", containerFactory="deviceKafkaMainContainerFactory", id="device-video-report")
    public void deviceInOut(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        DeviceInOutRecord deviceInOutRecord = (DeviceInOutRecord)JSONAccessor.impl().read((String)value, DeviceInOutRecord.class);
        MDC.put((String)"traceId", (String)deviceInOutRecord.getMac());
        MDC.put((String)"requestId", (String)("device-" + deviceInOutRecord.getDeviceStatusId()));
        log.info(deviceInOutRecord.getMac() + " from SDK KAFKA: " + String.valueOf(value));
        try {
            final String mac = deviceInOutRecord.getMac();
            ElasticsearchOperations.BulkDeleteResponse bulkDeleteResponse = this.elasticsearchOperations.deleteDocInMultiIndex((Supplier)new Supplier<BoolQueryBuilder>(){

                @Override
                public BoolQueryBuilder get() {
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"nvrMac", (String)mac));
                    return boolQueryBuilder;
                }
            }, new String[]{"device-video-record"});
            log.info("delete all docs of nvr(" + mac + ") , result: " + JSONAccessor.impl().format((Object)bulkDeleteResponse));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }

    @KafkaListener(concurrency="${myConfig.device.msg.videoRecordConsumerConcurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="device-video-record-.*", containerFactory="dmsKafkaContainerFactory")
    public void process(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info("{},topic: {}, partition: {}, offset: {}", new Object[]{Thread.currentThread().hashCode(), topic, partition, offset});
        Object value = record.value();
        VideoRecordDto recordDto = (VideoRecordDto)JSONAccessor.impl().read((String)value, VideoRecordDto.class);
        log.info("VideoRecordKafkaConsumer.recordDto:{}", (Object)recordDto);
        this.videoRecordService.sync(recordDto);
    }
}

