/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportvideo;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.cloud.common.model.mo.GetDeviceStoragesFeignMo;
import com.ovopark.device.cloud.common.model.mo.GetNvrChildInfoItemMo;
import com.ovopark.device.cloud.common.model.vo.GetDeviceStoragesFeignVo;
import com.ovopark.device.cloud.common.model.vo.GetNvrChildInfoItemFeignVo;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.device.modules.platform.config.DmsConfig;
import com.ovopark.device.modules.platform.config.ElasticSearchConfig;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.util.HttpUtils;
import com.ovopark.device.modules.reportvideo.DeviceService;
import com.ovopark.device.modules.reportvideo.VideoRecordService;
import com.ovopark.device.modules.reportvideo.dto.VideoRecordDto;
import com.ovopark.device.modules.reportvideo.dto.VideoRecordReqDto;
import com.ovopark.device.modules.reportvideo.dto.VideoRecordSubDto;
import com.ovopark.device.modules.reportvideo.es.VideoRecord;
import com.ovopark.device.modules.reportvideo.es.VideoRecordSub;
import com.ovopark.device.modules.reportvideo.mysql.VideoRecordRunnerTime;
import com.ovopark.device.modules.reportvideo.mysql.VideoRecordRunnerTimeMapper;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import jakarta.annotation.Resource;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service(value="videoRecordService")
public class VideoRecordServiceImpl
implements VideoRecordService {
    private static final Logger log = LoggerFactory.getLogger(VideoRecordServiceImpl.class);
    @Resource
    private DepartmentFacade departmentFacade;
    @Resource
    private DeviceService deviceService;
    @Resource
    private ElasticsearchOperations elasticsearchOperations;
    @Resource
    private ElasticSearchConfig elasticSearchConfig;
    @Resource
    private MessageSource messageSource;
    @Resource
    private DmsConfig dmsConfig;
    @Resource
    private VideoRecordRunnerTimeMapper videoRecordRunnerTimeMapper;
    @Resource
    private DeviceStatusApi deviceStatusApi;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;

    @Override
    public PageModel<VideoRecordDto> getVideoRecordList(VideoRecordReqDto dto, Session session) {
        List<Integer> depIdList = this.getDeptIds(dto, session.getGroupId(), session.getUserId());
        if (Util.isEmpty(depIdList)) {
            log.info("cannot find any department");
            return new PageModel();
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{"device-video-record"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        ArrayList<String> nvrList = new ArrayList();
        ArrayList<String> ipcList = new ArrayList();
        if (Util.compare2((Comparable)dto.getDeviceType(), (Comparable)Integer.valueOf(1)) == 0) {
            deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).in(DeviceStatus::getDepId, depIdList)).isNotNull(DeviceStatus::getPId)).eq(DeviceStatus::getIsDelete, (Object)0)).select(new SFunction[]{DeviceStatus::getMac}));
            if (Util.isEmpty((Collection)deviceStatusList)) {
                log.info("cannot find any device");
                return new PageModel();
            }
            ipcList = deviceStatusList.stream().filter(Objects::nonNull).map(DeviceStatus::getMac).filter(Util::isNotEmpty).toList();
        } else {
            deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).in(DeviceStatus::getDepId, depIdList)).isNull(DeviceStatus::getPId)).eq(DeviceStatus::getIsDelete, (Object)0)).select(new SFunction[]{DeviceStatus::getMac}));
            if (Util.isEmpty((Collection)deviceStatusList)) {
                log.info("cannot find any device");
                return new PageModel();
            }
            nvrList = deviceStatusList.stream().filter(Objects::nonNull).map(DeviceStatus::getMac).filter(Util::isNotEmpty).toList();
        }
        BoolQueryBuilder boolQueryBuilder = this.assembleQuery(dto, depIdList, nvrList, ipcList);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        long pageNumber = dto.getPageNumber();
        int pageSize = dto.getPageSize();
        if (pageSize > this.elasticSearchConfig.getMaxPageSize()) {
            throw new IllegalArgumentException("exceed max page size: " + pageSize + " > " + this.elasticSearchConfig.getMaxPageSize());
        }
        searchSourceBuilder.size(pageSize);
        if (pageNumber >= 0L) {
            int from = (int)((pageNumber - 1L) * (long)pageSize);
            int maxFrom = this.elasticSearchConfig.getMaxFrom();
            if (from > maxFrom) {
                throw new IllegalArgumentException("exceed max from: " + from + " > " + maxFrom);
            }
            searchSourceBuilder.from(from);
        }
        searchRequest.source(searchSourceBuilder);
        searchRequest.source().sort("_id", SortOrder.ASC);
        PageModel page = this.elasticsearchOperations.page(searchRequest, VideoRecord.class);
        List data = page.getData();
        List<Object> result = new ArrayList();
        if (Util.isNotEmpty((Collection)data)) {
            result = this.transferDto(data, session.getGroupId(), dto.getStartDate(), dto.getEndDate());
            String time = this.getTime(session.getGroupId());
            if (Util.isNotEmpty((CharSequence)time)) {
                LocalTime taskTime = LocalTime.of(Integer.parseInt(time.split(":")[0]), Integer.parseInt(time.split(":")[1]));
                LocalDateTime syncTimeAtToday = LocalDateTime.of(LocalDate.now(), taskTime);
                LocalDateTime syncTimeAtYesterday = LocalDateTime.of(LocalDate.now().minusDays(1L), taskTime);
                LocalDate today = LocalDate.now();
                boolean compareToday = LocalTime.now().isAfter(taskTime);
                for (VideoRecordDto videoRecordDto : result) {
                    LocalDateTime recTime = videoRecordDto.getRecTime();
                    if (recTime.toLocalDate().isEqual(today)) {
                        videoRecordDto.setLatestSyncFlag(true);
                        continue;
                    }
                    videoRecordDto.setLatestSyncFlag(recTime.isAfter(compareToday ? syncTimeAtToday : syncTimeAtYesterday));
                }
            }
        }
        PageModel resultPage = new PageModel();
        resultPage.setPageNumber(dto.getPageNumber().longValue());
        resultPage.setPageSize(dto.getPageSize().intValue());
        resultPage.setTotal(page.getTotal());
        resultPage.setData(result);
        return resultPage;
    }

    public BoolQueryBuilder assembleQuery(VideoRecordReqDto dto, List<Integer> depIdList, List<String> nvrList, List<String> ipcList) {
        Integer recordDays;
        String deviceName;
        String deviceMac;
        Integer deviceType;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)dto.getGroupId()));
        if (CollectionUtils.isNotEmpty(depIdList)) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"deptId", depIdList));
        }
        if ((deviceType = dto.getDeviceType()) != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"deviceType", (Object)deviceType));
        }
        if (Util.isNotEmpty(nvrList)) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"nvrMac", nvrList));
        }
        if (Util.isNotEmpty((CharSequence)(deviceMac = dto.getDeviceMac()))) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"nvrMac.keyword", (String)("*" + deviceMac + "*")));
        }
        if (Util.isNotEmpty((CharSequence)(deviceName = dto.getDeviceName()))) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"deviceName.keyword", (String)("*" + deviceName + "*")));
        }
        if (Util.isNotEmpty((CharSequence)dto.getIpcName())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"ipcName.keyword", (String)("*" + dto.getIpcName() + "*")));
        }
        if ((recordDays = dto.getRecordDays()) != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"totalNum").lt((Object)recordDays));
        }
        if (Util.isNotEmpty(ipcList)) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ipcMac", ipcList));
        }
        return boolQueryBuilder;
    }

    public List<Integer> getDeptIds(VideoRecordReqDto dto, Integer groupId, Integer userId) {
        String organizeIds = dto.getOrganizeIds();
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setIsDel(Integer.valueOf(0));
        mo.setUserGroupId(groupId);
        mo.setUserId(userId);
        if (Util.isNotEmpty((CharSequence)organizeIds)) {
            String[] split = organizeIds.split(",");
            mo.setOrganizeIdList(Arrays.asList(split));
        }
        Map userDepNameMapNew = this.departmentFacade.getUserDepNameMapNew(mo);
        ArrayList<Integer> depIdList = new ArrayList<Integer>(userDepNameMapNew.keySet());
        return depIdList;
    }

    @Override
    public void saveTime(Integer groupId, String time) {
        VideoRecordRunnerTime videoRecordRunnerTime = (VideoRecordRunnerTime)this.videoRecordRunnerTimeMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VideoRecordRunnerTime::getGroupId, (Object)groupId)).last("limit 1"));
        if (Objects.nonNull(videoRecordRunnerTime)) {
            videoRecordRunnerTime.setRunnerTime(time);
            this.videoRecordRunnerTimeMapper.updateById(videoRecordRunnerTime);
        } else {
            videoRecordRunnerTime = new VideoRecordRunnerTime();
            videoRecordRunnerTime.setGroupId(groupId);
            videoRecordRunnerTime.setRunnerTime(time);
            this.videoRecordRunnerTimeMapper.insert(videoRecordRunnerTime);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", this.dmsConfig.getToken());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enterpriseId", groupId);
        params.put("taskType", "rec_logs");
        params.put("runTime", time);
        params.put("taskData", null);
        try {
            String s = HttpUtils.doPost((String)this.dmsConfig.getAddVideoRecordRunnerUrl(), params, (Integer)15000, headers);
            log.info("deviceVideoRecord.saveTime#params:{}#result:{}", (Object)JSON.toJSONString(params), (Object)s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTime(Integer groupId) {
        VideoRecordRunnerTime videoRecordRunnerTime = (VideoRecordRunnerTime)this.videoRecordRunnerTimeMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VideoRecordRunnerTime::getGroupId, (Object)groupId)).last("limit 1"));
        if (Objects.nonNull(videoRecordRunnerTime)) {
            return videoRecordRunnerTime.getRunnerTime();
        }
        return null;
    }

    @Override
    public void delVideoRecordByGroupId(Integer groupId) {
        this.elasticsearchOperations.deleteDocInMultiIndex(() -> QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)groupId)), new String[]{"device-video-record"});
    }

    public List<VideoRecordDto> transferDto(List<VideoRecord> list, Integer groupId, String fromDateStr, String toDateStr) {
        boolean calTotalNumFlag = Util.isNotEmpty((CharSequence)fromDateStr) && Util.isNotEmpty((CharSequence)toDateStr);
        LocalDate fromDate = calTotalNumFlag ? Util.date((String)fromDateStr, (String[])new String[0]) : null;
        LocalDate endDate = calTotalNumFlag ? Util.date((String)toDateStr, (String[])new String[0]) : null;
        int fromYear = calTotalNumFlag ? fromDate.getYear() : 0;
        int fromDay = calTotalNumFlag ? fromDate.getDayOfYear() : 0;
        int toYear = calTotalNumFlag ? endDate.getYear() : 0;
        int toDay = calTotalNumFlag ? endDate.getDayOfYear() : 0;
        List deptIds = list.stream().map(a -> a.getDeptId()).distinct().collect(Collectors.toList());
        List pojoList = this.departmentFacade.getDepPathById(groupId, deptIds);
        Map<Integer, SimplePojo> deptMap = pojoList.stream().collect(Collectors.toMap(SimplePojo::getId, a -> a));
        GetDeviceStoragesFeignMo storagesFeignMo = new GetDeviceStoragesFeignMo();
        storagesFeignMo.setGroupId(groupId);
        storagesFeignMo.setNvrMacList(list.stream().map(a -> a.getNvrMac()).distinct().collect(Collectors.toList()));
        List<GetDeviceStoragesFeignVo> deviceStorages = this.deviceService.getDeviceStorages(storagesFeignMo);
        Map<String, GetDeviceStoragesFeignVo> nvrStatusMap = deviceStorages.stream().collect(Collectors.toMap(a -> a.getNvrMac(), a -> a, (x, y) -> x));
        ArrayList<Integer> deviceIdList = new ArrayList<Integer>();
        deviceIdList.addAll(list.stream().map(VideoRecord::getIpcId).toList());
        deviceIdList.addAll(list.stream().map(VideoRecord::getNvrId).toList());
        BaseResult baseResult = this.deviceStatusApi.getDmsOnlineMap(deviceIdList.stream().distinct().toList());
        Map onOffMap = null;
        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
            onOffMap = (Map)baseResult.getData();
        }
        if (Util.isEmpty(onOffMap)) {
            onOffMap = new HashMap();
        }
        ArrayList<VideoRecordDto> result = new ArrayList<VideoRecordDto>();
        for (VideoRecord record : list) {
            GetDeviceStoragesFeignVo storagesFeignVo;
            VideoRecordDto recordDto = new VideoRecordDto();
            recordDto.setGroupId(record.getGroupId());
            recordDto.setDeptId(record.getDeptId());
            recordDto.setNvrMac(record.getNvrMac());
            recordDto.setDeviceName(record.getDeviceName());
            recordDto.setChannelId(record.getChannelId());
            recordDto.setIpcMac(record.getIpcMac());
            recordDto.setIpcName(record.getIpcName());
            recordDto.setDeviceType(record.getDeviceType());
            recordDto.setIpcOnlineStatus((Integer)onOffMap.get(record.getIpcId()));
            recordDto.setOnlineStatus((Integer)onOffMap.get(record.getNvrId()));
            ArrayList<VideoRecordSubDto> data = new ArrayList<VideoRecordSubDto>();
            for (VideoRecordSub v : record.getData()) {
                VideoRecordSubDto videoRecordSubDto = new VideoRecordSubDto();
                BeanUtils.copyProperties((Object)v, (Object)videoRecordSubDto);
                data.add(videoRecordSubDto);
            }
            recordDto.setData(data);
            recordDto.setTotalNum(record.getTotalNum());
            recordDto.setId(record.getId());
            SimplePojo simplePojo = deptMap.get(record.getDeptId());
            if (Objects.nonNull(simplePojo)) {
                recordDto.setDeptName(simplePojo.getDepartmentName());
                recordDto.setOrgName(simplePojo.getName());
                recordDto.setDeptCode(simplePojo.getShopId());
                recordDto.setDeptType(simplePojo.getDepartmentTypeName());
            }
            if (Objects.nonNull(storagesFeignVo = nvrStatusMap.get(record.getNvrMac()))) {
                recordDto.setDishStatus(storagesFeignVo.getDisStatus());
                Long total = storagesFeignVo.getTotalCapacity() == null ? 0L : storagesFeignVo.getTotalCapacity();
                Long free = storagesFeignVo.getFreeCapacity() == null ? 0L : storagesFeignVo.getFreeCapacity();
                recordDto.setDishCapacity(Util.ByteSizeUnit.formatScale((long)total, (Util.ByteSizeUnit)Util.ByteSizeUnit.M, (int)2) + "/" + Util.ByteSizeUnit.formatScale((long)free, (Util.ByteSizeUnit)Util.ByteSizeUnit.M, (int)2));
            }
            recordDto.setNvrDeviceType(record.getNvrDeviceType());
            recordDto.setNvrInTime(record.getNvrInTime());
            recordDto.setIpcInTime(record.getIpcInTime());
            List<VideoRecordSubDto> videoRecordSubDtoList = recordDto.getData();
            if (calTotalNumFlag) {
                int c = 0;
                for (VideoRecordSubDto dto : videoRecordSubDtoList) {
                    if (dto.getYear() < fromYear || dto.getYear() > toYear) continue;
                    int fromPosition = 0;
                    int toPosition = 366;
                    if (dto.getYear() == fromYear) {
                        fromPosition = fromDay;
                    }
                    if (dto.getYear() == toYear) {
                        toPosition = toDay;
                    }
                    c += this.sumDays(dto.getData(), fromPosition, toPosition);
                }
                recordDto.setTotalNumInDays(c);
            }
            recordDto.setRecTime(record.getRecTime());
            result.add(recordDto);
        }
        return result;
    }

    public int sumDays(String str, int from, int to) {
        int count = 0;
        if (Util.isNotEmpty((CharSequence)str)) {
            int length = Math.min(str.length(), to);
            for (int i = from; i <= length && i < str.length(); ++i) {
                if (str.charAt(i) != '1') continue;
                ++count;
            }
        }
        return count;
    }

    public static int getDayIndexOfYear(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(5, 7));
        int day = Integer.parseInt(date.substring(8, 10));
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return cal.get(6);
    }

    List<GetNvrChildInfoItemFeignVo> getNvrChildInfoItemFeignVoList(GetNvrChildInfoItemMo mo) {
        try {
            BaseResult baseResult = this.deviceStatusApi.getNvrChildInfoItemFeignVoList(mo);
            if (baseResult.getIsError().booleanValue()) {
                log.error("deviceStatusApi.getNvrChildInfoItemFeignVoList{}", (Object)baseResult);
            }
            return (List)baseResult.getData();
        }
        catch (Exception e) {
            log.error("deviceStatusApi.getNvrChildInfoItemFeignVoList\uff0c\u5f02\u5e38\u5185\u5bb9:{}", (Object)e.toString());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void sync(com.ovopark.device.modules.reportvideo.kafka.VideoRecordDto recordDto) {
        String md5 = recordDto.getMd5();
        MDC.put((String)"requestId", (String)md5);
        try {
            log.info("recordDto:{}", (Object)recordDto);
            Integer groupId = recordDto.getGroupId();
            final String nvrMac = recordDto.getNvrMac();
            ElasticsearchOperations.BulkDeleteResponse bulkDeleteResponse = this.elasticsearchOperations.deleteDocInMultiIndex((Supplier)new Supplier<BoolQueryBuilder>(){

                @Override
                public BoolQueryBuilder get() {
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"nvrMac", (String)nvrMac));
                    return boolQueryBuilder;
                }
            }, new String[]{"device-video-record"});
            log.info("delete all docs of nvr(" + nvrMac + ") , result: " + JSONAccessor.impl().format((Object)bulkDeleteResponse));
            GetNvrChildInfoItemMo itemMo = new GetNvrChildInfoItemMo();
            itemMo.setNvrMacList(List.of(nvrMac));
            itemMo.setGroupId(groupId);
            log.info("getNvrChildInfoItemFeignVoList: " + JSONAccessor.impl().format((Object)itemMo));
            List<GetNvrChildInfoItemFeignVo> nvrChildInfoItemFeignVoList = this.getNvrChildInfoItemFeignVoList(itemMo);
            log.info("getNvrChildInfoItemFeignVoList result: " + JSONAccessor.impl().format(nvrChildInfoItemFeignVoList));
            Map<Integer, GetNvrChildInfoItemFeignVo> ipcMap = nvrChildInfoItemFeignVoList.stream().filter(a -> Objects.nonNull(a.getType())).filter(a -> a.getType() == 2 || a.getType() == 1 && Objects.nonNull(a.getIpcId())).map(a -> {
                if (a.getType() == 2) {
                    a.setChannelId(Integer.valueOf(0));
                }
                return a;
            }).collect(Collectors.toMap(a -> a.getChannelId(), a -> a, (x, y) -> x));
            List<VideoRecordSub> data = recordDto.getData();
            if (Util.isNotEmpty(data)) {
                ArrayList<VideoRecord> list = new ArrayList<VideoRecord>();
                Map<Integer, List<VideoRecordSub>> dataMap = data.stream().collect(Collectors.groupingBy(VideoRecordSub::getChannel));
                for (Map.Entry<Integer, List<VideoRecordSub>> entry : dataMap.entrySet()) {
                    Integer key = entry.getKey();
                    List<VideoRecordSub> subDtos = entry.getValue();
                    Integer totalNum = 0;
                    VideoRecord videoRecord = new VideoRecord();
                    String id = MessageFormat.format("{0}_{1}", nvrMac, String.valueOf(key));
                    videoRecord.setId(id);
                    videoRecord.setNvrMac(nvrMac);
                    videoRecord.setGroupId(groupId);
                    videoRecord.setChannelId(key);
                    videoRecord.setMd5(md5);
                    videoRecord.setCreateTime(recordDto.getCreateTime());
                    GetNvrChildInfoItemFeignVo itemFeignVo = ipcMap.get(key);
                    if (Objects.isNull(itemFeignVo)) continue;
                    videoRecord.setDeviceName(itemFeignVo.getNvrName());
                    videoRecord.setDeptId(itemFeignVo.getDepId());
                    videoRecord.setIpcMac(itemFeignVo.getIpcMac());
                    videoRecord.setIpcName(itemFeignVo.getIpcName());
                    videoRecord.setDeviceType(itemFeignVo.getType());
                    for (VideoRecordSub subDto : subDtos) {
                        int days = this.sumDays(subDto.getData());
                        totalNum = totalNum + days;
                        subDto.setNum(days);
                    }
                    videoRecord.setData(subDtos);
                    videoRecord.setTotalNum(totalNum);
                    videoRecord.setIpcId(itemFeignVo.getIpcId());
                    videoRecord.setNvrInTime(itemFeignVo.getNvrCreateTime());
                    videoRecord.setIpcInTime(itemFeignVo.getIpcCreateTime());
                    videoRecord.setNvrDeviceType(itemFeignVo.getNvrDeviceType());
                    videoRecord.setNvrId(itemFeignVo.getNvrId());
                    videoRecord.setRecTime(LocalDateTime.now());
                    list.add(videoRecord);
                }
                if (Util.isNotEmpty(list)) {
                    this.elasticsearchOperations.bulkSave("device-video-record", list);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public int sumDays(String str) {
        int count = 0;
        if (Util.isNotEmpty((CharSequence)str)) {
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                if (str.charAt(i) != '1') continue;
                ++count;
            }
        }
        return count;
    }
}

