/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportvideo.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.platform.PlatformsService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.reportvideo.DeviceVideoReportConfig;
import com.ovopark.device.modules.reportvideo.es.VideoTime;
import com.ovopark.device.thirdparty.ovoIot.model.RecDailyRes;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleVideoTimeGetJob {
    private static final Logger log = LoggerFactory.getLogger(SimpleVideoTimeGetJob.class);
    @Autowired
    private DeviceVideoReportConfig deviceVideoReportConfig;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private NvrService nvrService;
    @Autowired
    private PlatformsService platformsService;
    @Autowired
    private ElasticsearchOperations elasticsearchOperations;
    static final ExecutorService esExecutorService = Executors.newFixedThreadPool(6, Util.newThreadFactory((String)"es-put-io"));

    public void generate(final LocalDate timeDay) {
        log.info("get video time of day: " + Util.formatTime((LocalDate)timeDay, (String[])new String[0]));
        log.info("video time of group id: " + this.deviceVideoReportConfig.getGroupId());
        for (String g : this.deviceVideoReportConfig.getGroupId().split(",")) {
            ArrayList<Integer> dtypeList = new ArrayList<Integer>();
            dtypeList.add(2);
            dtypeList.add(20);
            dtypeList.add(22);
            dtypeList.add(1);
            dtypeList.add(21);
            List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).eq(DeviceStatus::getGroupId, (Object)Integer.parseInt(g))).eq(DeviceStatus::getIsDelete, (Object)0)).in(DeviceStatus::getDType, dtypeList));
            if (Util.isEmpty((Collection)deviceStatusList)) {
                log.info("cannot find any device: " + g);
                continue;
            }
            HashMap<Integer, DeviceStatus> nvrMap = new HashMap<Integer, DeviceStatus>();
            for (final DeviceStatus deviceStatus : deviceStatusList) {
                if (deviceStatus.getPId() != null) continue;
                nvrMap.put(deviceStatus.getId(), deviceStatus);
            }
            for (final DeviceStatus deviceStatus : deviceStatusList) {
                if (deviceStatus.getPId() == null) continue;
                long epochSecond = timeDay.toEpochSecond(LocalTime.MIN, Util.GMT_08);
                long endSec = timeDay.toEpochSecond(LocalTime.MAX, Util.GMT_08);
                DeviceStatus nvr = (DeviceStatus)nvrMap.get(deviceStatus.getPId());
                final String nvrMac = nvr.getMac();
                final int channelId = deviceStatus.getChannelId();
                final String ipcMac = deviceStatus.getMac();
                final long startTimeSec = epochSecond;
                final long endTimeSec = endSec;
                final String nvrExtendCapacity = nvr.getExtendCapacity();
                Integer platformId = deviceStatus.getPlatformId();
                final Platforms platform = this.platformsService.getPlatformsById(platformId);
                int permits = 128;
                ExecutorService executorService = Executors.newFixedThreadPool(permits, Thread.ofVirtual().factory());
                CompletableFuture.supplyAsync(new Supplier<RecDailyRes>(){

                    @Override
                    public RecDailyRes get() {
                        log.info("getRecDaily request: " + nvrMac + "," + deviceStatus.getChannelId() + ", " + ipcMac + ", startTimeSec: " + startTimeSec + ", endTimeSec: " + endTimeSec);
                        RecDailyRes recDaily = SimpleVideoTimeGetJob.this.nvrService.getRecDaily(nvrMac, nvrExtendCapacity, deviceStatus.getChannelId(), ipcMac, Long.valueOf(startTimeSec), Long.valueOf(endTimeSec), platform.getUpgradeServer(), platform.getUpgradePort(), platform.getNewDmsFlag());
                        log.info("getRecDaily response: " + JSONAccessor.impl().format((Object)recDaily));
                        return recDaily;
                    }
                }, executorService).thenAcceptAsync((Consumer)new Consumer<RecDailyRes>(){

                    @Override
                    public void accept(RecDailyRes recDaily) {
                        if (recDaily.getResultDetail() == null) {
                            return;
                        }
                        RecDailyRes.ResultDetailBean resultDetail = recDaily.getResultDetail();
                        List result = resultDetail.getResult();
                        String yyyyMMdd = Util.formatTime((LocalDate)timeDay, (String[])new String[]{"yyyyMMdd"});
                        String id = nvrMac + ":" + channelId + ":" + yyyyMMdd;
                        VideoTime videoTime = (VideoTime)SimpleVideoTimeGetJob.this.elasticsearchOperations.get("device-video-time", id, VideoTime.class);
                        if (videoTime == null) {
                            videoTime = new VideoTime();
                            videoTime.setId(id);
                            videoTime.setNvrMac(nvrMac);
                            videoTime.setChannelId(channelId);
                            videoTime.setIpcMac(ipcMac);
                            videoTime.setFormatDay(yyyyMMdd);
                            videoTime.setVideoTimeDay(result);
                            videoTime.setDeptId(deviceStatus.getDepId());
                            videoTime.setGroupId(deviceStatus.getGroupId());
                            SimpleVideoTimeGetJob.this.elasticsearchOperations.save("device-video-time", (Document)videoTime);
                            log.info("video time record created: " + id);
                        }
                    }
                }, (Executor)esExecutorService);
            }
        }
    }
}

