/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.thirdmgr.report;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.OnlineFacadeRPC;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.DevicesMapper;
import com.ovopark.device.modules.thirdmgr.mysql.YsDevice;
import com.ovopark.device.modules.thirdmgr.mysql.YsDeviceMapper;
import com.ovopark.device.modules.thirdmgr.report.DeviceRes;
import com.ovopark.device.modules.thirdmgr.report.YsMgrDto;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/device-report/export/ysMgr")
public class YsMgrExcel
implements JobOutTaskFlow<YsMgrDto> {
    private static final Logger log = LoggerFactory.getLogger(YsMgrExcel.class);
    @Resource
    private MessageSource messageSource;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Resource
    private DepartmentFacade departmentsService;
    @Autowired
    private YsDeviceMapper ysDeviceMapper;
    @Autowired
    private OnlineFacadeRPC onlineFacade;
    @Autowired
    private DevicesMapper devicesMapper;

    public YsMgrDto requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        YsMgrDto ysMgrDto = (YsMgrDto)JSONAccessor.impl().read(requestBody, YsMgrDto.class);
        ysMgrDto.setSessionGroupId(session.getGroupId());
        ysMgrDto.setSessionUserId(session.getUserId());
        ysMgrDto.setLocale(session.clientInfo().getLocale());
        if (ysMgrDto.getSessionGroupId() != null) {
            ysMgrDto.setGroupId(ysMgrDto.getSessionGroupId());
        }
        return ysMgrDto;
    }

    public void execute(YsMgrDto requestParamBody, OutStore outStore) {
        log.info("execute > " + JSONAccessor.impl().format((Object)requestParamBody));
        Integer userId = requestParamBody.getSessionUserId();
        Integer groupId = requestParamBody.getGroupId();
        String organizeId = requestParamBody.getOrganizeId();
        String channelName = requestParamBody.getChannelName();
        String deviceSerial = requestParamBody.getDeviceSerial();
        Integer bindFlag = requestParamBody.getBindFlag();
        Integer onlineFlag = requestParamBody.getOnlineFlag();
        Locale locale = requestParamBody.getLocale();
        OutStore.SegmentWriter segment = outStore.createSegment("sheet1");
        segment.header().all(DeviceRes.class, path -> this.messageSource.getMessage(path, null, locale));
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setUserId(userId);
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            mo.setOrganizeIdList(Arrays.asList(split));
        }
        mo.setUserGroupId(groupId);
        mo.setIsDel(Integer.valueOf(0));
        Map userDepNameMapNew = this.departmentsService.getUserDepNameMapNew(mo);
        if (CollectionUtils.isEmpty((Map)userDepNameMapNew)) {
            segment.commit();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(YsDevice::getGroupId, (Object)groupId)).eq(YsDevice::getAuthorizeFlag, (Object)1);
        if (Util.isNotEmpty((CharSequence)channelName)) {
            queryWrapper.like(YsDevice::getChannelName, (Object)("%" + channelName + "%"));
        }
        if (Util.isNotEmpty((CharSequence)deviceSerial)) {
            queryWrapper.eq(YsDevice::getDeviceSerial, (Object)deviceSerial);
        }
        if (bindFlag != null) {
            queryWrapper.eq(YsDevice::getBindFlag, (Object)bindFlag);
        }
        queryWrapper.orderByDesc(YsDevice::getDeviceSerial);
        List records = this.ysDeviceMapper.selectList((Wrapper)queryWrapper);
        HashMap<String, ArrayList<Integer>> req = new HashMap<String, ArrayList<Integer>>();
        for (YsDevice item : records) {
            ArrayList<Integer> integers = (ArrayList<Integer>)req.get(item.getDeviceSerial());
            if (integers == null) {
                integers = new ArrayList<Integer>();
                integers.add(item.getChannelId());
                req.put(item.getDeviceSerial(), integers);
                continue;
            }
            integers.add(item.getChannelId());
        }
        Map onlineMap = this.onlineFacade.onOffRT_YS(new ArrayList(req.keySet()));
        LambdaQueryWrapper devicesLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)devicesLambdaQueryWrapper.eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getThirdpartType, (Object)62)).eq(Devices::getIsDelete, (Object)0)).in(Devices::getDepId, userDepNameMapNew.keySet());
        List devicesList = this.devicesMapper.selectList((Wrapper)devicesLambdaQueryWrapper);
        HashMap devicesMap = new HashMap(devicesList.size());
        devicesList.forEach(a -> devicesMap.put(a.getThirdpartDevId() + "-" + a.getChannelId(), a));
        String onlineStr = this.messageSource.getMessage("DeviceReport.device.online", null, locale);
        String offlineStr = this.messageSource.getMessage("DeviceReport.device.offline", null, locale);
        for (YsDevice a2 : records) {
            String key = a2.getDeviceSerial() + "-" + a2.getChannelId();
            Integer online = onlineMap.getOrDefault(key, 0);
            if (onlineFlag != null && !Objects.equals(online, onlineFlag)) continue;
            Devices devices = (Devices)devicesMap.get(key);
            if (bindFlag != null && (bindFlag == 1 && devices == null || bindFlag == 0 && devices != null)) continue;
            DeviceRes deviceRes1 = new DeviceRes();
            deviceRes1.setStatusName(Util.compare2((Comparable)online, (Comparable)Integer.valueOf(1)) == 0 ? onlineStr : offlineStr);
            deviceRes1.setDeviceSerial(a2.getDeviceSerial());
            deviceRes1.setDeviceName(a2.getDeviceName());
            deviceRes1.setChannelId(a2.getChannelId());
            deviceRes1.setChannelName(a2.getChannelName());
            deviceRes1.setCreateTime(a2.getCreateAt());
            if (a2.getBindFlag() == 1) {
                if (devices != null && devices.getIsDelete() != 1) {
                    Integer depId = devices.getDepId();
                    DepartmentOrgMo departmentOrgMo = (DepartmentOrgMo)userDepNameMapNew.get(depId);
                    if (departmentOrgMo != null) {
                        deviceRes1.setDeptName(departmentOrgMo.getName());
                    } else {
                        deviceRes1.setDeptName("\u6570\u636e\u5f02\u5e38-\u627e\u4e0d\u5230\u5bf9\u5e94\u95e8\u5e97");
                    }
                } else {
                    log.error("\u8424\u77f3\u6258\u7ba1\u810f\u6570\u636e\uff1a{}", (Object)a2.toString());
                }
            }
            segment.append((Model)deviceRes1);
        }
        segment.commit();
    }
}

