/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.videoconfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.cloud.api.DeviceApi;
import com.ovopark.device.cloud.common.model.mo.DevicesOnlineMo;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.device.common.util.ListUtil;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.PlatformsService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.DevicesMapper;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.videoconfig.VideoDeviceService;
import com.ovopark.device.modules.videoconfig.report.DeviceVideoConfigExcel;
import com.ovopark.device.modules.videoconfig.vo.DeviceStatusVideoConfigVo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetVideoEncParamsReq;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetVideoEncParamsRes;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoDeviceServiceImpl
implements VideoDeviceService {
    @Resource
    private DepartmentFacade departmentsService;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private PlatformsService platformsService;
    @Autowired
    private DeviceApi deviceApi;
    @Autowired
    private DevicesMapper devicesMapper;
    @Autowired
    private NvrService nvrService;

    @Override
    public PageModel<DeviceStatusVideoConfigVo> getDeviceStatusVideoConfigList(Integer userId, Integer groupId, String organizeId, Integer pageNum, Integer pageSize, String deviceType, Integer onOffStatus, String deviceName, ExecutorService executorService) {
        return this.getDeviceStatusVideoConfigList0(userId, groupId, organizeId, pageNum, pageSize, deviceType, onOffStatus, deviceName, executorService, null, new LimitLogger(this){

            public void log(String content) {
                Util.log.info(content);
            }
        });
    }

    private PageModel<DeviceStatusVideoConfigVo> getDeviceStatusVideoConfigList0(Integer userId, Integer groupId, String organizeId, Integer pageNum, Integer pageSize, String deviceType, Integer onOffStatus, String deviceName, ExecutorService executorService, OutStore.SegmentWriter segmentWriter, LimitLogger limitLogger) {
        List<DeviceStatusVideoConfigVo> voList;
        List ipcList;
        PageModel result = new PageModel();
        result.setPageNumber((long)pageNum.intValue());
        result.setPageSize(pageSize.intValue());
        result.setTotal(0L);
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setUserId(userId);
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            mo.setOrganizeIdList(Arrays.asList(split));
        }
        mo.setUserGroupId(groupId);
        mo.setIsDel(Integer.valueOf(0));
        Map userDepNameMapNew = this.departmentsService.getUserDepNameMapNew(mo);
        if (CollectionUtils.isEmpty((Map)userDepNameMapNew)) {
            return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)0L);
        }
        ArrayList<Integer> dtypList = new ArrayList<Integer>();
        dtypList.add(21);
        dtypList.add(1);
        dtypList.add(22);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getGroupId, (Object)groupId)).eq(DeviceStatus::getIsDelete, (Object)0)).isNotNull(DeviceStatus::getPlatformId)).in(DeviceStatus::getDepId, userDepNameMapNew.keySet())).in(DeviceStatus::getDType, dtypList);
        if (Util.isNotEmpty((CharSequence)deviceName)) {
            queryWrapper.like(DeviceStatus::getDeviceName, (Object)deviceName);
        }
        if (Util.isNotEmpty((CharSequence)deviceType)) {
            queryWrapper.eq(DeviceStatus::getDeviceType, (Object)deviceType);
        }
        List searchDeviceList = null;
        HashMap<Integer, DevicesOnlineMo> deviceOnlineMap = new HashMap();
        if (onOffStatus != null) {
            searchDeviceList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
            if (Util.isEmpty((Collection)searchDeviceList)) {
                return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)result.getTotal());
            }
            devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).in(Devices::getDeviceinfoId, searchDeviceList.stream().map(DeviceStatus::getId).toList())).select(new SFunction[]{Devices::getId}));
            BaseResult baseResult = this.deviceApi.getDeviceOnlineStatus(devicesList.stream().map(Devices::getId).toList());
            if (baseResult != null && !baseResult.getIsError().booleanValue() && baseResult.getData() != null) {
                deviceOnlineMap = ((List)baseResult.getData()).stream().collect(Collectors.toMap(DevicesOnlineMo::getDeviceStatusId, v -> v));
            }
            if (Util.isEmpty(deviceOnlineMap)) {
                deviceOnlineMap = Map.of();
            }
            HashMap finalDeviceOnlineMap = deviceOnlineMap;
            searchDeviceList = searchDeviceList.stream().filter(deviceStatus -> {
                DevicesOnlineMo devicesOnlineMo = (DevicesOnlineMo)finalDeviceOnlineMap.get(deviceStatus.getId());
                return devicesOnlineMo != null && Util.compare2((Comparable)devicesOnlineMo.getOnlineFlag(), (Comparable)onOffStatus) == 0;
            }).toList();
            result.setTotal((long)searchDeviceList.size());
            searchDeviceList = ListUtil.subList(searchDeviceList, (Integer)pageNum, (Integer)pageSize);
            if (Util.isEmpty((Collection)searchDeviceList)) {
                return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)result.getTotal());
            }
        } else {
            if (segmentWriter == null) {
                Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
                Page deviceStatuses = (Page)this.deviceStatusMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
                searchDeviceList = deviceStatuses.getRecords();
                result.setTotal(page.getTotal());
            } else {
                searchDeviceList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
                result.setTotal((long)searchDeviceList.size());
            }
            if (Util.isEmpty((Collection)searchDeviceList)) {
                return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)result.getTotal());
            }
            devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).in(Devices::getDeviceinfoId, searchDeviceList.stream().map(DeviceStatus::getId).toList())).select(new SFunction[]{Devices::getId}));
            limitLogger.log("start get all online status");
            ArrayList<CompletableFuture<Void>> completableFutureList = new ArrayList<CompletableFuture<Void>>();
            final ConcurrentHashMap cMap = new ConcurrentHashMap();
            for (final List devices : Util.partition((List)devicesList, (int)1024)) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){

                    public void run() throws Exception {
                        Map<Integer, DevicesOnlineMo> tmp;
                        BaseResult baseResult = VideoDeviceServiceImpl.this.deviceApi.getDeviceOnlineStatus(devices.stream().map(Devices::getId).toList());
                        if (baseResult != null && !baseResult.getIsError().booleanValue() && baseResult.getData() != null && Util.isNotEmpty(tmp = ((List)baseResult.getData()).stream().collect(Collectors.toMap(DevicesOnlineMo::getDeviceStatusId, v -> v)))) {
                            cMap.putAll(tmp);
                        }
                    }
                }), executorService);
                completableFutureList.add(completableFuture);
            }
            CompletableFuture<Void> allFuture = CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
            try {
                allFuture.join();
            }
            catch (Exception e) {
                Util.log.error(e.getMessage(), (Throwable)e);
            }
            limitLogger.log("end get all online status");
            deviceOnlineMap.putAll(cMap);
            if (Util.isEmpty(deviceOnlineMap)) {
                deviceOnlineMap = Map.of();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(ipcList = searchDeviceList))) {
            return result;
        }
        ArrayList<Integer> platformIdList = new ArrayList<Integer>();
        ArrayList<Object> nvrIdList = new ArrayList<Object>();
        for (DeviceStatus ipc : ipcList) {
            Integer pId = ipc.getPId();
            Integer id = ipc.getId();
            nvrIdList.add(pId == null ? (Object)id : (Object)pId);
            platformIdList.add(ipc.getPlatformId());
        }
        List nvrList = this.deviceStatusService.getDeviceStatusListByIds(nvrIdList);
        HashMap<Integer, DeviceStatus> nvrIdMap = new HashMap<Integer, DeviceStatus>();
        for (DeviceStatus nvr : nvrList) {
            nvrIdMap.put(nvr.getId(), nvr);
            platformIdList.add(nvr.getPlatformId());
        }
        List platformsList = this.platformsService.getPlatforms(platformIdList);
        HashMap<Integer, Platforms> platformsMap = new HashMap<Integer, Platforms>();
        for (Platforms item : platformsList) {
            platformsMap.put(item.getId(), item);
        }
        if (segmentWriter == null) {
            voList = this.extracted(executorService, ipcList, nvrIdMap, userDepNameMapNew, deviceOnlineMap, platformsMap);
            result.setData(voList);
            return result;
        }
        limitLogger.log("all devices count: " + ipcList.size());
        voList = this.extracted(executorService, ipcList, nvrIdMap, userDepNameMapNew, deviceOnlineMap, platformsMap);
        limitLogger.log("end getVideoEncParams: " + ipcList.size());
        Map<Integer, List<DeviceStatusVideoConfigVo>> voConfigList = voList.stream().collect(Collectors.groupingBy(DeviceStatusVideoConfigVo::getDepId));
        for (Map.Entry<Integer, List<DeviceStatusVideoConfigVo>> entry : voConfigList.entrySet()) {
            Integer key = entry.getKey();
            DepartmentOrgMo departmentOrgMo = (DepartmentOrgMo)userDepNameMapNew.get(key);
            String deptName = null;
            if (departmentOrgMo != null) {
                deptName = departmentOrgMo.getName();
            }
            DeviceVideoConfigExcel deviceVideoConfigExcel = new DeviceVideoConfigExcel();
            deviceVideoConfigExcel.setDepName(deptName);
            ArrayList<DeviceVideoConfigExcel.DevicePart> devicePartList = new ArrayList<DeviceVideoConfigExcel.DevicePart>();
            for (DeviceStatusVideoConfigVo deviceStatusVideoConfigVo : entry.getValue()) {
                DeviceVideoConfigExcel.DevicePart devicePart = new DeviceVideoConfigExcel.DevicePart();
                devicePart.setDeviceName(deviceStatusVideoConfigVo.getDeviceName());
                devicePart.setIpcDeviceType(deviceStatusVideoConfigVo.getIpcDeviceType());
                devicePart.setMac(deviceStatusVideoConfigVo.getIpcMac());
                String ipcDeviceType = deviceStatusVideoConfigVo.getIpcDeviceType();
                devicePart.setIpcDeviceType(Util.isEmpty((CharSequence)ipcDeviceType) ? "-" : ipcDeviceType);
                devicePart.setOnlineFlag(deviceStatusVideoConfigVo.getOnlineFlag().equals(1) ? "\u5728\u7ebf" : "\u79bb\u7ebf");
                if (deviceStatusVideoConfigVo.getWidth() == null || deviceStatusVideoConfigVo.getHeight() == null) {
                    devicePart.setResolution("-");
                } else {
                    devicePart.setResolution(deviceStatusVideoConfigVo.getWidth() + " \u00d7 " + deviceStatusVideoConfigVo.getHeight());
                }
                Integer bitRate = deviceStatusVideoConfigVo.getBitRate();
                devicePart.setBitRate(bitRate == null ? "-" : String.valueOf(bitRate));
                Integer frameRate = deviceStatusVideoConfigVo.getFrameRate();
                devicePart.setFrameRate(frameRate == null ? "-" : String.valueOf(frameRate));
                Integer maxKeyFrameInteval = deviceStatusVideoConfigVo.getMaxKeyFrameInteval();
                devicePart.setMaxKeyFrameInterval(maxKeyFrameInteval == null ? "-" : String.valueOf(maxKeyFrameInteval));
                String imageQulity = deviceStatusVideoConfigVo.getImageQulity();
                devicePart.setImageQuality(Util.isEmpty((CharSequence)imageQulity) ? "-" : imageQulity);
                Integer brightness = deviceStatusVideoConfigVo.getBrightness();
                devicePart.setBrightness(brightness == null ? "-" : String.valueOf(brightness));
                Integer contrast = deviceStatusVideoConfigVo.getContrast();
                devicePart.setContrast(contrast == null ? "-" : String.valueOf(contrast));
                Integer saturation = deviceStatusVideoConfigVo.getSaturation();
                devicePart.setSaturation(saturation == null ? "-" : String.valueOf(saturation));
                Integer dynamicValue = deviceStatusVideoConfigVo.getDynamicValue();
                devicePart.setDynamicValue(dynamicValue == null ? "-" : String.valueOf(dynamicValue));
                devicePartList.add(devicePart);
            }
            deviceVideoConfigExcel.setDevicePartList(devicePartList);
            segmentWriter.append((Model)deviceVideoConfigExcel);
        }
        return null;
    }

    private List<DeviceStatusVideoConfigVo> extracted(ExecutorService executorService, List<DeviceStatus> ipcList, Map<Integer, DeviceStatus> nvrIdMap, Map<Integer, DepartmentOrgMo> userDepNameMapNew, Map<Integer, DevicesOnlineMo> deviceOnlineMap, Map<Integer, Platforms> platformsMap) {
        ArrayList<DeviceStatusVideoConfigVo> list = new ArrayList<DeviceStatusVideoConfigVo>();
        ArrayList<CompletableFuture<Void>> completableFutureList = new ArrayList<CompletableFuture<Void>>();
        Integer isSecondVideo = 0;
        AtomicLong count = new AtomicLong(ipcList.size());
        AtomicLong offlineCount = new AtomicLong(0L);
        StopWatch stopWatch = StopWatch.createStarted();
        for (DeviceStatus item : ipcList) {
            DevicesOnlineMo onlineVo;
            GetVideoEncParamsReq req = new GetVideoEncParamsReq();
            ArrayList<GetVideoEncParamsReq.MacInfoBean> infoList = new ArrayList<GetVideoEncParamsReq.MacInfoBean>();
            GetVideoEncParamsReq.MacInfoBean macInfoBean = new GetVideoEncParamsReq.MacInfoBean();
            macInfoBean.setIpcmac(item.getMac());
            macInfoBean.setChannelId(item.getChannelId());
            macInfoBean.setIsSecondVideo(isSecondVideo);
            infoList.add(macInfoBean);
            req.setMacInfo(infoList);
            DeviceStatus nvr = item;
            if (item.getPId() != null) {
                nvr = nvrIdMap.get(item.getPId());
            }
            DeviceStatusVideoConfigVo vo = new DeviceStatusVideoConfigVo();
            vo.setIpcDeviceType(item.getDeviceType());
            vo.setNvrDeviceStatusId(nvr.getId());
            vo.setDtype(item.getDType());
            vo.setNvrDeviceType(nvr.getDeviceType());
            vo.setDepId(item.getDepId());
            DepartmentOrgMo departmentOrgMo = userDepNameMapNew.get(item.getDepId());
            if (departmentOrgMo != null) {
                vo.setDepName(departmentOrgMo.getName());
            }
            if ((onlineVo = deviceOnlineMap.get(item.getId())) == null) {
                vo.setOnlineFlag(0);
            } else {
                vo.setOnlineFlag(onlineVo.getOnlineFlag());
            }
            vo.setDeviceName(item.getDeviceName());
            vo.setIpcDeviceStatusId(item.getId());
            vo.setIpcMac(item.getMac());
            vo.setChannelId(item.getChannelId());
            Platforms platforms = platformsMap.get(nvr.getPlatformId());
            DeviceStatus finalNvr = nvr;
            if (Util.compare2((Comparable)vo.getOnlineFlag(), (Comparable)Integer.valueOf(1)) == 0) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(Util.catchRunnable(() -> {
                    GetVideoEncParamsRes.VideoEncParamsBean videoEncParamsBean;
                    StopWatch sw = StopWatch.createStarted();
                    Util.log.info("request getVideoEncParams channel ");
                    GetVideoEncParamsRes videoEncParams = this.nvrService.getVideoEncParams(finalNvr.getMac(), req, platforms.getUpgradeServer(), platforms.getUpgradePort(), platforms.getNewDmsFlag());
                    count.decrementAndGet();
                    Util.log.info("response getVideoEncParams channel " + sw.formatTime() + " , rest: " + count.get() + " , offline count: " + offlineCount.get());
                    if (videoEncParams == null) {
                        return;
                    }
                    List videoEncParams1 = videoEncParams.getVideoEncParams();
                    if (CollectionUtils.isNotEmpty((Collection)videoEncParams1) && (videoEncParamsBean = (GetVideoEncParamsRes.VideoEncParamsBean)videoEncParams1.get(0)) != null) {
                        vo.setIsSecondVideo(isSecondVideo);
                        vo.setEncType(videoEncParamsBean.getEncType());
                        vo.setBitRate(videoEncParamsBean.getBitRate());
                        vo.setMaxKeyFrameInteval(videoEncParamsBean.getMaxKeyFrameInteval());
                        vo.setMaxQuant(videoEncParamsBean.getMaxQuant());
                        vo.setMinQuant(videoEncParamsBean.getMinQuant());
                        vo.setFrameRate(videoEncParamsBean.getFrameRate());
                        vo.setImageQulity(videoEncParamsBean.getImageQulity().toString());
                        GetVideoEncParamsRes.VideoEncParamsBean.ResolutionBean resolution = videoEncParamsBean.getResolution();
                        if (resolution != null) {
                            vo.setWidth(resolution.getWidth());
                            vo.setHeight(resolution.getHeight());
                        }
                        vo.setBrightness(videoEncParamsBean.getBrightness());
                        vo.setContrast(videoEncParamsBean.getContrast());
                        vo.setSaturation(videoEncParamsBean.getSaturation());
                        vo.setDynamicValue(videoEncParamsBean.getDynamicValue());
                    }
                }), executorService);
                completableFutureList.add(completableFuture);
            } else {
                offlineCount.incrementAndGet();
                count.decrementAndGet();
            }
            list.add(vo);
        }
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
        try {
            allFuture.join();
        }
        catch (Exception e) {
            Util.log.error(e.getMessage(), (Throwable)e);
        }
        Util.log.info("getVideoEncParams , cost time : " + stopWatch.formatTime() + " , request count : " + completableFutureList.size() + " , rest: " + count.get() + " , offline count: " + offlineCount.get());
        return list;
    }

    @Override
    public void exportDeviceStatusVideoConfigList(Integer userId, Integer groupId, String organizeId, String deviceType, Integer onOffStatus, String deviceName, OutStore.SegmentWriter segmentWriter, LimitLogger limitLogger, ExecutorService executorService) {
        this.getDeviceStatusVideoConfigList0(userId, groupId, organizeId, 1, Integer.MAX_VALUE, deviceType, onOffStatus, deviceName, executorService, segmentWriter, limitLogger);
    }
}

