/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.hik.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.device.thirdparty.hik.filter.HikTokenService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HikFeignRequestInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HikFeignRequestInterceptor.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private HikTokenService hikTokenService;

    public void apply(RequestTemplate template) {
        String name = template.feignTarget().name();
        if (!Objects.equals(name, "sdk-hik")) {
            return;
        }
        String appKey = this.getAppKeyFromQueries(template.queries());
        if (appKey == null && template.body() != null) {
            appKey = this.getAppKeyFromBody(template);
        }
        log.info("Extracted appKey: {}", (Object)appKey);
        if (appKey != null) {
            String token = this.hikTokenService.getToken(appKey);
            template.header("Authorization", new String[]{"Bearer " + token});
            log.info("Added token header for appKey: {}", (Object)appKey);
        } else {
            log.warn("No appKey found in request: {}", (Object)template.url());
        }
    }

    private String getAppKeyFromQueries(Map<String, Collection<String>> queries) {
        Collection<String> appKeys = queries.get("appKey");
        return appKeys != null && !appKeys.isEmpty() ? appKeys.iterator().next() : null;
    }

    private String getAppKeyFromBody(RequestTemplate template) {
        try {
            String bodyStr = new String(template.body(), StandardCharsets.UTF_8);
            JsonNode jsonNode = this.objectMapper.readTree(bodyStr);
            return jsonNode.has("appKey") ? jsonNode.get("appKey").asText() : null;
        }
        catch (Exception e) {
            log.error("Failed to parse request body", (Throwable)e);
            return null;
        }
    }
}

