/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2BaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2New1Res;
import com.ovopark.device.thirdparty.ovoIot.model.GetPoEStatusRes;
import com.ovopark.device.thirdparty.ovoIot.model.ResultRes;
import com.ovopark.device.thirdparty.ovoIot.model.SocketBaseReq;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.req.NetBandwidthTestReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.NetTrackReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetNvrAlarmCfg;
import com.ovopark.device.thirdparty.ovoIot.service.BaseService;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import java.text.MessageFormat;
import java.util.Random;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NvrService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NvrService.class);
    @Autowired
    private BaseService baseService;

    public ResultRes setNvrAlarmCnfReq(String mac, SetNvrAlarmCfg alarmCnf, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/setNvrAlarmCnfReq", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(alarmCnf));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        ResultRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, ResultRes.class);
        }
        catch (Exception e) {
            log.error("setNvrAlarmCnfReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetPoEStatusRes> getNvrPoeStatus(String mac) {
        String s = this.baseService.sendToDms2("pu/" + mac + "/getPoEStatus", mac, null, null);
        try {
            return (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetPoEStatusRes>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public Dms2BaseRes netBandwidthTest(String mac, NetBandwidthTestReq netBandwidthTestReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/netBandwidthTest", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(netBandwidthTestReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2BaseRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2BaseRes.class);
        }
        catch (Exception e) {
            log.error("netBandwidthTest error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2BaseRes netTrack(String mac, NetTrackReq netTrackReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/netTrack", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(netTrackReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2BaseRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2BaseRes.class);
        }
        catch (Exception e) {
            log.error("netTrack error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }
}

