/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.device.thirdparty.ovoIot.model.AlarmConfig;
import com.ovopark.device.thirdparty.ovoIot.model.AlarmConfigTime;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2BaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2New1Res;
import com.ovopark.device.thirdparty.ovoIot.model.GetAlarmCfg;
import com.ovopark.device.thirdparty.ovoIot.model.GetAlarmCfgBean;
import com.ovopark.device.thirdparty.ovoIot.model.GetAlarmCfgResult;
import com.ovopark.device.thirdparty.ovoIot.model.GetPoEStatusRes;
import com.ovopark.device.thirdparty.ovoIot.model.MacInfoBean;
import com.ovopark.device.thirdparty.ovoIot.model.ResultRes;
import com.ovopark.device.thirdparty.ovoIot.model.SocketBaseReq;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetChnStreamTypeRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetCpuOccupyRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetRoundPlayRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetVideoEncParamsReq;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetVideoEncParamsRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.MultiReidInitCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.NetBandwidthTestReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.NetTrackReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetAVInterfaceCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetAlgoStandardItemReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetNvrAlarmCfg;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetTimerRecordTaskReq;
import com.ovopark.device.thirdparty.ovoIot.service.BaseService;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NvrService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NvrService.class);
    public static String NVR_GET_ALARM_CFG = "pu/{0}/getAlarmCfg";
    @Autowired
    private BaseService baseService;

    public ResultRes setNvrAlarmCnfReq(String mac, SetNvrAlarmCfg alarmCnf, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/setNvrAlarmCnfReq", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(alarmCnf));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        ResultRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, ResultRes.class);
        }
        catch (Exception e) {
            log.error("setNvrAlarmCnfReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetPoEStatusRes> getNvrPoeStatus(String mac) {
        String s = this.baseService.sendToDms2("pu/" + mac + "/getPoEStatus", mac, null, null);
        try {
            return (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetPoEStatusRes>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public Dms2BaseRes netBandwidthTest(String mac, NetBandwidthTestReq netBandwidthTestReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/netBandwidthTest", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(netBandwidthTestReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2BaseRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2BaseRes.class);
        }
        catch (Exception e) {
            log.error("netBandwidthTest error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2BaseRes netTrack(String mac, NetTrackReq netTrackReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/netTrack", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(netTrackReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2BaseRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2BaseRes.class);
        }
        catch (Exception e) {
            log.error("netTrack error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setAVInterfaceCfg(String mac, SetAVInterfaceCfgReq setAVInterfaceCfgReq) {
        String requstName = MessageFormat.format("pu/{0}/setAVInterfaceCfg", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(setAVInterfaceCfgReq));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2New1Res.class);
        }
        catch (Exception e) {
            log.error("setAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<SetAVInterfaceCfgReq> getAVInterfaceCfg(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getAVInterfaceCfg", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<SetAVInterfaceCfgReq>>(this){});
        }
        catch (Exception e) {
            log.error("getAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public AlarmConfig getAlarmConfig(Integer alarmType, Integer ioInputIndex, String server, Integer port, String nvrMac, String ipcMac, Integer ipcChannelId, Integer warningOpen, Integer dms2Flag) {
        AlarmConfig result = new AlarmConfig();
        GetAlarmCfg alarmJson = new GetAlarmCfg();
        ArrayList<MacInfoBean> macInfoList = new ArrayList<MacInfoBean>();
        MacInfoBean macInfo = new MacInfoBean();
        macInfo.setIpcmac(ipcMac);
        macInfo.setAlarmType(alarmType);
        macInfo.setChannelId(ipcChannelId);
        if (ioInputIndex != null) {
            macInfo.setIoinputIndex(ioInputIndex);
        }
        macInfoList.add(macInfo);
        alarmJson.setMacInfo(macInfoList);
        String msgContent = IotJsonUtils.beanToJsonString(alarmJson);
        String requstName = MessageFormat.format(NVR_GET_ALARM_CFG, nvrMac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(msgContent);
        req.setHost(server);
        req.setPort(port);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String resultMsg = this.baseService.sendRequestToRegGetStr(req);
        if (resultMsg != null) {
            GetAlarmCfgResult json = null;
            json = IotJsonUtils.jsonToBean(resultMsg, GetAlarmCfgResult.class);
            Integer resultCode = json.getResult();
            if (resultCode != null && "200000".equals(resultCode.toString())) {
                List<GetAlarmCfgBean> alarmCfg = json.getAlarmCfg();
                for (GetAlarmCfgBean alarmCfgBean : alarmCfg) {
                    if (!ipcMac.equals(alarmCfgBean.getIpcmac())) continue;
                    result.setIpcmac(ipcMac);
                    result.setAlarmType(alarmType);
                    result.setAlarmEnable(alarmCfgBean.getAlarmEnable());
                    SetNvrAlarmCfg.DateBean date = alarmCfgBean.getDate();
                    if (date != null) {
                        String start = date.getStart();
                        String end = date.getEnd();
                        result.setStartDate(start);
                        result.setEndDate(end);
                    }
                    List<SetNvrAlarmCfg.TimeBean> timePeriods = alarmCfgBean.getTime();
                    result.setTimes(NvrService.getTimeForPage(timePeriods));
                    Integer alarmInterval = alarmCfgBean.getAlarmInterval();
                    if (5 == alarmType) {
                        alarmInterval = alarmInterval / 60;
                    }
                    result.setAlarmNotify(alarmCfgBean.getAlarmNotify());
                    result.setAlarmInterval(alarmInterval);
                    result.setAlarmItvEnable(alarmCfgBean.getAlarmItvEnable());
                    if (alarmType == 3 || alarmType == 6 || alarmType == 5) {
                        result.setDetectionSensitivity(alarmCfgBean.getAlarmDetectionSensitivity());
                    }
                    if (alarmType == 3 || alarmType == 6 || alarmType == 5) {
                        result.setDetectionArea(alarmCfgBean.getAlarmArea());
                    }
                    result.setSnapshot(alarmCfgBean.getSnapshot());
                    result.setWarningOpen(warningOpen);
                    if (alarmType != 4 && alarmType != 6) continue;
                    result.setIoInputIndex(alarmCfgBean.getIoinputIndex());
                    result.setIoInputType(alarmCfgBean.getIoinputType());
                    result.setIoOuput(alarmCfgBean.getIoouput());
                }
            }
        }
        return result;
    }

    public static List<AlarmConfigTime> getTimeForPage(List<SetNvrAlarmCfg.TimeBean> times) {
        HashMap timeMap = new HashMap();
        if (!CollectionUtils.isEmpty(times)) {
            for (SetNvrAlarmCfg.TimeBean time : times) {
                Integer week = time.getWeek();
                List<SetNvrAlarmCfg.PeriodBean> periods = time.getPeriod();
                for (SetNvrAlarmCfg.PeriodBean period : periods) {
                    SetNvrAlarmCfg.PeriodBean newPeriod = new SetNvrAlarmCfg.PeriodBean(period.getStart(), period.getEnd());
                    ArrayList<Integer> weeks = (ArrayList<Integer>)timeMap.get(newPeriod);
                    if (CollectionUtils.isEmpty((Collection)weeks)) {
                        weeks = new ArrayList<Integer>();
                        timeMap.put(newPeriod, weeks);
                    }
                    if (weeks.contains(week)) continue;
                    weeks.add(week);
                }
            }
        }
        ArrayList<AlarmConfigTime> result = new ArrayList<AlarmConfigTime>();
        Set periodSet = timeMap.keySet();
        for (SetNvrAlarmCfg.PeriodBean period : periodSet) {
            AlarmConfigTime configTime = new AlarmConfigTime();
            String start = period.getStart().substring(0, 2) + ":" + period.getStart().substring(2, 4);
            configTime.setStartTime(start);
            String end = period.getEnd().substring(0, 2) + ":" + period.getEnd().substring(2, 4);
            configTime.setEndTime(end);
            configTime.setWeeks((List)timeMap.get(period));
            result.add(configTime);
        }
        return result;
    }

    public Dms2New1Res<MultiReidInitCfgReq> getMultiReidInitCfg(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getMultiReidInitCfg", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<MultiReidInitCfgReq>>(this){});
        }
        catch (Exception e) {
            log.error("getAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setMultiReidInitCfg(String mac, MultiReidInitCfgReq reqMo) {
        String requstName = MessageFormat.format("pu/{0}/setMultiReidInitCfg", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        ObjectMapper copy = IotJsonUtils.objectMapper.copy();
        copy.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String json = null;
        try {
            json = copy.writeValueAsString((Object)reqMo);
            log.info("json:{}", (Object)json);
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        req.setMsgContent(json);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<MultiReidInitCfgReq>>(this){});
        }
        catch (Exception e) {
            log.error("getAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetRoundPlayRes> getRoundPlay(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getRoundPlay", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetRoundPlayRes>>(this){});
        }
        catch (Exception e) {
            log.error("getRoundPlay error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setRoundPlay(String mac, GetRoundPlayRes reqMo) {
        String requstName = MessageFormat.format("pu/{0}/setRoundPlay", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(reqMo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("setRoundPlay error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetChnStreamTypeRes> getChnStreamType(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getChnStreamType", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetChnStreamTypeRes>>(this){});
        }
        catch (Exception e) {
            log.error("getChnStreamType error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setChnStreamType(String mac, GetChnStreamTypeRes reqMo) {
        String requstName = MessageFormat.format("pu/{0}/setChnStreamType", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(reqMo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("setChnStreamType error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetCpuOccupyRes> getCpuOccupy(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getCpuOccupy", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetCpuOccupyRes>>(this){});
        }
        catch (Exception e) {
            log.error("getCpuOccupy error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetVideoEncParamsRes getVideoEncParams(String nvrMac, GetVideoEncParamsReq req, String serverIp, Integer serverPort, Integer dms2Flag) {
        String reqName = MessageFormat.format("pu/{0}/getVideoEncParams", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq();
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(req));
        socketBaseReq.setHost(serverIp);
        socketBaseReq.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        socketBaseReq.setSessionId(String.valueOf(sessionId));
        socketBaseReq.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        GetVideoEncParamsRes getVideoEncParamsRes = null;
        try {
            getVideoEncParamsRes = IotJsonUtils.jsonToBean(s, GetVideoEncParamsRes.class);
        }
        catch (Exception e) {
            log.error("getVideoEncParams error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return getVideoEncParamsRes;
    }

    public Dms2New1Res setAlgoStandard(String mac, List<SetAlgoStandardItemReq> mo) {
        String requstName = MessageFormat.format("pu/{0}/setAlgoStandard", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        HashMap<String, List<SetAlgoStandardItemReq>> reqMap = new HashMap<String, List<SetAlgoStandardItemReq>>();
        reqMap.put("algoStandardPic", mo);
        req.setMsgContent(IotJsonUtils.beanToJsonString(reqMap));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("getCpuOccupy error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setTimerRecordTaskReq(String mac, List<SetTimerRecordTaskReq> mo, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/setTimerRecordTaskReq", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(mo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("setTimerRecordTaskReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<List<SetTimerRecordTaskReq>> getTimerRecordTaskReq(String mac, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/getTimerRecordTaskReq", mac);
        SocketBaseReq req = new SocketBaseReq();
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<List<SetTimerRecordTaskReq>>>(this){});
        }
        catch (Exception e) {
            log.error("getTimerRecordTaskReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }
}

