/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.service;

import com.ovopark.device.thirdparty.ovoIot.config.OvoIotConfig;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2Res;
import com.ovopark.device.thirdparty.ovoIot.model.SocketBaseReq;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import com.ovopark.device.thirdparty.ovoIot.util.LogUtil;
import com.ovopark.device.thirdparty.ovoIot.util.MsgUtil;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Service
public class BaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    @Autowired
    private OvoIotConfig ovoIotConfig;
    private final OkHttpClient okHttpClient;
    public static final String DEFAULT_ENCODE = "UTF8";
    public static final int contactTimeOut = 5000;
    public static final int requestTimeOut = 30000;
    public static final int defaultTimeOut = 30000;
    public static String authentication = "RGV2aWNlUmVnQWRtaW46RGV2aWNlUmVnQWRtaW4yMDEz";

    @Autowired
    public BaseService(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendRequestToRegGetStr(@Validated SocketBaseReq req) {
        Integer respTimeout;
        Object sessionId;
        Boolean need2n;
        String requestName = req.getRequestName();
        String msgContent = req.getMsgContent();
        String host = req.getHost();
        Integer port = req.getPort();
        if (req.getDmsFlag() == 1) {
            return this.dms2(requestName, msgContent);
        }
        String charsetName = req.getCharsetName();
        if (ObjectUtils.isEmpty((Object)charsetName)) {
            charsetName = DEFAULT_ENCODE;
        }
        if ((need2n = req.getNeed2n()).booleanValue()) {
            log.error("xinling two need2n requestName :{}", (Object)requestName);
        }
        if (StringUtils.isEmpty((Object)(sessionId = req.getSessionId()))) {
            sessionId = "" + (System.currentTimeMillis() + (long)new Random().nextInt());
        }
        FilterOutputStream os = null;
        Object in = null;
        String reMsg = null;
        String result = null;
        Socket socket = null;
        Integer connectTimeout = req.getConnectTimeout();
        if (connectTimeout == null) {
            connectTimeout = 5000;
        }
        if ((respTimeout = req.getRespTimeout()) == null) {
            respTimeout = 30000;
        }
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.connect(new InetSocketAddress(req.getHost(), (int)req.getPort()), connectTimeout);
            socket.setSoTimeout(respTimeout);
            os = new DataOutputStream(socket.getOutputStream());
            if (msgContent == null) {
                msgContent = "";
            }
            int length = msgContent.getBytes(charsetName).length;
            String content = null;
            content = need2n == Boolean.TRUE ? MsgUtil.createMsgContent(requestName, host, port, length, authentication, msgContent, (String)sessionId) : MsgUtil.createSingleMsgContent(requestName, host, port, length, authentication, msgContent, (String)sessionId);
            log.info("send cmd to " + host + ",requestName:" + requestName + ",msg:" + content);
            os.write(content.getBytes(charsetName));
            ((DataOutputStream)os).flush();
            reMsg = BaseService.readInputStreamNew(socket.getInputStream(), charsetName);
            log.info("get result from " + host + ",requestName:" + requestName + ",result:" + reMsg);
            result = reMsg = MsgUtil.parseResult(reMsg);
            socket.close();
        }
        catch (IOException e) {
            log.error(LogUtil.getStackTraceInfo(e));
            log.info("send cmd to " + host + ",requestName:" + requestName);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            try {
                assert (socket != null);
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStreamNew(InputStream ins, String encode) {
        long l = System.currentTimeMillis();
        BufferedInputStream bis = new BufferedInputStream(ins);
        try {
            int buffSize = 102400;
            byte[] bufferTotal = new byte[buffSize];
            int readTotal = 0;
            int headerLength = 0;
            int bodyLength = 0;
            int total = 0;
            while (System.currentTimeMillis() - l <= 60000L) {
                String[] heads;
                byte[] buffer = new byte[1024];
                int read = bis.read(buffer);
                if (read > 0) {
                    readTotal = total + read;
                }
                for (int i = 0; i < read; ++i) {
                    bufferTotal[total] = buffer[i];
                    ++total;
                }
                String str = new String(bufferTotal, encode);
                int i = str.indexOf("\r\n\r\n", 0);
                if (i <= 0) continue;
                String s = str.substring(0, i);
                headerLength = s.length();
                for (String head : heads = s.split("\r\n")) {
                    String contentLengthStr = "Content-Length:";
                    if (!head.startsWith(contentLengthStr)) continue;
                    bodyLength = Integer.parseInt(head.split(":")[1].trim());
                    String body = str.substring(i + 4);
                    if (headerLength + 4 + bodyLength + 2 != readTotal) continue;
                    String string = body.trim().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\"\t", "\"").replaceAll("\t\"", "\"").trim();
                    return string;
                }
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            log.error(LogUtil.getStackTraceInfo(e));
            String string = "";
            return string;
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                log.error(LogUtil.getStackTraceInfo(e));
            }
        }
    }

    public String dms2(String requestName, String msgContent) {
        String nvrMac;
        block16: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            nvrMac = "";
                                            if (!Objects.equals("devmanage/nvr/delDev", requestName)) break block17;
                                            String[] split = msgContent.split("&");
                                            nvrMac = split[0].replace("mac=", "");
                                            ArrayList ipcList = new ArrayList();
                                            String[] split1 = split[1].split("\\|");
                                            for (int i = 0; i < split1.length; i += 2) {
                                                HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
                                                stringObjectHashMap.put("ipcmac", split1[i].replace("ipcmac=", ""));
                                                stringObjectHashMap.put("channelId", Integer.parseInt(split1[i + 1].replace("channelId=", "")));
                                                ipcList.add(stringObjectHashMap);
                                            }
                                            HashMap re = new HashMap();
                                            re.put("macInfo", ipcList);
                                            msgContent = IotJsonUtils.beanToJsonString(re);
                                            break block16;
                                        }
                                        if (!Objects.equals("getDeviceStatus", requestName)) break block18;
                                        nvrMac = msgContent.replace("macaddr=", "");
                                        break block16;
                                    }
                                    if (!requestName.startsWith("upgradeDevice")) break block19;
                                    String[] split = msgContent.split("&");
                                    for (int i = 0; i < split.length; ++i) {
                                        String temp = split[i];
                                        if (!temp.startsWith("macaddr=")) continue;
                                        nvrMac = temp.replace("macaddr=", "");
                                    }
                                    break block16;
                                }
                                if (!Objects.equals("getDeviceVersion", requestName)) break block20;
                                nvrMac = msgContent.replace("macaddr=", "");
                                break block16;
                            }
                            if (!requestName.startsWith("devmanage/nvr/getRecDailyList")) break block21;
                            nvrMac = requestName.split("&")[1];
                            requestName = requestName.split("&")[0];
                            break block16;
                        }
                        if (!requestName.startsWith("devmanage/nvr/getRecMonthList")) break block22;
                        nvrMac = requestName.split("&")[1];
                        requestName = requestName.split("&")[0];
                        break block16;
                    }
                    if (!requestName.startsWith("pu")) break block23;
                    nvrMac = requestName.split("/")[1];
                    if (!requestName.contains("setOnvifTimeSyncReq")) break block16;
                    HashMap<String, Integer> stringObjectHashMap = new HashMap<String, Integer>();
                    stringObjectHashMap.put("setFlag", Integer.valueOf(msgContent.replace("setFlag=", "")));
                    msgContent = IotJsonUtils.beanToJsonString(stringObjectHashMap);
                    break block16;
                }
                if (!requestName.startsWith("devmanage")) break block24;
                if (msgContent.contains("&")) {
                    String[] split;
                    for (String s1 : split = msgContent.split("&")) {
                        if (!s1.contains("mac=")) continue;
                        nvrMac = s1.replace("mac=", "");
                        break;
                    }
                } else {
                    String[] split;
                    for (String s1 : split = msgContent.split("\\|")) {
                        if (!s1.contains("mac=")) continue;
                        nvrMac = s1.replace("mac=", "");
                        break;
                    }
                }
                if (!requestName.contains("searchDev")) break block16;
                msgContent = "";
                break block16;
            }
            if (requestName.startsWith("queryDeviceConfig") || requestName.startsWith("setDeviceConfig")) {
                String[] split = requestName.split("?");
                nvrMac = split[1].replace("devsn=", "");
            } else if (requestName.startsWith("ctrlDevice")) {
                HashMap<String, Integer> reqMap = new HashMap<String, Integer>();
                String[] split = msgContent.split("&");
                Integer reboot = 0;
                Integer restore = 0;
                for (String s1 : split) {
                    if (s1.contains("macaddr=")) {
                        nvrMac = s1.replace("macaddr=", "");
                    }
                    if (s1.contains("reboot=")) {
                        reboot = Integer.valueOf(s1.replace("reboot=", ""));
                    }
                    if (!s1.contains("restore=")) continue;
                    restore = Integer.valueOf(s1.replace("restore=", ""));
                }
                reqMap.put("reboot", reboot);
                reqMap.put("restore", restore);
                msgContent = IotJsonUtils.beanToJsonString(reqMap);
            } else if (requestName.startsWith("snapshot") || requestName.startsWith("patrol") || requestName.startsWith("sysmanage") || requestName.startsWith("modifyDeviceInfo")) {
                String[] split;
                for (String s1 : split = msgContent.split("&")) {
                    if (!s1.contains("macaddr=")) continue;
                    nvrMac = s1.replace("macaddr=", "");
                    break;
                }
            }
        }
        return this.sendToDms2(requestName, nvrMac, msgContent, null);
    }

    public String sendToDms2(String requestName, String nvrMac, String jsonString, Integer requestTimeOut) {
        String url = this.ovoIotConfig.getDmsProxyUrl() + "/api/proxy/dms2/{0}/{1}?timeout=60";
        String format = MessageFormat.format(url, nvrMac, requestName);
        log.info("dms2 url:{},body:{}", (Object)format, (Object)jsonString);
        String body = null;
        try {
            body = this.sendPostRequest(format, jsonString);
            log.info("dms2 {},\u8fd4\u56de:{}", (Object)requestName, (Object)body);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            LogUtil.getStackTraceInfo(e);
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (StringUtils.isEmpty((Object)body)) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        Dms2Res dms2Res = IotJsonUtils.jsonToBean(body, Dms2Res.class);
        if (dms2Res == null) {
            log.error("dms2\u8bf7\u6c42\u5f02\u5e38,json\u8f6c\u6362\u5f02\u5e38,\u8fd4\u56de\u503c:{}", (Object)body);
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        String dmsErrno = dms2Res.getErrno();
        if (!Objects.equals("comm_success", dmsErrno)) {
            if (Objects.equals("resp_device_offline", dmsErrno)) {
                throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
            }
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        return BaseService.preseStr(dms2Res.getData());
    }

    public static String preseStr(String str) {
        log.info(str);
        return str.trim().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\"\t", "\"").replaceAll("\t\"", "\"").trim();
    }

    private String sendPostRequest(String url, String json) throws IOException {
        MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
        RequestBody body = json == null ? RequestBody.create((String)"", (MediaType)JSON) : RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + String.valueOf(response));
            }
            String string = response.body() != null ? response.body().string() : null;
            return string;
        }
    }

    public String sendToDms2CommonReturnString(String requestName, String nvrMac, String jsonString, Integer requestTimeOut) {
        String url = this.ovoIotConfig.getDmsProxyUrl() + "/api/proxy/dms2/{0}/{1}?timeout=60";
        String format = MessageFormat.format(url, nvrMac, requestName);
        log.info("dms2 url:{},body:{}", (Object)format, (Object)jsonString);
        String body = null;
        try {
            body = this.sendPostRequest(format, jsonString);
            log.info("dms2 {},\u8fd4\u56de:{}", (Object)requestName, (Object)body);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            LogUtil.getStackTraceInfo(e);
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (StringUtils.isEmpty((Object)body)) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        return BaseService.preseStr(body);
    }
}

