/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.service;

import com.ovopark.device.thirdparty.ovoIot.model.dms.DmsStatusReq;
import com.ovopark.device.thirdparty.ovoIot.model.dms.DmsStatusRes;
import com.ovopark.device.thirdparty.ovoIot.service.DmsProxyFeign;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import feign.Request;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DmsProxyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmsProxyService.class);
    @Autowired
    private DmsProxyFeign dmsProxyFeign;

    public DmsStatusRes getMainDeviceStatus(String nvrMac, Integer dms2Flag, String platformIp) {
        DmsStatusReq mo = new DmsStatusReq();
        ArrayList<DmsStatusReq.DevicesBean> devices = new ArrayList<DmsStatusReq.DevicesBean>();
        DmsStatusReq.DevicesBean devicesBean = new DmsStatusReq.DevicesBean();
        devicesBean.setId(1);
        devicesBean.setMainMac(nvrMac);
        devicesBean.setParentFlag(1);
        devicesBean.setDmsType(dms2Flag == 1 ? "DMS2" : "DMS1");
        devicesBean.setPlatformIp(platformIp);
        devices.add(devicesBean);
        mo.setDevices(devices);
        Request.Options options = new Request.Options(2L, TimeUnit.SECONDS, 15L, TimeUnit.SECONDS, true);
        log.info("dmsProxyFeign getDeviceStatus param {}", (Object)IotJsonUtils.beanToJsonStringForLog(mo));
        try {
            DmsStatusRes deviceStatus = this.dmsProxyFeign.getDeviceStatus(mo, options);
            log.info("dmsProxyFeign getDeviceStatus result {}", (Object)IotJsonUtils.beanToJsonStringForLog(deviceStatus));
            return deviceStatus;
        }
        catch (Exception e) {
            log.error("dmsProxyFeign getDeviceStatus error", (Throwable)e);
            return null;
        }
    }
}

