/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2New1Res;
import com.ovopark.device.thirdparty.ovoIot.model.Fr3GetAudioParamRes;
import com.ovopark.device.thirdparty.ovoIot.model.Fr3SetAudioParamsReq;
import com.ovopark.device.thirdparty.ovoIot.model.Fr3SetAudioParamsRes;
import com.ovopark.device.thirdparty.ovoIot.model.ResultRes;
import com.ovopark.device.thirdparty.ovoIot.model.SetPflowMultiCamCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.SocketBaseReq;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.req.PflowPeriodCompareLevelReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetPflowReidCfgReq;
import com.ovopark.device.thirdparty.ovoIot.service.BaseService;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import java.text.MessageFormat;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class Pc8Service {
    @Autowired
    private BaseService baseService;

    public ResultRes setPflowPeriodCompareLevel(String nvrMac, String upgradeServer, Integer upgradePort, List<PflowPeriodCompareLevelReq> req) {
        String reqName = MessageFormat.format("pu/{0}/setPflowPeriodCompareLevel", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(req));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        if (StringUtils.isEmpty((Object)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        try {
            return (ResultRes)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<ResultRes>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public ResultRes setPflowReidCfg(String nvrMac, String upgradeServer, Integer upgradePort, SetPflowReidCfgReq mo) {
        String reqName = MessageFormat.format("pu/{0}/setPflowReidCfg", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(mo));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setDmsFlag(0);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        if (StringUtils.isEmpty((Object)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return IotJsonUtils.jsonToBean(s, ResultRes.class);
    }

    public Dms2New1Res<SetPflowMultiCamCfgReq> getPflowMultiCamCfg(String mac, String upgradeServer, Integer upgradePort) {
        String reqName = MessageFormat.format("pu/{0}/getPflowMultiCamCfg", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setDmsFlag(0);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        try {
            return (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<SetPflowMultiCamCfgReq>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public Fr3SetAudioParamsRes fr3SetAudioParams(String mac, String upgradeServer, Integer upgradePort, Fr3SetAudioParamsReq req) {
        String reqName = MessageFormat.format("pu/{0}/fr3SetAudioParams", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(req));
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setDmsFlag(0);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        try {
            return (Fr3SetAudioParamsRes)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Fr3SetAudioParamsRes>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public Fr3GetAudioParamRes fr3GetAudioParams(String mac, String upgradeServer, Integer upgradePort) {
        String reqName = MessageFormat.format("pu/{0}/fr3GetAudioParams", mac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent("");
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setDmsFlag(0);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        try {
            return (Fr3GetAudioParamRes)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Fr3GetAudioParamRes>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }
}

