/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.device.thirdparty.ovoIot.model.AlarmConfig;
import com.ovopark.device.thirdparty.ovoIot.model.AlarmConfigTime;
import com.ovopark.device.thirdparty.ovoIot.model.AudioTalkReq;
import com.ovopark.device.thirdparty.ovoIot.model.DelAlgoActivateReq;
import com.ovopark.device.thirdparty.ovoIot.model.DevPerformanceReq;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2BaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2New1Res;
import com.ovopark.device.thirdparty.ovoIot.model.ErrnoAndMsgRes;
import com.ovopark.device.thirdparty.ovoIot.model.GeneralDataStatusRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetAlarmCfg;
import com.ovopark.device.thirdparty.ovoIot.model.GetAlarmCfgBean;
import com.ovopark.device.thirdparty.ovoIot.model.GetAlarmCfgResult;
import com.ovopark.device.thirdparty.ovoIot.model.GetAudioVolumeRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetDevTimeCfgRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetDoorLockStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetMultiReidShareRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetPoEStatusRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetSwitchStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetTimeSyncStatusResult;
import com.ovopark.device.thirdparty.ovoIot.model.MacInfoBean;
import com.ovopark.device.thirdparty.ovoIot.model.RecDailyRes;
import com.ovopark.device.thirdparty.ovoIot.model.ResultRes;
import com.ovopark.device.thirdparty.ovoIot.model.SetDoorLockStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.SetMultiReidShareReq;
import com.ovopark.device.thirdparty.ovoIot.model.SocketBaseReq;
import com.ovopark.device.thirdparty.ovoIot.model.StartVideoCallRes;
import com.ovopark.device.thirdparty.ovoIot.model.SwitchDevRes;
import com.ovopark.device.thirdparty.ovoIot.model.VideoCallStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetChnStreamTypeRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetCpuOccupyRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetRoundPlayRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetVideoEncParamsReq;
import com.ovopark.device.thirdparty.ovoIot.model.dms.GetVideoEncParamsRes;
import com.ovopark.device.thirdparty.ovoIot.model.dms.MultiReidInitCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.dms.WebrtcP2pPushLiveReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.AddSwitchDevReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.CloudWatchPlayAudioReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.DelSwitchDevReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.DoorLockStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.NetBandwidthTestReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.NetTrackReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.PushTodoMsgEventReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetAVInterfaceCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetAlgoStandardItemReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetCloudGuardEventCBReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetCloudGuardStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetDevTimeCfgReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetNvrAlarmCfg;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetSwitchStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetTimerRecordTaskReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetWelcomeVideoReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.StartVideoCallReq;
import com.ovopark.device.thirdparty.ovoIot.service.BaseService;
import com.ovopark.device.thirdparty.ovoIot.util.AbilityUtil;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import com.ovopark.kernel.shared.job.TaskContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class NvrService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NvrService.class);
    public static String NVR_GET_ALARM_CFG = "pu/{0}/getAlarmCfg";
    @Autowired
    private BaseService baseService;

    public ResultRes setNvrAlarmCnfReq(String mac, SetNvrAlarmCfg alarmCnf, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/setNvrAlarmCnfReq", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(alarmCnf));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        ResultRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, ResultRes.class);
        }
        catch (Exception e) {
            log.error("setNvrAlarmCnfReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetPoEStatusRes> getNvrPoeStatus(String mac) {
        String s = this.baseService.sendToDms2("pu/" + mac + "/getPoEStatus", mac, null, null);
        try {
            return (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetPoEStatusRes>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
    }

    public Dms2BaseRes netBandwidthTest(String mac, NetBandwidthTestReq netBandwidthTestReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/netBandwidthTest", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(netBandwidthTestReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2BaseRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2BaseRes.class);
        }
        catch (Exception e) {
            log.error("netBandwidthTest error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2BaseRes netTrack(String mac, NetTrackReq netTrackReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/netTrack", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(netTrackReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2BaseRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2BaseRes.class);
        }
        catch (Exception e) {
            log.error("netTrack error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setAVInterfaceCfg(String mac, SetAVInterfaceCfgReq setAVInterfaceCfgReq) {
        String requstName = MessageFormat.format("pu/{0}/setAVInterfaceCfg", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(setAVInterfaceCfgReq));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2New1Res.class);
        }
        catch (Exception e) {
            log.error("setAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<SetAVInterfaceCfgReq> getAVInterfaceCfg(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getAVInterfaceCfg", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<SetAVInterfaceCfgReq>>(this){});
        }
        catch (Exception e) {
            log.error("getAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public AlarmConfig getAlarmConfig(Integer alarmType, Integer ioInputIndex, String server, Integer port, String nvrMac, String ipcMac, Integer ipcChannelId, Integer warningOpen, Integer dms2Flag) {
        AlarmConfig result = new AlarmConfig();
        GetAlarmCfg alarmJson = new GetAlarmCfg();
        ArrayList<MacInfoBean> macInfoList = new ArrayList<MacInfoBean>();
        MacInfoBean macInfo = new MacInfoBean();
        macInfo.setIpcmac(ipcMac);
        macInfo.setAlarmType(alarmType);
        macInfo.setChannelId(ipcChannelId);
        if (ioInputIndex != null) {
            macInfo.setIoinputIndex(ioInputIndex);
        }
        macInfoList.add(macInfo);
        alarmJson.setMacInfo(macInfoList);
        String msgContent = IotJsonUtils.beanToJsonString(alarmJson);
        String requstName = MessageFormat.format(NVR_GET_ALARM_CFG, nvrMac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(msgContent);
        req.setHost(server);
        req.setPort(port);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String resultMsg = this.baseService.sendRequestToRegGetStr(req);
        if (resultMsg != null) {
            GetAlarmCfgResult json = null;
            json = IotJsonUtils.jsonToBean(resultMsg, GetAlarmCfgResult.class);
            Integer resultCode = json.getResult();
            if (resultCode != null && "200000".equals(resultCode.toString())) {
                List<GetAlarmCfgBean> alarmCfg = json.getAlarmCfg();
                for (GetAlarmCfgBean alarmCfgBean : alarmCfg) {
                    if (!ipcMac.equals(alarmCfgBean.getIpcmac())) continue;
                    result.setIpcmac(ipcMac);
                    result.setAlarmType(alarmType);
                    result.setAlarmEnable(alarmCfgBean.getAlarmEnable());
                    SetNvrAlarmCfg.DateBean date = alarmCfgBean.getDate();
                    if (date != null) {
                        String start = date.getStart();
                        String end = date.getEnd();
                        result.setStartDate(start);
                        result.setEndDate(end);
                    }
                    List<SetNvrAlarmCfg.TimeBean> timePeriods = alarmCfgBean.getTime();
                    result.setTimes(NvrService.getTimeForPage(timePeriods));
                    Integer alarmInterval = alarmCfgBean.getAlarmInterval();
                    if (5 == alarmType) {
                        alarmInterval = alarmInterval / 60;
                    }
                    result.setAlarmNotify(alarmCfgBean.getAlarmNotify());
                    result.setAlarmInterval(alarmInterval);
                    result.setAlarmItvEnable(alarmCfgBean.getAlarmItvEnable());
                    if (alarmType == 3 || alarmType == 6 || alarmType == 5) {
                        result.setDetectionSensitivity(alarmCfgBean.getAlarmDetectionSensitivity());
                    }
                    if (alarmType == 3 || alarmType == 6 || alarmType == 5) {
                        result.setDetectionArea(alarmCfgBean.getAlarmArea());
                    }
                    result.setSnapshot(alarmCfgBean.getSnapshot());
                    result.setWarningOpen(warningOpen);
                    if (alarmType != 4 && alarmType != 6) continue;
                    result.setIoInputIndex(alarmCfgBean.getIoinputIndex());
                    result.setIoInputType(alarmCfgBean.getIoinputType());
                    result.setIoOuput(alarmCfgBean.getIoouput());
                }
            }
        }
        return result;
    }

    public static List<AlarmConfigTime> getTimeForPage(List<SetNvrAlarmCfg.TimeBean> times) {
        HashMap timeMap = new HashMap();
        if (!CollectionUtils.isEmpty(times)) {
            for (SetNvrAlarmCfg.TimeBean time : times) {
                Integer week = time.getWeek();
                List<SetNvrAlarmCfg.PeriodBean> periods = time.getPeriod();
                for (SetNvrAlarmCfg.PeriodBean period : periods) {
                    SetNvrAlarmCfg.PeriodBean newPeriod = new SetNvrAlarmCfg.PeriodBean(period.getStart(), period.getEnd());
                    ArrayList<Integer> weeks = (ArrayList<Integer>)timeMap.get(newPeriod);
                    if (CollectionUtils.isEmpty((Collection)weeks)) {
                        weeks = new ArrayList<Integer>();
                        timeMap.put(newPeriod, weeks);
                    }
                    if (weeks.contains(week)) continue;
                    weeks.add(week);
                }
            }
        }
        ArrayList<AlarmConfigTime> result = new ArrayList<AlarmConfigTime>();
        Set periodSet = timeMap.keySet();
        for (SetNvrAlarmCfg.PeriodBean period : periodSet) {
            AlarmConfigTime configTime = new AlarmConfigTime();
            String start = period.getStart().substring(0, 2) + ":" + period.getStart().substring(2, 4);
            configTime.setStartTime(start);
            String end = period.getEnd().substring(0, 2) + ":" + period.getEnd().substring(2, 4);
            configTime.setEndTime(end);
            configTime.setWeeks((List)timeMap.get(period));
            result.add(configTime);
        }
        return result;
    }

    public Dms2New1Res<MultiReidInitCfgReq> getMultiReidInitCfg(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getMultiReidInitCfg", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<MultiReidInitCfgReq>>(this){});
        }
        catch (Exception e) {
            log.error("getAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setMultiReidInitCfg(String mac, MultiReidInitCfgReq reqMo) {
        String requstName = MessageFormat.format("pu/{0}/setMultiReidInitCfg", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        ObjectMapper copy = IotJsonUtils.objectMapper.copy();
        copy.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String json = null;
        try {
            json = copy.writeValueAsString((Object)reqMo);
            log.info("json:{}", (Object)json);
        }
        catch (JsonProcessingException e) {
            throw new CommonException(ExceptionEnum.JSON_ERR);
        }
        req.setMsgContent(json);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<MultiReidInitCfgReq>>(this){});
        }
        catch (Exception e) {
            log.error("getAVInterfaceCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetRoundPlayRes> getRoundPlay(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getRoundPlay", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetRoundPlayRes>>(this){});
        }
        catch (Exception e) {
            log.error("getRoundPlay error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setRoundPlay(String mac, GetRoundPlayRes reqMo) {
        String requstName = MessageFormat.format("pu/{0}/setRoundPlay", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(reqMo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("setRoundPlay error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetChnStreamTypeRes> getChnStreamType(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getChnStreamType", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetChnStreamTypeRes>>(this){});
        }
        catch (Exception e) {
            log.error("getChnStreamType error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setChnStreamType(String mac, GetChnStreamTypeRes reqMo) {
        String requstName = MessageFormat.format("pu/{0}/setChnStreamType", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(reqMo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("setChnStreamType error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetCpuOccupyRes> getCpuOccupy(String mac) {
        String requstName = MessageFormat.format("pu/{0}/getCpuOccupy", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetCpuOccupyRes>>(this){});
        }
        catch (Exception e) {
            log.error("getCpuOccupy error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetVideoEncParamsRes getVideoEncParams(String nvrMac, GetVideoEncParamsReq req, String serverIp, Integer serverPort, Integer dms2Flag) {
        String reqName = MessageFormat.format("pu/{0}/getVideoEncParams", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(req));
        socketBaseReq.setHost(serverIp);
        socketBaseReq.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        socketBaseReq.setSessionId(String.valueOf(sessionId));
        socketBaseReq.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        GetVideoEncParamsRes getVideoEncParamsRes = null;
        try {
            getVideoEncParamsRes = IotJsonUtils.jsonToBean(s, GetVideoEncParamsRes.class);
        }
        catch (Exception e) {
            log.error("getVideoEncParams error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return getVideoEncParamsRes;
    }

    public Dms2New1Res setAlgoStandard(String mac, List<SetAlgoStandardItemReq> mo, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/setAlgoStandard", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        HashMap<String, List<SetAlgoStandardItemReq>> reqMap = new HashMap<String, List<SetAlgoStandardItemReq>>();
        reqMap.put("algoStandardPic", mo);
        req.setMsgContent(IotJsonUtils.beanToJsonString(reqMap));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        req.setHost(serverIp);
        req.setPort(serverPort);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("getCpuOccupy error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setTimerRecordTaskReq(String mac, List<SetTimerRecordTaskReq> mo, Integer dms2Flag, String server, Integer port) {
        for (SetTimerRecordTaskReq item : mo) {
            List<SetTimerRecordTaskReq.TimeSectionInfosDTO> timeSectionInfos = item.getTimeSectionInfos();
            if (timeSectionInfos == null || timeSectionInfos.isEmpty()) continue;
            for (SetTimerRecordTaskReq.TimeSectionInfosDTO dto : timeSectionInfos) {
                String begin = dto.getBegin();
                String end = dto.getEnd();
                if (io.micrometer.common.util.StringUtils.isNotBlank((String)begin) && begin.length() < 8) {
                    throw new CommonException(ExceptionEnum.PARAM_ERROR);
                }
                if (!io.micrometer.common.util.StringUtils.isNotBlank((String)end) || end.length() >= 8) continue;
                throw new CommonException(ExceptionEnum.PARAM_ERROR);
            }
        }
        String requstName = MessageFormat.format("pu/{0}/setTimerRecordTaskReq", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(mo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        req.setHost(server);
        req.setPort(port);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("setTimerRecordTaskReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<List<SetTimerRecordTaskReq>> getTimerRecordTaskReq(String mac, String server, Integer port, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/getTimerRecordTaskReq", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setHost(server);
        req.setPort(port);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<List<SetTimerRecordTaskReq>>>(this){});
        }
        catch (Exception e) {
            log.error("getTimerRecordTaskReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<String> webrtcP2pPushLiveReq(String mac, WebrtcP2pPushLiveReq req) {
        String s = this.baseService.sendToDms2(mac, "VCORE/rpc/v1/webrtc_p2p_push_live", IotJsonUtils.beanToJsonString(req), null);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<String>>(this){});
        }
        catch (Exception e) {
            log.error("webrtc_p2p_push_live error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public ResultRes setDevTimeCfg(String nvrMac, SetDevTimeCfgReq mo, String upgradeServer, Integer upgradePort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/setDevTimeCfg", nvrMac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setHost(upgradeServer);
        req.setPort(upgradePort);
        req.setMsgContent(IotJsonUtils.beanToJsonString(mo));
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        ResultRes resultRes = null;
        try {
            resultRes = (ResultRes)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<ResultRes>(this){});
        }
        catch (Exception e) {
            log.error("setDevTimeCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetDevTimeCfgRes getDevTimeCfg(String nvrMac, String upgradeServer, Integer upgradePort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/getDevTimeCfg", nvrMac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setHost(upgradeServer);
        req.setPort(upgradePort);
        req.setMsgContent(null);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        GetDevTimeCfgRes resultRes = null;
        try {
            resultRes = (GetDevTimeCfgRes)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<GetDevTimeCfgRes>(this){});
        }
        catch (Exception e) {
            log.error("getDevTimeCfg error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public ResultRes audioTalkReq(String nvrMac, AudioTalkReq req, String upgradeServer, Integer upgradePort) {
        String reqName = MessageFormat.format("pu/{0}/audioTalkReq", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(upgradeServer);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(req));
        socketBaseReq.setPort(upgradePort);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setDmsFlag(0);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        if (StringUtils.isEmpty((Object)s)) {
            throw new CommonException(ExceptionEnum.RESULT_FAILED);
        }
        if (s.contains("result=404001")) {
            throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
        }
        return IotJsonUtils.jsonToBean(s, ResultRes.class);
    }

    public GetDoorLockStateRes getDoorLockState(String mac) {
        String s = this.baseService.sendToDms2("devmanage/nvr/getDoorLockState", mac, null, null);
        GetDoorLockStateRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GetDoorLockStateRes.class);
        }
        catch (Exception e) {
            log.error("getDoorLockState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public SetDoorLockStateRes setDoorLockState(String mac, DoorLockStateReq req) {
        String s = this.baseService.sendToDms2("devmanage/nvr/setDoorLockState", mac, IotJsonUtils.beanToJsonString(req), null);
        SetDoorLockStateRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, SetDoorLockStateRes.class);
        }
        catch (Exception e) {
            log.error("setDoorLockState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GeneralDataStatusRes cloudWatchPlayAudio(String mac, CloudWatchPlayAudioReq req) {
        String s = this.baseService.sendToDms2("devmanage/nvr/playAudio", mac, IotJsonUtils.beanToJsonString(req), null);
        GeneralDataStatusRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GeneralDataStatusRes.class);
        }
        catch (Exception e) {
            log.error("cloudWatchPlayAudio error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public StartVideoCallRes startVideoCall(String mac, StartVideoCallReq req, String requestName) {
        String s = this.baseService.sendToDms2(requestName, mac, IotJsonUtils.beanToJsonString(req), null);
        StartVideoCallRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, StartVideoCallRes.class);
        }
        catch (Exception e) {
            log.error("setDoorLockState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public StartVideoCallRes stopVideoCall(String mac, StartVideoCallReq req, String requestName) {
        String s = this.baseService.sendToDms2(requestName, mac, null, null);
        StartVideoCallRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, StartVideoCallRes.class);
        }
        catch (Exception e) {
            log.error("setDoorLockState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetAudioVolumeRes getAudioVolume(String mac, Integer cardNum) {
        HashMap<String, Integer> req = new HashMap<String, Integer>();
        req.put("card", cardNum);
        String s = this.baseService.sendToDms2("devmanage/nvr/getAudioVolume", mac, IotJsonUtils.beanToJsonString(req), null);
        GetAudioVolumeRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GetAudioVolumeRes.class);
        }
        catch (Exception e) {
            log.error("getAudioVolume error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetAudioVolumeRes setAudioVolume(String mac, Integer cardNum, Integer aiVolume, Integer aoVolume) {
        HashMap<String, Integer> req = new HashMap<String, Integer>();
        req.put("card", cardNum);
        req.put("ai_volume", aiVolume);
        req.put("ao_volume", aoVolume);
        String s = this.baseService.sendToDms2("devmanage/nvr/setAudioVolume", mac, IotJsonUtils.beanToJsonString(req), null);
        GetAudioVolumeRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GetAudioVolumeRes.class);
        }
        catch (Exception e) {
            log.error("getAudioVolume error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GeneralDataStatusRes setCloudGuardEventCB(String mac, SetCloudGuardEventCBReq req) {
        String s = this.baseService.sendToDms2("devmanage/nvr/setCloudGuardEventCB", mac, IotJsonUtils.beanToJsonString(req), null);
        GeneralDataStatusRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GeneralDataStatusRes.class);
        }
        catch (Exception e) {
            log.error("setCloudGuardEventCB error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GeneralDataStatusRes setWelcomeVideo(String mac, SetWelcomeVideoReq req) {
        String s = this.baseService.sendToDms2("devmanage/nvr/setWelcomeVideo", mac, IotJsonUtils.beanToJsonString(req), null);
        GeneralDataStatusRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GeneralDataStatusRes.class);
        }
        catch (Exception e) {
            log.error("setWelcomeVideo error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public RecDailyRes getRecDaily(TaskContext taskContext, String nvrMac, String nvrExtendCapacity, Integer channelId, String ipcMac, Long startTime, Long endTime, String serverIp, Integer serverPort, Integer dms2Flag) {
        List<Long> longs;
        List<List<Long>> result;
        boolean supportDms2Flag;
        String msgContent = MessageFormat.format("mac={0}&ipcmac={1}|channelId={2}|starttime={3}|endtime={4}", nvrMac, ipcMac, channelId, startTime.toString(), endTime.toString());
        if (io.micrometer.common.util.StringUtils.isEmpty((String)nvrExtendCapacity) || !AbilityUtil.supportXvr(nvrExtendCapacity)) {
            msgContent = MessageFormat.format("mac={0}&ipcmac={1}|starttime={2}|endtime={3}", nvrMac, ipcMac, startTime.toString(), endTime.toString());
        }
        HashMap<String, Number> dmsReq = new HashMap<String, Number>();
        boolean bl = supportDms2Flag = dms2Flag == 1;
        if (supportDms2Flag) {
            dmsReq.put("channelId", channelId);
            dmsReq.put("starttime", startTime);
            dmsReq.put("endtime", endTime);
            msgContent = IotJsonUtils.beanToJsonString(dmsReq);
        }
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName((String)(supportDms2Flag ? "devmanage/nvr/getRecDailyList&" + nvrMac : "devmanage/nvr/getRecDailyList"));
        socketBaseReq.setMsgContent(msgContent);
        socketBaseReq.setHost(serverIp);
        socketBaseReq.setPort(serverPort);
        socketBaseReq.setNeed2n(false);
        socketBaseReq.setDmsFlag(dms2Flag);
        taskContext.requestDeviceUrl(socketBaseReq.getRequestName());
        taskContext.requestDeviceArgs(IotJsonUtils.beanToJsonString(socketBaseReq));
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        taskContext.requestDeviceUrl(s);
        RecDailyRes recDailyRes = new RecDailyRes();
        if (io.micrometer.common.util.StringUtils.isEmpty((String)s)) {
            recDailyRes.setResult(404003);
            return recDailyRes;
        }
        if (s.contains("result=404001")) {
            recDailyRes.setResult(404001);
            return recDailyRes;
        }
        RecDailyRes recDailyRes1 = IotJsonUtils.jsonToBean(s, RecDailyRes.class);
        if (recDailyRes1 == null) {
            recDailyRes.setResult(23333001);
            return recDailyRes;
        }
        RecDailyRes.ResultDetailBean resultDetail = recDailyRes1.getResultDetail();
        if (resultDetail != null && (result = resultDetail.getResult()) != null && !result.isEmpty() && (longs = result.get(0)) != null && longs.size() == 1) {
            resultDetail.setResult(new ArrayList<List<Long>>());
        }
        return recDailyRes1;
    }

    public Dms2New1Res<ErrnoAndMsgRes> delAlgoActivate(String nvrMac, List<String> algoNameList) {
        String reqName = MessageFormat.format("pu/{0}/delAlgoActivate", nvrMac);
        SocketBaseReq socketBaseReq = new SocketBaseReq(false);
        socketBaseReq.setRequestName(reqName);
        socketBaseReq.setHost(null);
        DelAlgoActivateReq req = new DelAlgoActivateReq();
        ArrayList<DelAlgoActivateReq.AlgoActivInfosDTO> algoActivInfosDTOS = new ArrayList<DelAlgoActivateReq.AlgoActivInfosDTO>(algoNameList.size());
        for (String algoName : algoNameList) {
            DelAlgoActivateReq.AlgoActivInfosDTO dto = new DelAlgoActivateReq.AlgoActivInfosDTO();
            dto.setAlgoName(algoName);
            algoActivInfosDTOS.add(dto);
        }
        if (CollectionUtils.isEmpty(algoActivInfosDTOS)) {
            throw new CommonException(ExceptionEnum.PARAM_ERROR);
        }
        req.setAlgoActivInfos(algoActivInfosDTOS);
        socketBaseReq.setMsgContent(IotJsonUtils.beanToJsonString(req));
        socketBaseReq.setPort(null);
        socketBaseReq.setRespTimeout(3000);
        socketBaseReq.setConnectTimeout(2000);
        socketBaseReq.setDmsFlag(1);
        String s = this.baseService.sendRequestToRegGetStr(socketBaseReq);
        try {
            return (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<ErrnoAndMsgRes>>(this){});
        }
        catch (JsonProcessingException e) {
            log.error("delAlgoActivate res :{}", (Object)s);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
    }

    public GeneralDataStatusRes setCloudGuardState(String mac, SetCloudGuardStateReq req) {
        String s = this.baseService.sendToDms2("devmanage/nvr/setCloudGuardState", mac, IotJsonUtils.beanToJsonString(req), null);
        GeneralDataStatusRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GeneralDataStatusRes.class);
        }
        catch (Exception e) {
            log.error("setCloudGuardState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res<GetMultiReidShareRes> getMultiReidShareCfg(String nvrMac) {
        String s = this.baseService.sendToDms2(MessageFormat.format("pu/{0}/getMultiReidShareCfg", nvrMac), nvrMac, null, null);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res<GetMultiReidShareRes>>(this){});
        }
        catch (Exception e) {
            log.error("json error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res setMultiReidShareCfg(String nvrMac, SetMultiReidShareReq req) {
        String s = this.baseService.sendToDms2(MessageFormat.format("pu/{0}/setMultiReidShareCfg", nvrMac), nvrMac, IotJsonUtils.beanToJsonString(req), null);
        Dms2New1Res resultRes = null;
        try {
            resultRes = (Dms2New1Res)IotJsonUtils.objectMapper.readValue(s, (TypeReference)new TypeReference<Dms2New1Res>(this){});
        }
        catch (Exception e) {
            log.error("json error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public SwitchDevRes.SearchSwitchDev searchSwitchDev(String nvrMac) {
        String s = this.baseService.sendToDms2("devmanage/nvr/searchSwitchDev", nvrMac, null, null);
        SwitchDevRes.SearchSwitchDev resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, SwitchDevRes.SearchSwitchDev.class);
        }
        catch (Exception e) {
            log.error("searchSwitchDev error", (Throwable)e);
            log.error("dms2\u8bf7\u6c42\u5f02\u5e38,json\u8f6c\u6362\u5f02\u5e38,\u8fd4\u56de\u503c:{}", (Object)s);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        if (resultRes == null) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (!Objects.equals(0, resultRes.getSearch_result())) {
            if (Objects.equals("1", resultRes.getSearch_result())) {
                throw new CommonException(ExceptionEnum.DEVICE_OFFLINE);
            }
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        return resultRes;
    }

    public SwitchDevRes.AddSwitchDev addSwitchDev(AddSwitchDevReq addSwitchDevReq, String nvrMac) {
        String s = this.baseService.sendToDms2("devmanage/nvr/addSwitchDev", nvrMac, IotJsonUtils.beanToJsonString(addSwitchDevReq), null);
        SwitchDevRes.AddSwitchDev resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, SwitchDevRes.AddSwitchDev.class);
        }
        catch (Exception e) {
            log.error("addSwitchDev error", (Throwable)e);
            log.error("dms2\u8bf7\u6c42\u5f02\u5e38,json\u8f6c\u6362\u5f02\u5e38,\u8fd4\u56de\u503c:{}", (Object)s);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        if (resultRes == null) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (!Objects.equals(200000, resultRes.getResult())) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        return resultRes;
    }

    public SwitchDevRes.DelSwitchDev delSwitchDev(DelSwitchDevReq delSwitchDevReq, String nvrMac) {
        String s = this.baseService.sendToDms2("devmanage/nvr/delSwitchDev", nvrMac, IotJsonUtils.beanToJsonString(delSwitchDevReq), null);
        SwitchDevRes.DelSwitchDev resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, SwitchDevRes.DelSwitchDev.class);
        }
        catch (Exception e) {
            log.error("delSwitchDev error", (Throwable)e);
            log.error("dms2\u8bf7\u6c42\u5f02\u5e38,json\u8f6c\u6362\u5f02\u5e38,\u8fd4\u56de\u503c:{}", (Object)s);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        if (resultRes == null) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (!Objects.equals(200000, resultRes.getResult())) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        if (!Objects.equals(200000, resultRes.getDel_result())) {
            throw new CommonException(ExceptionEnum.DMS_PROXY_ERR);
        }
        return resultRes;
    }

    public GeneralDataStatusRes setSwitchState(String mac, SetSwitchStateReq req) {
        String s = this.baseService.sendToDms2("devmanage/nvr/setSwitchState", mac, IotJsonUtils.beanToJsonString(req), null);
        GeneralDataStatusRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GeneralDataStatusRes.class);
        }
        catch (Exception e) {
            log.error("setSwitchState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetSwitchStateRes getSwitchState(String mac) {
        String s = this.baseService.sendToDms2("devmanage/nvr/getSwitchState", mac, null, null);
        GetSwitchStateRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GetSwitchStateRes.class);
        }
        catch (Exception e) {
            log.error("getSwitchState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public GetTimeSyncStatusResult getOnvifTimeSyncReq(String mac, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/getOnvifTimeSyncReq", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent("");
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        GetTimeSyncStatusResult resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, GetTimeSyncStatusResult.class);
        }
        catch (Exception e) {
            log.error("getOnvifTimeSyncReq error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public Dms2New1Res devPerformance(String mac, DevPerformanceReq devParam) {
        String reqName = "pu/" + mac + "/devPerformance";
        String s = this.baseService.sendToDms2(reqName, mac, IotJsonUtils.beanToJsonString(devParam), null);
        Dms2New1Res resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, Dms2New1Res.class);
        }
        catch (Exception e) {
            log.error("devPerformance error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public ResultRes pushTodoMsgEvent(String mac, PushTodoMsgEventReq pushTodoMsgEventReq, String serverIp, Integer serverPort, Integer dms2Flag) {
        String requstName = MessageFormat.format("pu/{0}/pushTodoMsgEvent", mac);
        SocketBaseReq req = new SocketBaseReq(false);
        req.setRequestName(requstName);
        req.setMsgContent(IotJsonUtils.beanToJsonString(pushTodoMsgEventReq));
        req.setHost(serverIp);
        req.setPort(serverPort);
        long sessionId = System.currentTimeMillis() + (long)new Random().nextInt();
        req.setSessionId(String.valueOf(sessionId));
        req.setDmsFlag(dms2Flag);
        String s = this.baseService.sendRequestToRegGetStr(req);
        ResultRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, ResultRes.class);
        }
        catch (Exception e) {
            log.error("pushTodoMsgEvent error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }

    public VideoCallStateRes videoCallState(String mac, StartVideoCallReq req, String requestName) {
        String s = this.baseService.sendToDms2(requestName, mac, IotJsonUtils.beanToJsonString(req), null);
        VideoCallStateRes resultRes = null;
        try {
            resultRes = IotJsonUtils.jsonToBean(s, VideoCallStateRes.class);
        }
        catch (Exception e) {
            log.error("videoCallState error", (Throwable)e);
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return resultRes;
    }
}

