/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.interceptor;

import com.ovopark.device.thirdparty.ovoIot.service.DmsFeign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DmsFeignRequestInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmsFeignRequestInterceptor.class);
    @Value(value="${myConfig.dmsToken:#{null}}")
    private String dmsToken;

    public void apply(RequestTemplate template) {
        Class targetType = template.feignTarget().type();
        if (DmsFeign.class.equals((Object)targetType)) {
            String requestId;
            if (this.dmsToken != null && !this.dmsToken.trim().isEmpty()) {
                template.header("Token", new String[]{this.dmsToken});
                log.debug("Added Token header for DMS request: {}", (Object)template.url());
            }
            if ((requestId = MDC.get((String)"requestId")) != null && !requestId.trim().isEmpty()) {
                template.header("requestId", new String[]{requestId});
                log.debug("Added requestId header for DMS request: {}", (Object)requestId);
            } else {
                log.warn("No requestId found in MDC for DMS request: {}", (Object)template.url());
            }
            this.printRequestParameters(template);
        }
    }

    private void printRequestParameters(RequestTemplate template) {
        try {
            byte[] body = template.body();
            if (body != null && body.length > 0) {
                String requestBody = new String(body);
                log.info("DMS Feign Request - URL: {}, Method: {}, Body: {}", new Object[]{template.url(), template.method(), requestBody});
            } else {
                log.info("DMS Feign Request - URL: {}, Method: {}, Body: empty", (Object)template.url(), (Object)template.method());
            }
            log.debug("DMS Feign Request Headers: {}", (Object)template.headers());
        }
        catch (Exception e) {
            log.warn("Failed to print DMS request parameters: {}", (Object)e.getMessage());
        }
    }
}

