/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.thirdparty.ovoIot.interceptor;

import com.ovopark.device.thirdparty.ovoIot.model.DmsModel;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsFeignResponseInterceptor
implements Decoder {
    private static final Logger log = LoggerFactory.getLogger(DmsFeignResponseInterceptor.class);
    private final Decoder decoder;

    public DmsFeignResponseInterceptor(Decoder decoder) {
        this.decoder = decoder;
    }

    public Object decode(Response response, Type type) throws IOException {
        Response processedResponse = response;
        if (this.isDmsFeignResponse(response)) {
            processedResponse = this.printResponseInfo(response, type);
        }
        try {
            return this.decoder.decode(processedResponse, type);
        }
        catch (Exception e) {
            if (this.isDmsFeignResponse(response)) {
                log.error("DMS Feign\u8c03\u7528\u5f02\u5e38 - URL: {}, \u5f02\u5e38\u4fe1\u606f: {}", (Object)response.request().url(), (Object)e.getMessage());
                return this.createErrorResponse(type);
            }
            throw e;
        }
    }

    private boolean isDmsFeignResponse(Response response) {
        try {
            String url = response.request().url();
            return url.contains("/api/gb/");
        }
        catch (Exception e) {
            log.warn("Failed to check if response is from DmsFeign: {}", (Object)e.getMessage());
            return false;
        }
    }

    private Response printResponseInfo(Response response, Type type) {
        try {
            int status = response.status();
            String url = response.request().url();
            log.info("DMS Feign Response Headers: {}", (Object)response.headers());
            if (response.body() != null) {
                byte[] bodyBytes = response.body().asInputStream().readAllBytes();
                String bodyContent = new String(bodyBytes, "UTF-8");
                log.info("DMS Feign Response - URL: {}, Status: {}, Body: {}", new Object[]{url, status, bodyContent});
                return Response.builder().status(response.status()).reason(response.reason()).headers(response.headers()).request(response.request()).body(bodyBytes).build();
            }
            log.info("DMS Feign Response - URL: {}, Status: {}, Body: empty", (Object)url, (Object)status);
            return response;
        }
        catch (Exception e) {
            log.warn("Failed to print DMS response info: {}", (Object)e.getMessage());
            return response;
        }
    }

    private DmsModel.BaseRes<Object> createErrorResponse(Type type) {
        if (type instanceof Class && DmsModel.BaseRes.class.isAssignableFrom((Class)type)) {
            DmsModel.BaseRes<Object> errorResponse = new DmsModel.BaseRes<Object>();
            errorResponse.setErrno("feign_call_error");
            errorResponse.setMsg("DMS\u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u6216\u670d\u52a1\u72b6\u6001");
            errorResponse.setData(null);
            return errorResponse;
        }
        log.warn("\u65e0\u6cd5\u4e3a\u7c7b\u578b {} \u521b\u5efa\u9519\u8bef\u54cd\u5e94\uff0c\u8fd4\u56denull", (Object)type.getTypeName());
        return null;
    }
}

