package com.ovopark.docking.api;

import com.ovopark.docking.mo.ImportUserMo;
import com.ovopark.docking.mo.SaveUserPrivilegesMo;
import com.ovopark.docking.pojo.PrivilegesPojo;
import com.ovopark.docking.pojo.UserPrivilegesPojo;
import com.ovopark.docking.response.BaseResult;
import com.ovopark.docking.vo.ModuleVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @description: 权限接口
 * @param:
 * @return:
 * @author
 * @date: 2020/11/13 13:47
 */
@FeignClient(value = "ovopark-privilege")
public interface PrivilegeApi {

	/**
	 * @description: 用户是否有某个权限
	 * @param: [userId, privilegeName]
	 * @return: com.ovopark.docking.server.common.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2020/11/13 13:39
	 */
	@GetMapping("/ovopark-docking/privilege/hasPrivileges")
	public BaseResult<Boolean> hasPrivileges(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId, @RequestParam(value = "privilege") String privilege);

	/**
	 * @description: 获取用户的指定权限
	 * @param: [userId, privilegeId]
	 * @return: com.ovopark.docking.server.common.response.BaseResult
	 * @author
	 * @date: 2020/11/13 13:36
	 */
	@GetMapping("/ovopark-docking/privilege/getPrivilegeByUserIdAndPrivilegeId")
	public BaseResult<PrivilegesPojo> getPrivilegeByUserAndPrivilegeId(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId, @RequestParam(value = "privilegeId") Integer privilegeId);

	/**
	 * @description: 获取用户的权限菜单
	 * @param: [user]
	 * @return: com.ovopark.docking.server.common.response.BaseResult
	 * @author
	 * @date: 2020/11/13 13:27
	 */
	@GetMapping("/ovopark-docking/privilege/getUserPrivileges")
	public BaseResult<List<PrivilegesPojo>> getUserPrivileges(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/**
	 * @description: 新增用户权限
	 * @param: [userPrivileges]
	 * @return: com.ovopark.docking.server.common.response.BaseResult<java.util.List<com.ovopark.docking.server.model.pojo.PrivilegesPojo>>
	 * @author
	 * @date: 2020/11/13 13:32
	 */
	@PostMapping("/ovopark-docking/privilege/insterUserPrivileges")
	public BaseResult<Boolean> insterUserPrivileges(@RequestBody UserPrivilegesPojo userPrivilege);

	/**
	 * @description: 批量新增用户权限
	 * @param: [userPrivileges]
	 * @return: com.ovopark.docking.server.common.response.BaseResult<java.util.List<com.ovopark.docking.server.model.pojo.PrivilegesPojo>>
	 * @author
	 * @date: 2020/11/13 13:43
	 */
	@PostMapping("/ovopark-docking/privilege/batchInsterUserPrivileges")
	public BaseResult<Boolean> batchInsterUserPrivileges(@RequestBody List<UserPrivilegesPojo> userPrivileges);

	/**
	 * @description: 保存用户的权限
	 * @param: [userId, privilegeIds, underEnterprise]
	 * @return: com.ovopark.docking.server.common.response.BaseResult
	 * @author
	 * @date: 2020/11/13 13:24
	 */
	@PostMapping("/ovopark-docking/privilege/saveUserPrivileges")
	public BaseResult<Boolean> saveUserPrivileges(@RequestBody SaveUserPrivilegesMo parameter);

	/**
	 * @description: 删除用户的所有权限
	 * @param: [userId]
	 * @return: com.ovopark.docking.server.common.response.BaseResult
	 * @author
	 * @date: 2020/11/13 13:25
	 */
	@PostMapping("/ovopark-docking/privilege/deleteUserPrivileges")
	public BaseResult<Boolean> deleteUserPrivileges(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/**
	 * @description: 删除用户的指定权限
	 * @param: [userId, privilegeId]
	 * @return: com.ovopark.docking.server.common.response.BaseResult
	 * @author
	 * @date: 2020/11/13 13:34
	 */
	@PostMapping("/ovopark-docking/privilege/deleteUserPrivilegesByUserAndPrivilegeId")
	public BaseResult<Boolean> deleteUserPrivilegesByUserAndPrivilegeId(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId, @RequestParam(value = "privilegeId") Integer privilegeId);

	/**
	 * @description: 更新用户权限
	 * @param: [userPrivilege]
	 * @return: com.ovopark.docking.server.common.response.BaseResult
	 * @author
	 * @date: 2020/11/13 13:46
	 */
	@PostMapping("/ovopark-docking/privilege/updateUserPrivileges")
	public BaseResult<Boolean> updateUserPrivileges(@RequestBody UserPrivilegesPojo userPrivilege);

	/**
	 * @description: 根据企业id获取权限列表
	 * @param: [groupId]
	 * @return: com.ovopark.docking.server.common.response.BaseResult<java.util.List<com.ovopark.docking.server.model.pojo.PrivilegesPojo>>
	 * @author
	 * @date: 2020/11/13 13:29
	 */
	@GetMapping("/ovopark-docking/privilege/getPrivilegesByGroupId")
	public BaseResult<List<PrivilegesPojo>> getPrivilegesByGroupId(@RequestParam(value = "groupId") Integer groupId);

	/** 
	 * @description: 获取用户有权限的模块
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.List<com.ovopark.docking.pojo.PrivilegesPojo>>
	 * @author
	 * @date: 2020/12/4 10:38
	 */ 
	@GetMapping("/ovopark-docking/privilege/getUserPrivilegesModule")
	public BaseResult<List<PrivilegesPojo>> getUserPrivilegesModule(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/** 
	 * @description: 保存企业权限
	 * @param: [parameter] Integer enterpriseId，String privilegeIds
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2020/12/15 16:30
	 */ 
	@PostMapping("/ovopark-docking/privilege/addEnterprisePrivilege")
	public BaseResult<Boolean> addEnterprisePrivilege(@RequestBody Map<String, Object> parameter);

	/**
	 * @description: 导入角色 更新权限
	 * @param: [parameter]
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2020/12/23 16:06
	 */
	@PostMapping("/ovopark-docking/privilege/importUser")
	public BaseResult<Boolean> importUser(@RequestBody ImportUserMo parameter);

	/** 
	 * @description: 保存管理者权限
	 * @param: [userId, roleId]
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2021/7/14 15:20
	 */ 
	@PostMapping("/ovopark-docking/privilege/saveUserManagersPrivilege")
	public BaseResult<Boolean> saveUserManagersPrivilege(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "roleId") Integer roleId);

	/**
	 * @description: 根据角色id获取所有的权限id
	 * @param: [roleIds, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2021/7/20 14:29
	 */
	@GetMapping("/ovopark-docking/privilege/getPrivilegeIdsByRoleIds")
	public BaseResult<List<Integer>> getPrivilegeIdsByRoleIds(@RequestParam(value = "roleIds") List<Integer> roleIds, @RequestParam(value = "groupId") Integer groupId);

	/** 
	 * @description: 获取所有的权限模块-埋点
	 * @param: [type 0全部1APP2WEB, isAppModule 1APP模块]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.List<com.ovopark.docking.vo.ModuleVo>>
	 * @author
	 * @date: 2021/8/13 15:57
	 */ 
	@GetMapping("/ovopark-docking/privilege/getModuleList")
	public BaseResult<List<ModuleVo>> getModuleList(@RequestParam(value = "type") Integer type, @RequestParam(value = "isAppModule", required = false)Integer isAppModule);
}
