package com.ovopark.docking.api;

import com.ovopark.docking.pojo.RolePojo;
import com.ovopark.docking.response.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @description: 用户接口
 * @param:
 * @return:
 * @author
 * @date: 2020/11/13 13:47
 */
@FeignClient(value = "ovopark-docking")
public interface RoleApi {

	/**
	 * @description: 获取当前用户所有的角色ID
	 * @param: [parameter]
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2021/5/27 14:28
	 */
	@GetMapping("/ovopark-docking/role/getRoleIdsByUser")
	public BaseResult<List<Integer>> getRoleIdsByUser(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/**
	 * @description: 获取当前用户所有的角色
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.List<com.ovopark.docking.pojo.RolePojo>>
	 * @author
	 * @date: 2021/6/4 10:40
	 */
	@GetMapping("/ovopark-docking/role/getRolesByUser")
	public BaseResult<List<RolePojo>> getRolesByUser(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/** 
	 * @description: 查询用户所属职级
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.pojo.RolePojo>
	 * @author
	 * @date: 2021/7/15 13:40
	 */ 
	@GetMapping("/ovopark-docking/role/getGradeByUser")
	public BaseResult<RolePojo> getGradeByUser(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/** 
	 * @description: 获取用户所属的职级 API
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.pojo.RolePojo>
	 * @author
	 * @date: 2021/7/20 9:40
	 */ 
	@GetMapping("/ovopark-docking/role/getGradesByUserId")
	public BaseResult<RolePojo> getGradesByUserId(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);
}
