package com.ovopark.docking.api;

import com.ovopark.docking.pojo.UsersPojo;
import com.ovopark.docking.response.BaseResult;
import com.ovopark.docking.vo.UsersVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @description: 用户接口
 * @param:
 * @return:
 * @author
 * @date: 2020/11/13 13:47
 */
@FeignClient(value = "ovopark-docking")
public interface UserApi {

	/**
	 * @description: 是否是超级管理员
	 * @param: [userId, privilegeId]
	 * @return: com.ovopark.docking.server.common.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2020/11/13 13:39
	 */
	@GetMapping("/ovopark-docking/user/isSuperAdmin")
	public BaseResult<Boolean> isSuperAdmin(@RequestParam(value = "userId") Integer userId, @RequestParam(required = false, value = "groupId") Integer groupId);

	/**
	 * @description: 是否是系统管理员
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.server.common.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2020/11/13 13:55
	 */
	@GetMapping("/ovopark-docking/user/isSystemAdmin")
	public BaseResult<Boolean> isSystemAdmin(@RequestParam(value = "userId") Integer userId, @RequestParam(required = false, value = "groupId") Integer groupId);

	/** 
	 * @description: 是否是账户管理用户
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2021/7/22 19:11
	 */ 
	@GetMapping("/ovopark-docking/user/isUserManagerRole")
	public BaseResult<Boolean> isUserManagerRole(@RequestParam(value = "userId") Integer userId, @RequestParam(required = false, value = "groupId") Integer groupId);

	/**
	 * @description: 获取当前角色的所有用户
	 * @param: [parameter]
	 * @return: com.ovopark.docking.response.BaseResult<java.lang.Boolean>
	 * @author
	 * @date: 2021/5/27 14:28
	 */
	@GetMapping("/ovopark-docking/user/getUserByRoleIds")
	public BaseResult<List<UsersPojo>> getUserByRoleIds(@RequestParam(value = "roleIds") String roleIds, @RequestParam(value = "groupId") Integer groupId);

	/** 
	 * @description: 获取用户
	 * @param: [userId]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.pojo.UsersPojo>
	 * @author
	 * @date: 2021/5/28 13:57
	 */ 
	@GetMapping("/ovopark-docking/user/getUsersById")
	public BaseResult<UsersPojo> getUsersById(@RequestParam(value = "userId") Integer userId);

	/** 
	 * @description: 获取多个用户
	 * @param: [userIds]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.List<com.ovopark.docking.pojo.UsersPojo>>
	 * @author
	 * @date: 2021/5/28 13:57
	 */ 
	@GetMapping("/ovopark-docking/user/getUsersListByIds")
	public BaseResult<List<UsersPojo>> getUsersListByIds(@RequestParam(value = "userIds") String userIds);

	/**
	 * @description: 获取多个用户
	 * @param: [userIdList]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.List<com.ovopark.docking.pojo.UsersPojo>>
	 * @author
	 * @date: 2021/8/24 19:41
	 */
	@GetMapping("/ovopark-docking/user/getUsersListByIdList")
	public BaseResult<List<UsersPojo>> getUsersListByIdList(@RequestParam(value = "userIdList") List<Integer> userIdList);

	/** 
	 * @description: 查询用户的某级领导
	 * @param: [userId, level 0自己]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.pojo.UsersPojo>
	 * @author
	 * @date: 2021/5/30 10:26
	 */ 
	@GetMapping("/ovopark-docking/user/getUserLeaderByNum")
	public BaseResult<UsersPojo> getUserLeaderByNum(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "level") Integer level);

	/**
	 * @description: 获取用户的所有领导
	 * @param: [userId, level 0自己]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.pojo.UsersPojo>
	 * @author
	 * @date: 2021/5/30 10:26
	 */
	@GetMapping("/ovopark-docking/user/getUserLeaderListByNum")
	public BaseResult<List<UsersPojo>> getUserLeaderListByNum(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "level") Integer level);

	/** 
	 * @description: 判断用户是哪些特殊角色
	 * @param: [userId, groupId]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.Map<java.lang.String,java.lang.Boolean>>
	 * @author
	 * @date: 2021/7/15 20:33
	 */ 
	@GetMapping("/ovopark-docking/user/getUserManagerRoleMap")
	public BaseResult<Map<String, Boolean>> getUserManagerRoleMap(@RequestParam(value = "userId") Integer userId, @RequestParam(value = "groupId") Integer groupId);

	/**
	 * @description: 获取企业下的所有店长
	 * @param: [enterpriseId]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.List<com.ovopark.docking.pojo.UsersPojo>>
	 * @author
	 * @date: 2021/8/5 19:42
	 */
	@GetMapping("/ovopark-docking/user/getEnterpriseStorers")
	public BaseResult<List<UsersPojo>> getEnterpriseStorers(@RequestParam(value = "enterpriseId") Integer enterpriseId);

	/**
	 * @description: 获取企业下的所有店长
	 * @param: [enterpriseIds]
	 * @return: com.ovopark.docking.response.BaseResult<java.util.Map<java.lang.Integer,java.util.List<com.ovopark.docking.pojo.UsersPojo>>>
	 * @author
	 * @date: 2021/8/10 20:13
	 */
	@GetMapping("/ovopark-docking/user/getEnterpriseStorersMap")
	public BaseResult<Map<Integer, List<UsersPojo>>> getEnterpriseStorersMap(@RequestParam(value = "enterpriseIds") List<Integer> enterpriseIds);

	/** 
	 * @description: 根据token获取用户信息
	 * @param: [token]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.vo.UsersVo>
	 * @author
	 * @date: 2021/8/12 13:07
	 */
	@GetMapping("/ovopark-docking/user/getUserByToken")
	public BaseResult<UsersVo> getUserByToken(@RequestParam(value = "token")String token);

	/** 
	 * @description: 获取用户详情包含角色-开放平台-API
	 * @param: [userId]
	 * @return: com.ovopark.docking.response.BaseResult<com.ovopark.docking.vo.UsersVo>
	 * @author
	 * @date: 2021/8/16 10:57
	 */ 
	@GetMapping("/ovopark-docking/user/getUserInfo")
	public BaseResult<UsersVo> getUserInfo(@RequestParam(value = "userId")Integer userId);

}
