/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.docking.api;

import com.ovopark.docking.mo.ImportUserMo;
import com.ovopark.docking.mo.SaveUserPrivilegesMo;
import com.ovopark.docking.pojo.PrivilegesPojo;
import com.ovopark.docking.pojo.UserPrivilegesPojo;
import com.ovopark.docking.response.BaseResult;
import com.ovopark.docking.vo.ModuleVo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="ovopark-privilege")
public interface PrivilegeApi {
    @GetMapping(value={"/ovopark-docking/privilege/hasPrivileges"})
    public BaseResult<Boolean> hasPrivileges(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2, @RequestParam(value="privilege") String var3);

    @GetMapping(value={"/ovopark-docking/privilege/getPrivilegeByUserIdAndPrivilegeId"})
    public BaseResult<PrivilegesPojo> getPrivilegeByUserAndPrivilegeId(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2, @RequestParam(value="privilegeId") Integer var3);

    @GetMapping(value={"/ovopark-docking/privilege/getUserPrivileges"})
    public BaseResult<List<PrivilegesPojo>> getUserPrivileges(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2);

    @PostMapping(value={"/ovopark-docking/privilege/insterUserPrivileges"})
    public BaseResult<Boolean> insterUserPrivileges(@RequestBody UserPrivilegesPojo var1);

    @PostMapping(value={"/ovopark-docking/privilege/batchInsterUserPrivileges"})
    public BaseResult<Boolean> batchInsterUserPrivileges(@RequestBody List<UserPrivilegesPojo> var1);

    @PostMapping(value={"/ovopark-docking/privilege/saveUserPrivileges"})
    public BaseResult<Boolean> saveUserPrivileges(@RequestBody SaveUserPrivilegesMo var1);

    @PostMapping(value={"/ovopark-docking/privilege/deleteUserPrivileges"})
    public BaseResult<Boolean> deleteUserPrivileges(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2);

    @PostMapping(value={"/ovopark-docking/privilege/deleteUserPrivilegesByUserAndPrivilegeId"})
    public BaseResult<Boolean> deleteUserPrivilegesByUserAndPrivilegeId(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2, @RequestParam(value="privilegeId") Integer var3);

    @PostMapping(value={"/ovopark-docking/privilege/updateUserPrivileges"})
    public BaseResult<Boolean> updateUserPrivileges(@RequestBody UserPrivilegesPojo var1);

    @GetMapping(value={"/ovopark-docking/privilege/getPrivilegesByGroupId"})
    public BaseResult<List<PrivilegesPojo>> getPrivilegesByGroupId(@RequestParam(value="groupId") Integer var1);

    @GetMapping(value={"/ovopark-docking/privilege/getUserPrivilegesModule"})
    public BaseResult<List<PrivilegesPojo>> getUserPrivilegesModule(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2);

    @PostMapping(value={"/ovopark-docking/privilege/addEnterprisePrivilege"})
    public BaseResult<Boolean> addEnterprisePrivilege(@RequestBody Map<String, Object> var1);

    @PostMapping(value={"/ovopark-docking/privilege/importUser"})
    public BaseResult<Boolean> importUser(@RequestBody ImportUserMo var1);

    @PostMapping(value={"/ovopark-docking/privilege/saveUserManagersPrivilege"})
    public BaseResult<Boolean> saveUserManagersPrivilege(@RequestParam(value="userId") Integer var1, @RequestParam(value="roleId") Integer var2);

    @GetMapping(value={"/ovopark-docking/privilege/getPrivilegeIdsByRoleIds"})
    public BaseResult<List<Integer>> getPrivilegeIdsByRoleIds(@RequestParam(value="roleIds") List<Integer> var1, @RequestParam(value="groupId") Integer var2);

    @GetMapping(value={"/ovopark-docking/privilege/getModuleList"})
    public BaseResult<List<ModuleVo>> getModuleList(@RequestParam(value="type") Integer var1, @RequestParam(value="isAppModule", required=false) Integer var2);
}

