package com.ovopark.marketing.common.model;

import org.slf4j.MDC;

public class BaseResult<T> {


	public void setErrCodeAndMsg(ExceptionEnum exceptionEnum) {
		String code = exceptionEnum.getCode();
		this.isError = !"0".equals(code);
		this.code = code;
		this.result = exceptionEnum.getMessage();
	}
	public BaseResult() {}

	private Boolean isError;
	private T data;
	private String code;
	private String result;
	private String requestId = MDC.get("requestId");

	public Boolean getIsError() {
		return isError;
	}

	public void setIsError(Boolean isError) {
		this.isError = isError;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getRequestId() {
		return requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public BaseResult(Boolean isError, T data, String code, String result) {
		this.isError = isError;
		this.data = data;
		this.code = code;
		this.result = result;
	}

	private static<T> BaseResult<T> getInstance(Boolean isError, T data, String code, String result){
		return new BaseResult<T>(isError, data, code, result);
	}

	public static<T> BaseResult<T> paramError(){
		return getInstance(true, null, ExceptionEnum.PARAM_ERROR.getCode(), ExceptionEnum.PARAM_ERROR.getMessage());
	}

	public static<T> BaseResult<T> exceptionError(){
		return getInstance(true, null, ExceptionEnum.RESULT_EXCEPTION.getCode(), ExceptionEnum.RESULT_EXCEPTION.getMessage());
	}

	public static<T> BaseResult<T> success(){
		return getInstance(false, null, ExceptionEnum.SUCCESS.getCode(), ExceptionEnum.SUCCESS.getMessage());
	}

	public static<T> BaseResult<T> success(T data){
		return getInstance(false, data, ExceptionEnum.SUCCESS.getCode(), ExceptionEnum.SUCCESS.getMessage());
	}

	public static<T> BaseResult<T> error(ExceptionEnum data){
		return getInstance(true, null, data.getCode(), data.getMessage());
	}

	public static<T> BaseResult<T> error(){
		return getInstance(true, null, ExceptionEnum.ERROR.getCode(), ExceptionEnum.ERROR.getMessage());
	}

	public static <T> BaseResult<T> error(T data) {
		return getInstance(true, data, ExceptionEnum.ERROR.getCode(), ExceptionEnum.ERROR.getMessage());
	}

	public static <T> BaseResult<T> error(T data, ExceptionEnum exception) {
		return getInstance(true, data, exception.getCode(), exception.getMessage());
	}

	@Override
	public String toString() {
		return "BaseResult{" +
				"isError=" + isError +
				", data=" + data +
				", code='" + code + '\'' +
				", result='" + result + '\'' +
				", requestId='" + requestId + '\'' +
				'}';
	}
}
