package com.ovopark.marketing.common.enums;

/**
 * @author : S.  J Y
 * @description
 * @date : 2024-08-05 09:33
 **/

public enum GestureEnum {

    ONE(1, "手势1"),
    TWO(2, "手势2"),
    THREE(3, "手势3"),
    FOUR(4, "手势4"),
    FIVE(5, "手势5");


    private Integer key;
    private String value;

    private GestureEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }
    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (GestureEnum e : GestureEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getValue();
            }
        }
        return null;
    }
}
