package com.ovopark.marketing.common.enums;

/**
 * @author : S.  J Y
 * @description 设备操作记录枚举
 * @date : 2024-08-19 09:33
 **/

public enum DeviceOperationEnum {

    DEVICE_ADD(1, "入网"),
    TASK_ADD(2, "添加任务"),
    TASK_DEL(3, "移除任务"),
    LABEL_ADD(4, "添加分类"),
    LABEL_DEL(5, "移除分类"),

    ;

    private Integer key;
    private String name;

    private DeviceOperationEnum(Integer key, String name) {
        this.key = key;
        this.name = name;
    }
    public Integer getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public static String getNameByKey(String key) {
        if (key == null) {
            return null;
        }
        for (DeviceOperationEnum e : DeviceOperationEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getName();
            }
        }
        return null;
    }
}
