package com.ovopark.marketing.common.enums;

/**
 * @author : S.  J Y
 * @description
 * @date : 2024-08-05 09:33
 **/

public enum GestureEnum {

    ONE("one", "手势1"),
    TWO("two", "手势2"),
    THREE("three", "手势3"),
    FOUR("four", "手势4"),
    FIVE("five", "手势5"),

//    LEFT("left", "手势左"),
//    RIGHT("right", "手势右"),
    ;


    private String key;
    private String value;

    private GestureEnum(String key, String value) {
        this.key = key;
        this.value = value;
    }
    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValueByKey(String key) {
        if (key == null) {
            return null;
        }
        for (GestureEnum e : GestureEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getValue();
            }
        }
        return null;
    }
}
