package com.ovopark.marketing.common.enums;


public enum YesNoEnum {

    NO(0, "否"),
    YES(1, "是");

    private Integer key;
    private String value;

    private YesNoEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (YesNoEnum e : YesNoEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getValue();
            }
        }
        return null;
    }

}
