package com.ovopark.marketing.common.enums;

/**
 * @author : S.  J Y
 * @description  xiaoyin任务类型
 * @date : 2024-08-19 09:33
 **/

public enum XiaoyinTaskTypeEnum {

    NORMAL(1, "常规任务"),
    TEMPORARY(2, "临时任务"),
    NEW(3, "新任务"),
    ;

    private Integer key;
    private String name;

    private XiaoyinTaskTypeEnum(Integer key, String name) {
        this.key = key;
        this.name = name;
    }
    public Integer getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public static String getNameByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (XiaoyinTaskTypeEnum e : XiaoyinTaskTypeEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getName();
            }
        }
        return null;
    }
}
