package com.ovopark.open.platform.sms.api.router;

import com.ovopark.open.platform.sms.api.ApiConstant;

import java.util.List;

/**
 * 默认路由 .
 * @author <a href="mailto:guyue375@outlook.com">Klaus.turbo</a>
 **/
public class DefaultSmsRouter implements SmsRouter {
    
    private final List<String> mainlandNationCode;
    
    public DefaultSmsRouter() {
        this.mainlandNationCode = List.of("+", "+86", "0086", "86");
    }
    
    @Override
    public String apply(String nationCode) {
        if (mainlandNationCode.contains(nationCode)) {
            return ApiConstant.DEFAULT_MAINLAND_SMS_ENDPOINT;
        }
        return ApiConstant.DEFAULT_OVERSEA_SMS_ENDPOINT;
    }
}
