/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.platform.sms.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.ovopark.open.platform.sms.api.router.DefaultSmsRouter;
import com.ovopark.open.platform.sms.api.router.SmsRouter;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

public class SendMessageAction {
    private String nationCode = "+86";
    private String phoneNum;
    private String templateCode;
    private String templateParamJson;
    private String encryptionResult;
    @JSONField(serialize=false)
    private Map<String, String> nationCodeRoutingTable = new HashMap<String, String>();
    @JSONField(serialize=false)
    private SmsRouter smsRouter;
    @JSONField(serialize=false)
    private HttpClient httpClient;

    public HttpResponse<String> sendMessage() throws IOException, InterruptedException {
        String smsEndpoint = this.nationCodeRoutingTable.get(this.nationCode);
        if (StringUtils.isBlank((CharSequence)smsEndpoint)) {
            smsEndpoint = (String)this.smsRouter.apply(this.nationCode);
        }
        String smsAddress = smsEndpoint + "/api/ovopark/open/platform/sms/sendSms";
        HttpRequest request = HttpRequest.newBuilder(URI.create(smsAddress)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(JSON.toJSONString((Object)this))).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNationCode() {
        return this.nationCode;
    }

    public String getPhoneNum() {
        return this.phoneNum;
    }

    public String getTemplateCode() {
        return this.templateCode;
    }

    public String getTemplateParamJson() {
        return this.templateParamJson;
    }

    public String getEncryptionResult() {
        return this.encryptionResult;
    }

    public Map<String, String> getNationCodeRoutingTable() {
        return this.nationCodeRoutingTable;
    }

    public SmsRouter getSmsRouter() {
        return this.smsRouter;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String toString() {
        return "SendMessageAction(nationCode=" + this.getNationCode() + ", phoneNum=" + this.getPhoneNum() + ", templateCode=" + this.getTemplateCode() + ", templateParamJson=" + this.getTemplateParamJson() + ", encryptionResult=" + this.getEncryptionResult() + ", nationCodeRoutingTable=" + this.getNationCodeRoutingTable() + ", smsRouter=" + this.getSmsRouter() + ", httpClient=" + this.getHttpClient() + ")";
    }

    public static class Builder {
        private String nationCode = "+86";
        private String phoneNum;
        private String templateCode;
        private String templateParamJson;
        private Map<String, String> nationCodeRoutingTable;
        private String salt;
        private SmsRouter smsRouter;
        private HttpClient httpClient;

        public Builder nationCode(String nationCode) {
            this.nationCode = nationCode;
            return this;
        }

        public Builder phoneNum(String phoneNum) {
            this.phoneNum = phoneNum;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder templateParamJson(String templateParamJson) {
            this.templateParamJson = templateParamJson;
            return this;
        }

        public Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public Builder nationCodeRoutingTable(Map<String, String> nationCodeRoutingTable) {
            this.nationCodeRoutingTable = nationCodeRoutingTable;
            return this;
        }

        public Builder smsRouter(SmsRouter smsRouter) {
            this.smsRouter = smsRouter;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        private static String simpleSign(String key, String salt) {
            return DigestUtils.md5DigestAsHex((byte[])(key + salt).getBytes(StandardCharsets.UTF_8)).toUpperCase();
        }

        private String encrypt(String salt) {
            String key = String.join((CharSequence)" ", StringUtils.isBlank((CharSequence)this.nationCode) ? "" : this.nationCode, this.phoneNum, this.templateCode, this.templateParamJson);
            return Builder.simpleSign(key, salt);
        }

        public SendMessageAction build() {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.nationCode), (String)"\u533a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.phoneNum), (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.templateCode), (String)"\u963f\u91cc\u4e91\u77ed\u4fe1\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.templateParamJson), (String)"\u963f\u91cc\u4e91\u77ed\u4fe1\u6a21\u7248\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.salt), (String)"\u52a0\u5bc6salt\u4e0d\u80fd\u4e3a\u7a7a");
            SendMessageAction action = new SendMessageAction();
            action.nationCode = this.nationCode;
            action.phoneNum = this.phoneNum;
            action.templateCode = this.templateCode;
            action.templateParamJson = this.templateParamJson;
            if (Objects.nonNull(this.nationCodeRoutingTable) && !this.nationCodeRoutingTable.isEmpty()) {
                action.nationCodeRoutingTable.putAll(this.nationCodeRoutingTable);
            }
            action.encryptionResult = this.encrypt(this.salt);
            action.smsRouter = Objects.isNull(this.smsRouter) ? new DefaultSmsRouter() : this.smsRouter;
            action.httpClient = Objects.isNull(this.httpClient) ? HttpClient.newBuilder().build() : this.httpClient;
            return action;
        }
    }
}

