/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.privilege.response;

import com.ovopark.privilege.response.ExceptionEnum;
import java.io.Serializable;
import org.slf4j.MDC;

public class BaseResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean isError;
    private T data;
    private String code;
    private String message;
    private String requestId = MDC.get((String)"requestId");

    public void setErrCodeAndMsg(ExceptionEnum exceptionEnum) {
        String code = exceptionEnum.getCode();
        this.isError = !"0".equals(code);
        this.code = code;
        this.message = exceptionEnum.getMessage();
    }

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    private static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, ExceptionEnum.PARAM_ERROR.getCode(), ExceptionEnum.PARAM_ERROR.getMessage());
    }

    public static <T> BaseResult<T> exceptionError() {
        return BaseResult.getInstance(true, null, ExceptionEnum.RESULT_EXCEPTION.getCode(), ExceptionEnum.RESULT_EXCEPTION.getMessage());
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, ExceptionEnum.SUCCESS.getCode(), ExceptionEnum.SUCCESS.getMessage());
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, ExceptionEnum.SUCCESS.getCode(), ExceptionEnum.SUCCESS.getMessage());
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, ExceptionEnum.ERROR.getCode(), ExceptionEnum.ERROR.getMessage());
    }

    public static <T> BaseResult<T> error(T data) {
        return BaseResult.getInstance(true, data, ExceptionEnum.ERROR.getCode(), ExceptionEnum.ERROR.getMessage());
    }

    public static <T> BaseResult<T> error(ExceptionEnum data) {
        return BaseResult.getInstance(true, null, data.getCode(), data.getMessage());
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public static <T> BaseResult<T> invalidToken() {
        return new BaseResult<Object>(true, null, "9990001", "TOKEN_NOT_EXIST");
    }

    public static <T> BaseResult<T> expiredToken() {
        return new BaseResult<Object>(true, null, "9990002", "TOKEN_EXPIRATION");
    }

    public static <T> BaseResult<T> refreshExpiredToken() {
        return new BaseResult<Object>(true, null, "9990003", "TOKEN_REFRESH_EXPIRATION");
    }

    public static <T> BaseResult<T> parameterError() {
        return new BaseResult<Object>(true, null, "9990004", "PARAMETER_ERROR");
    }
}

