package com.ovopark.privilege.common.support;

import com.ovopark.shopweb.service.ImService;
import com.ovopark.shopweb.service.ModuleIconService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.remoting.caucho.HessianProxyFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class HessianProxyFactory {

    @Value("${myconfig.shopweb.server-url::#{null}}")
    private String shopwebServerUrl;

    @Bean
    public HessianProxyFactoryBean moduleIconServiceClient(){
        HessianProxyFactoryBean factoryBean = new HessianProxyFactoryBean();
        factoryBean.setServiceUrl(shopwebServerUrl+"/moduleIconService");
        factoryBean.setServiceInterface(ModuleIconService.class);
        return factoryBean;
    }

    @Bean
    public HessianProxyFactoryBean imServiceClient(){
        HessianProxyFactoryBean factoryBean = new HessianProxyFactoryBean();
        factoryBean.setServiceUrl(shopwebServerUrl+"/imService");
        factoryBean.setServiceInterface(ImService.class);
        return factoryBean;
    }
}
