package com.ovopark.privilege.common.support;

import com.ovopark.privilege.common.utils.NationalizationUtils;
import lombok.Data;

import java.util.Locale;

/**
 * request 中解析出来的数据 目前是通过token获取的后期会变成 request透传
 */
@Data
public class StorageInfo {

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 语言
     */
    private String lang = NationalizationUtils.DEFAULT_LANG;

    /**
     * 地区
     */
    private Locale locale = Locale.SIMPLIFIED_CHINESE;

    /**
     * 时区
     */
    private String timeZone = NationalizationUtils.DEFAULT_TIME_ZONE;

    private String client;

    private String token;

    /**
     * 版本
     */
    private String version;

    private Integer groupId;

    /**
     * ip
     */
    private String remoteIp;
    
    /**
     * web  Android  ios
     */
    private String userPlatform;
}
