package com.ovopark.privilege.common.utils;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * 自定义集合工具类
 * @author huanglt
 */
public class CollectionUtil extends CollectionUtils {
	public static List<Integer> StringToList(String content,String split){
		List reuslt = new ArrayList();
		if(StringUtils.isNotBlank(content)){
			String[] arr=  content.split(split);
			for(String obj : arr){
				if(StringUtils.isNotBlank(obj)){
					reuslt.add(Integer.parseInt(obj.trim()));
				}
			}
		}
		return reuslt;
	}
     public static List<String> String2List(String content,String split){
    	 List reuslt = new ArrayList();
    	 if(StringUtils.isNotBlank(content)){
    		 String[] arr=  content.split(split);
    		 for(String obj : arr){
    			 if(StringUtils.isNotBlank(obj)){
    				 reuslt.add(obj);
    			 }
    		 }
    	 }
		return reuslt;
     }
     public static String ListToString(List<Integer> datas,String split){
    	 if(CollectionUtils.isEmpty(datas)){
    		 return "";
    	 }
    	 StringBuffer sb = new StringBuffer();
    	 for(Integer data : datas){
    		 sb.append(data).append(split);
    	 }
    	 return sb.substring(0, sb.length()-1);
     }
     public static String ListToStr(List<Integer> datas){
    	 StringBuffer sb = new StringBuffer();
    	 for(Object data : datas){
    		 sb.append(data).append(",");
    	 }
    	 return sb.substring(0, sb.length()-1);
     }
     public static String ListToString(List<String> datas){
    	StringBuffer sb = new StringBuffer();
    	for(String data : datas){
    		sb.append("'").append(data).append("'").append(",");
    	}
		return sb.substring(0, sb.length()-1);
     }
     public static byte[] getMergeArray(byte[] aBytes,byte[] bBytes){
    	   byte[] result = new byte[aBytes.length+bBytes.length];  
           System.arraycopy(aBytes, 0, result, 0, aBytes.length);  
           System.arraycopy(bBytes, 0, result, aBytes.length, bBytes.length);  
    	 return result;
     } 
     /**
      * @param a
      * @param b
      * @return
      * @author huanglt
      */
     public static <T extends Comparable<T>> boolean compareList(List<T> a, List<T> b) {
    	    if(a.size() != b.size())
    	        return false;
    	    Collections.sort(a);
    	    Collections.sort(b);
    	    for(int i=0;i<a.size();i++){
    	        if(!a.get(i).equals(b.get(i)))
    	            return false;
    	    }
    	    return true;
    }
     /**
      * 去重并集
      * @param a
      * @param b
      * @return
      * @author huanglt
      */
     public static List  unionWithoutDup(Collection a, Collection b) {
    	 Collection unions =  CollectionUtils.union(a, b);
    	 List listWithoutDup = new ArrayList(new HashSet(unions));
    	 return listWithoutDup;
     }  
     
     /**
      * 去重并集 允许传null
      * @param a
      * @param b
      * @return
      * @author chx
      */
     public static List  unionWithoutDupPerNull(Collection a, Collection b) {
    	 if(CollectionUtils.isEmpty(a) && CollectionUtils.isEmpty(b)){
    		 return null;
    	 }else if(CollectionUtils.isEmpty(a)){
    		 return new ArrayList(new HashSet(b));
    	 }else if(CollectionUtils.isEmpty(b)){
    		 return new ArrayList(new HashSet(a));
    	 }else{
    		 return unionWithoutDup(a,b);
    	 }
     }  
     
     
     /**
      * 去重交集
      * @param a
      * @param b
      * @return
      * @author huanglt
      */
    public static List  intersectionWithoutDup(Collection a, Collection b) {
    	 Collection unions =  CollectionUtils.intersection(a, b);
    	 List listWithoutDup = new ArrayList(new HashSet(unions));
    	 return listWithoutDup;
    }  
    
    /**
     * 去重交集 允许传null
     * @param a
     * @param b
     * @return
     * @author chx
     */
    public static List  intersectionWithoutDupPerNull(Collection a, Collection b) {
   	 if(CollectionUtils.isEmpty(a) || CollectionUtils.isEmpty(b)){
   		 return null;
   	 }else{
   		 return intersectionWithoutDup(a,b);
   	 }
    } 
    
    public static List<Integer> CollStringToIntegerLst(List<String> inList){
        List<Integer> iList =new ArrayList<Integer>(inList.size());
        CollectionUtils.collect(inList, new Transformer(){
                    public Object transform(Object input){
                      return new Integer((String)input);
                    }
                  } ,iList );
        return iList;
    }

}
