package com.ovopark.privilege.common.utils;


import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
public class HttpUtils {

    public static String sendJsonToOtherServer(String url, Object data) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type","application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity(new StringEntity(JSONObject.toJSONString(data), Charset.forName("UTF-8")));

            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(30000).setConnectionRequestTimeout(30000)
                    .setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);

            CloseableHttpResponse response = httpclient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if(statusCode == 200){
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString(httpEntity);
                log.info("result = " + result);
            }else {
                log.error("send url = "+ url + " recv statusCode = " + statusCode);
            }
        } catch (Exception e) {
            log.error("sendJsonToOtherServer", e);
        }

        return result;
    }

    public static String sendPostToOtherServer(String url, Map<String, Object> params) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type","application/x-www-form-urlencoded; charset=UTF-8");
            List<org.apache.http.NameValuePair> pairList = new ArrayList<>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                org.apache.http.NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry
                        .getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(30000).setConnectionRequestTimeout(30000)
                    .setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);

            CloseableHttpResponse response = httpclient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if(statusCode == 200){
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString(httpEntity);
                log.info("result = " + result);
            }else {
                log.error("send url = "+ url + " recv statusCode = " + statusCode);
            }
        } catch (Exception e) {
            log.error("sendPostToOtherServer", e);
        }

        return result;
    }

    public static String sendGetToOtherServer(String url) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            httpPost.setHeader("Content-type","application/json; charset=utf-8");

            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(30000).setConnectionRequestTimeout(30000)
                    .setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);

            CloseableHttpResponse response = httpclient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if(statusCode == 200){
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString(httpEntity);
                log.info("result = " + result);
            }else {
                log.error("send url = "+ url + " recv statusCode = " + statusCode);
            }
        } catch (Exception e) {
            log.error("sendPostToOtherServer", e);
        }

        return result;
    }


    public static String sendJsonToOtherServerDefault(String url, Map<String,String> map) {

        // 创建httpClient对象
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(url);

        if(map != null && map.size() > 0) {

            NameValuePair[] nameValuePair = new NameValuePair[map.size()];
            int i = 0;
            for (String key : map.keySet()) {
                NameValuePair nameValuePairTmp = new NameValuePair();
                nameValuePair[i] = nameValuePairTmp;
                nameValuePair[i].setName(key);
                nameValuePair[i].setValue(map.get(key));
                i++;
            }

            post.setRequestBody(nameValuePair);
        }

        post.getParams().setParameter(
                HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");
        HttpConnectionManagerParams managerParams = client
                .getHttpConnectionManager().getParams();
        // 设置连接超时时间(单位毫秒)
        managerParams.setConnectionTimeout(60000);
        // 设置读数据超时时间(单位毫秒)
        managerParams.setSoTimeout(60000);

        try {
            // 发送数据
            int code=client.executeMethod(post);
            if (code==200) {
                return post.getResponseBodyAsString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            // 关闭连接
            post.releaseConnection();
        }

        return null;

    }

    public static byte[] getFileStream(String url){
        try {
            URL httpUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5 * 1000);
            // 通过输入流获取图片数据
            InputStream inStream = conn.getInputStream();
            // 得到图片的二进制数据
            byte[] btImg = readInputStream(inStream);
            return btImg;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception{
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while( (len=inStream.read(buffer)) != -1 ){
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

}
