package com.ovopark.privilege.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;


public class JsonUtils {

    public static ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

/*    public JsonUtils() {
        // 禁止时间格式序列化为时间戳
        if (objectMapper == null) {
            objectMapper = new ObjectMapper()
                    .findAndRegisterModules()
                    .disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
    }*/


    /**
     * json 转对象
     * @param jsonData
     * @param beanType
     * @param <T>
     * @return
     */
    public static <T>  T jsonToBean(String jsonData, Class<T> beanType){
        try {
            return objectMapper.readValue(jsonData, beanType);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String beanToJsonString(Object object){
        try {
            return objectMapper.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }



}
