package com.ovopark.privilege.common.utils;
import com.ovopark.privilege.config.MyConfig;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

@Slf4j
public class MessageUtils {

    private static String websocketUrl = MyConfig.getWebsocketUrl();

    private static final String messageSendUrl = "/websocket/sendMessageToUser";

    private static final String CLIENT_WEB = "web";

    /**
     * IM收到系统消息
     */
    private static final String TYPE_MSG_RECEIVE = "1000";

    /**
     * 消息推送
     */
    public static boolean sendMessageToUser(Map<String, String> map){
        try {
            // 推送
            HttpUtils.sendJsonToOtherServerDefault(websocketUrl + messageSendUrl, map);
            return true;
        } catch (Exception e) {
            log.error("消息推送异常",e);
            return false;
        }
    }
}
